/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContactReachabilityStatusResponse extends Route53DomainsResponse implements
        ToCopyableBuilder<GetContactReachabilityStatusResponse.Builder, GetContactReachabilityStatusResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(GetContactReachabilityStatusResponse::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetContactReachabilityStatusResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            STATUS_FIELD));

    private final String domainName;

    private final String status;

    private GetContactReachabilityStatusResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The domain name for which you requested the reachability status.
     * </p>
     * 
     * @return The domain name for which you requested the reachability status.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Whether the registrant contact has responded. Values include the following:
     * </p>
     * <dl>
     * <dt>PENDING</dt>
     * <dd>
     * <p>
     * We sent the confirmation email and haven't received a response yet.
     * </p>
     * </dd>
     * <dt>DONE</dt>
     * <dd>
     * <p>
     * We sent the email and got confirmation from the registrant contact.
     * </p>
     * </dd>
     * <dt>EXPIRED</dt>
     * <dd>
     * <p>
     * The time limit expired before the registrant contact responded.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReachabilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Whether the registrant contact has responded. Values include the following:</p>
     *         <dl>
     *         <dt>PENDING</dt>
     *         <dd>
     *         <p>
     *         We sent the confirmation email and haven't received a response yet.
     *         </p>
     *         </dd>
     *         <dt>DONE</dt>
     *         <dd>
     *         <p>
     *         We sent the email and got confirmation from the registrant contact.
     *         </p>
     *         </dd>
     *         <dt>EXPIRED</dt>
     *         <dd>
     *         <p>
     *         The time limit expired before the registrant contact responded.
     *         </p>
     *         </dd>
     * @see ReachabilityStatus
     */
    public final ReachabilityStatus status() {
        return ReachabilityStatus.fromValue(status);
    }

    /**
     * <p>
     * Whether the registrant contact has responded. Values include the following:
     * </p>
     * <dl>
     * <dt>PENDING</dt>
     * <dd>
     * <p>
     * We sent the confirmation email and haven't received a response yet.
     * </p>
     * </dd>
     * <dt>DONE</dt>
     * <dd>
     * <p>
     * We sent the email and got confirmation from the registrant contact.
     * </p>
     * </dd>
     * <dt>EXPIRED</dt>
     * <dd>
     * <p>
     * The time limit expired before the registrant contact responded.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReachabilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Whether the registrant contact has responded. Values include the following:</p>
     *         <dl>
     *         <dt>PENDING</dt>
     *         <dd>
     *         <p>
     *         We sent the confirmation email and haven't received a response yet.
     *         </p>
     *         </dd>
     *         <dt>DONE</dt>
     *         <dd>
     *         <p>
     *         We sent the email and got confirmation from the registrant contact.
     *         </p>
     *         </dd>
     *         <dt>EXPIRED</dt>
     *         <dd>
     *         <p>
     *         The time limit expired before the registrant contact responded.
     *         </p>
     *         </dd>
     * @see ReachabilityStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContactReachabilityStatusResponse)) {
            return false;
        }
        GetContactReachabilityStatusResponse other = (GetContactReachabilityStatusResponse) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetContactReachabilityStatusResponse").add("DomainName", domainName())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContactReachabilityStatusResponse, T> g) {
        return obj -> g.apply((GetContactReachabilityStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetContactReachabilityStatusResponse> {
        /**
         * <p>
         * The domain name for which you requested the reachability status.
         * </p>
         * 
         * @param domainName
         *        The domain name for which you requested the reachability status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Whether the registrant contact has responded. Values include the following:
         * </p>
         * <dl>
         * <dt>PENDING</dt>
         * <dd>
         * <p>
         * We sent the confirmation email and haven't received a response yet.
         * </p>
         * </dd>
         * <dt>DONE</dt>
         * <dd>
         * <p>
         * We sent the email and got confirmation from the registrant contact.
         * </p>
         * </dd>
         * <dt>EXPIRED</dt>
         * <dd>
         * <p>
         * The time limit expired before the registrant contact responded.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        Whether the registrant contact has responded. Values include the following:</p>
         *        <dl>
         *        <dt>PENDING</dt>
         *        <dd>
         *        <p>
         *        We sent the confirmation email and haven't received a response yet.
         *        </p>
         *        </dd>
         *        <dt>DONE</dt>
         *        <dd>
         *        <p>
         *        We sent the email and got confirmation from the registrant contact.
         *        </p>
         *        </dd>
         *        <dt>EXPIRED</dt>
         *        <dd>
         *        <p>
         *        The time limit expired before the registrant contact responded.
         *        </p>
         *        </dd>
         * @see ReachabilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReachabilityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Whether the registrant contact has responded. Values include the following:
         * </p>
         * <dl>
         * <dt>PENDING</dt>
         * <dd>
         * <p>
         * We sent the confirmation email and haven't received a response yet.
         * </p>
         * </dd>
         * <dt>DONE</dt>
         * <dd>
         * <p>
         * We sent the email and got confirmation from the registrant contact.
         * </p>
         * </dd>
         * <dt>EXPIRED</dt>
         * <dd>
         * <p>
         * The time limit expired before the registrant contact responded.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        Whether the registrant contact has responded. Values include the following:</p>
         *        <dl>
         *        <dt>PENDING</dt>
         *        <dd>
         *        <p>
         *        We sent the confirmation email and haven't received a response yet.
         *        </p>
         *        </dd>
         *        <dt>DONE</dt>
         *        <dd>
         *        <p>
         *        We sent the email and got confirmation from the registrant contact.
         *        </p>
         *        </dd>
         *        <dt>EXPIRED</dt>
         *        <dd>
         *        <p>
         *        The time limit expired before the registrant contact responded.
         *        </p>
         *        </dd>
         * @see ReachabilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReachabilityStatus
         */
        Builder status(ReachabilityStatus status);
    }

    static final class BuilderImpl extends Route53DomainsResponse.BuilderImpl implements Builder {
        private String domainName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContactReachabilityStatusResponse model) {
            super(model);
            domainName(model.domainName);
            status(model.status);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReachabilityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetContactReachabilityStatusResponse build() {
            return new GetContactReachabilityStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
