/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ListOperations request includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOperationsRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<ListOperationsRequest.Builder, ListOperationsRequest> {
    private static final SdkField<Instant> SUBMITTED_SINCE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmittedSince").getter(getter(ListOperationsRequest::submittedSince))
            .setter(setter(Builder::submittedSince))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedSince").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListOperationsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(ListOperationsRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final SdkField<List<String>> STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Status")
            .getter(getter(ListOperationsRequest::statusAsStrings))
            .setter(setter(Builder::statusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TYPE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Type")
            .getter(getter(ListOperationsRequest::typeAsStrings))
            .setter(setter(Builder::typeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListOperationsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListOperationsRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBMITTED_SINCE_FIELD,
            MARKER_FIELD, MAX_ITEMS_FIELD, STATUS_FIELD, TYPE_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private final Instant submittedSince;

    private final String marker;

    private final Integer maxItems;

    private final List<String> status;

    private final List<String> type;

    private final String sortBy;

    private final String sortOrder;

    private ListOperationsRequest(BuilderImpl builder) {
        super(builder);
        this.submittedSince = builder.submittedSince;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.status = builder.status;
        this.type = builder.type;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * An optional parameter that lets you get information about all the operations that you submitted after a specified
     * date and time. Specify the date and time in Unix time format and Coordinated Universal time (UTC).
     * </p>
     * 
     * @return An optional parameter that lets you get information about all the operations that you submitted after a
     *         specified date and time. Specify the date and time in Unix time format and Coordinated Universal time
     *         (UTC).
     */
    public final Instant submittedSince() {
        return submittedSince;
    }

    /**
     * <p>
     * For an initial request for a list of operations, omit this element. If the number of operations that are not yet
     * complete is greater than the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code>
     * to return additional operations. Get the value of <code>NextPageMarker</code> from the previous response, and
     * submit another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.
     * </p>
     * 
     * @return For an initial request for a list of operations, omit this element. If the number of operations that are
     *         not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use
     *         <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code> from
     *         the previous response, and submit another request that includes the value of <code>NextPageMarker</code>
     *         in the <code>Marker</code> element.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * Number of domains to be returned.
     * </p>
     * <p>
     * Default: 20
     * </p>
     * 
     * @return Number of domains to be returned.</p>
     *         <p>
     *         Default: 20
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The status of the operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return The status of the operations.
     */
    public final List<OperationStatus> status() {
        return OperationStatusListCopier.copyStringToEnum(status);
    }

    /**
     * For responses, this returns true if the service returned a value for the Status property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatus() {
        return status != null && !(status instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of the operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return The status of the operations.
     */
    public final List<String> statusAsStrings() {
        return status;
    }

    /**
     * <p>
     * An arrays of the domains operation types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasType} method.
     * </p>
     * 
     * @return An arrays of the domains operation types.
     */
    public final List<OperationType> type() {
        return OperationTypeListCopier.copyStringToEnum(type);
    }

    /**
     * For responses, this returns true if the service returned a value for the Type property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasType() {
        return type != null && !(type instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An arrays of the domains operation types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasType} method.
     * </p>
     * 
     * @return An arrays of the domains operation types.
     */
    public final List<String> typeAsStrings() {
        return type;
    }

    /**
     * <p>
     * The sort type for returned values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListOperationsSortAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The sort type for returned values.
     * @see ListOperationsSortAttributeName
     */
    public final ListOperationsSortAttributeName sortBy() {
        return ListOperationsSortAttributeName.fromValue(sortBy);
    }

    /**
     * <p>
     * The sort type for returned values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListOperationsSortAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The sort type for returned values.
     * @see ListOperationsSortAttributeName
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order for returned values, either ascending or descending.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for returned values, either ascending or descending.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for returned values, either ascending or descending.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for returned values, either ascending or descending.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(submittedSince());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatus() ? statusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasType() ? typeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsRequest)) {
            return false;
        }
        ListOperationsRequest other = (ListOperationsRequest) obj;
        return Objects.equals(submittedSince(), other.submittedSince()) && Objects.equals(marker(), other.marker())
                && Objects.equals(maxItems(), other.maxItems()) && hasStatus() == other.hasStatus()
                && Objects.equals(statusAsStrings(), other.statusAsStrings()) && hasType() == other.hasType()
                && Objects.equals(typeAsStrings(), other.typeAsStrings())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOperationsRequest").add("SubmittedSince", submittedSince()).add("Marker", marker())
                .add("MaxItems", maxItems()).add("Status", hasStatus() ? statusAsStrings() : null)
                .add("Type", hasType() ? typeAsStrings() : null).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubmittedSince":
            return Optional.ofNullable(clazz.cast(submittedSince()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsStrings()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsStrings()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOperationsRequest, T> g) {
        return obj -> g.apply((ListOperationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListOperationsRequest> {
        /**
         * <p>
         * An optional parameter that lets you get information about all the operations that you submitted after a
         * specified date and time. Specify the date and time in Unix time format and Coordinated Universal time (UTC).
         * </p>
         * 
         * @param submittedSince
         *        An optional parameter that lets you get information about all the operations that you submitted after
         *        a specified date and time. Specify the date and time in Unix time format and Coordinated Universal
         *        time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedSince(Instant submittedSince);

        /**
         * <p>
         * For an initial request for a list of operations, omit this element. If the number of operations that are not
         * yet complete is greater than the value that you specified for <code>MaxItems</code>, you can use
         * <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code> from the
         * previous response, and submit another request that includes the value of <code>NextPageMarker</code> in the
         * <code>Marker</code> element.
         * </p>
         * 
         * @param marker
         *        For an initial request for a list of operations, omit this element. If the number of operations that
         *        are not yet complete is greater than the value that you specified for <code>MaxItems</code>, you can
         *        use <code>Marker</code> to return additional operations. Get the value of <code>NextPageMarker</code>
         *        from the previous response, and submit another request that includes the value of
         *        <code>NextPageMarker</code> in the <code>Marker</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Number of domains to be returned.
         * </p>
         * <p>
         * Default: 20
         * </p>
         * 
         * @param maxItems
         *        Number of domains to be returned.</p>
         *        <p>
         *        Default: 20
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * The status of the operations.
         * </p>
         * 
         * @param status
         *        The status of the operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(Collection<String> status);

        /**
         * <p>
         * The status of the operations.
         * </p>
         * 
         * @param status
         *        The status of the operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(String... status);

        /**
         * <p>
         * The status of the operations.
         * </p>
         * 
         * @param status
         *        The status of the operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Collection<OperationStatus> status);

        /**
         * <p>
         * The status of the operations.
         * </p>
         * 
         * @param status
         *        The status of the operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(OperationStatus... status);

        /**
         * <p>
         * An arrays of the domains operation types.
         * </p>
         * 
         * @param type
         *        An arrays of the domains operation types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeWithStrings(Collection<String> type);

        /**
         * <p>
         * An arrays of the domains operation types.
         * </p>
         * 
         * @param type
         *        An arrays of the domains operation types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeWithStrings(String... type);

        /**
         * <p>
         * An arrays of the domains operation types.
         * </p>
         * 
         * @param type
         *        An arrays of the domains operation types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(Collection<OperationType> type);

        /**
         * <p>
         * An arrays of the domains operation types.
         * </p>
         * 
         * @param type
         *        An arrays of the domains operation types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(OperationType... type);

        /**
         * <p>
         * The sort type for returned values.
         * </p>
         * 
         * @param sortBy
         *        The sort type for returned values.
         * @see ListOperationsSortAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListOperationsSortAttributeName
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The sort type for returned values.
         * </p>
         * 
         * @param sortBy
         *        The sort type for returned values.
         * @see ListOperationsSortAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListOperationsSortAttributeName
         */
        Builder sortBy(ListOperationsSortAttributeName sortBy);

        /**
         * <p>
         * The sort order for returned values, either ascending or descending.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for returned values, either ascending or descending.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for returned values, either ascending or descending.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for returned values, either ascending or descending.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private Instant submittedSince;

        private String marker;

        private Integer maxItems;

        private List<String> status = DefaultSdkAutoConstructList.getInstance();

        private List<String> type = DefaultSdkAutoConstructList.getInstance();

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationsRequest model) {
            super(model);
            submittedSince(model.submittedSince);
            marker(model.marker);
            maxItems(model.maxItems);
            statusWithStrings(model.status);
            typeWithStrings(model.type);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final Instant getSubmittedSince() {
            return submittedSince;
        }

        public final void setSubmittedSince(Instant submittedSince) {
            this.submittedSince = submittedSince;
        }

        @Override
        public final Builder submittedSince(Instant submittedSince) {
            this.submittedSince = submittedSince;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final Collection<String> getStatus() {
            if (status instanceof SdkAutoConstructList) {
                return null;
            }
            return status;
        }

        public final void setStatus(Collection<String> status) {
            this.status = OperationStatusListCopier.copy(status);
        }

        @Override
        public final Builder statusWithStrings(Collection<String> status) {
            this.status = OperationStatusListCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusWithStrings(String... status) {
            statusWithStrings(Arrays.asList(status));
            return this;
        }

        @Override
        public final Builder status(Collection<OperationStatus> status) {
            this.status = OperationStatusListCopier.copyEnumToString(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(OperationStatus... status) {
            status(Arrays.asList(status));
            return this;
        }

        public final Collection<String> getType() {
            if (type instanceof SdkAutoConstructList) {
                return null;
            }
            return type;
        }

        public final void setType(Collection<String> type) {
            this.type = OperationTypeListCopier.copy(type);
        }

        @Override
        public final Builder typeWithStrings(Collection<String> type) {
            this.type = OperationTypeListCopier.copy(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeWithStrings(String... type) {
            typeWithStrings(Arrays.asList(type));
            return this;
        }

        @Override
        public final Builder type(Collection<OperationType> type) {
            this.type = OperationTypeListCopier.copyEnumToString(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder type(OperationType... type) {
            type(Arrays.asList(type));
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ListOperationsSortAttributeName sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOperationsRequest build() {
            return new ListOperationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
