/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53domains.model.DnssecSigningAttributes;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateDelegationSignerToDomainRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, AssociateDelegationSignerToDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(AssociateDelegationSignerToDomainRequest.getter(AssociateDelegationSignerToDomainRequest::domainName)).setter(AssociateDelegationSignerToDomainRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<DnssecSigningAttributes> SIGNING_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SigningAttributes").getter(AssociateDelegationSignerToDomainRequest.getter(AssociateDelegationSignerToDomainRequest::signingAttributes)).setter(AssociateDelegationSignerToDomainRequest.setter(Builder::signingAttributes)).constructor(DnssecSigningAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, SIGNING_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateDelegationSignerToDomainRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final DnssecSigningAttributes signingAttributes;

    private AssociateDelegationSignerToDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.signingAttributes = builder.signingAttributes;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final DnssecSigningAttributes signingAttributes() {
        return this.signingAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateDelegationSignerToDomainRequest)) {
            return false;
        }
        AssociateDelegationSignerToDomainRequest other = (AssociateDelegationSignerToDomainRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.signingAttributes(), other.signingAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateDelegationSignerToDomainRequest").add("DomainName", (Object)this.domainName()).add("SigningAttributes", (Object)this.signingAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "SigningAttributes": {
                return Optional.ofNullable(clazz.cast(this.signingAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("SigningAttributes", SIGNING_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateDelegationSignerToDomainRequest, T> g) {
        return obj -> g.apply((AssociateDelegationSignerToDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private DnssecSigningAttributes signingAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateDelegationSignerToDomainRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.signingAttributes(model.signingAttributes);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final DnssecSigningAttributes.Builder getSigningAttributes() {
            return this.signingAttributes != null ? this.signingAttributes.toBuilder() : null;
        }

        public final void setSigningAttributes(DnssecSigningAttributes.BuilderImpl signingAttributes) {
            this.signingAttributes = signingAttributes != null ? signingAttributes.build() : null;
        }

        @Override
        public final Builder signingAttributes(DnssecSigningAttributes signingAttributes) {
            this.signingAttributes = signingAttributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateDelegationSignerToDomainRequest build() {
            return new AssociateDelegationSignerToDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53DomainsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateDelegationSignerToDomainRequest> {
        public Builder domainName(String var1);

        public Builder signingAttributes(DnssecSigningAttributes var1);

        default public Builder signingAttributes(Consumer<DnssecSigningAttributes.Builder> signingAttributes) {
            return this.signingAttributes((DnssecSigningAttributes)((DnssecSigningAttributes.Builder)DnssecSigningAttributes.builder().applyMutation(signingAttributes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

