/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRoutingControlRequest extends Route53RecoveryControlConfigRequest implements
        ToCopyableBuilder<DeleteRoutingControlRequest.Builder, DeleteRoutingControlRequest> {
    private static final SdkField<String> ROUTING_CONTROL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingControlArn").getter(getter(DeleteRoutingControlRequest::routingControlArn))
            .setter(setter(Builder::routingControlArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("RoutingControlArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_CONTROL_ARN_FIELD));

    private final String routingControlArn;

    private DeleteRoutingControlRequest(BuilderImpl builder) {
        super(builder);
        this.routingControlArn = builder.routingControlArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the routing control that you're deleting.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the routing control that you're deleting.
     */
    public final String routingControlArn() {
        return routingControlArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routingControlArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRoutingControlRequest)) {
            return false;
        }
        DeleteRoutingControlRequest other = (DeleteRoutingControlRequest) obj;
        return Objects.equals(routingControlArn(), other.routingControlArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRoutingControlRequest").add("RoutingControlArn", routingControlArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoutingControlArn":
            return Optional.ofNullable(clazz.cast(routingControlArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRoutingControlRequest, T> g) {
        return obj -> g.apply((DeleteRoutingControlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53RecoveryControlConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteRoutingControlRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the routing control that you're deleting.
         * </p>
         * 
         * @param routingControlArn
         *        The Amazon Resource Name (ARN) of the routing control that you're deleting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingControlArn(String routingControlArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53RecoveryControlConfigRequest.BuilderImpl implements Builder {
        private String routingControlArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRoutingControlRequest model) {
            super(model);
            routingControlArn(model.routingControlArn);
        }

        public final String getRoutingControlArn() {
            return routingControlArn;
        }

        public final void setRoutingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
        }

        @Override
        public final Builder routingControlArn(String routingControlArn) {
            this.routingControlArn = routingControlArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRoutingControlRequest build() {
            return new DeleteRoutingControlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
