/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.route53recoverycontrolconfig.endpoints.Route53RecoveryControlConfigEndpointParams;
import software.amazon.awssdk.services.route53recoverycontrolconfig.endpoints.Route53RecoveryControlConfigEndpointProvider;
import software.amazon.awssdk.services.route53recoverycontrolconfig.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.route53recoverycontrolconfig.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.route53recoverycontrolconfig.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultRoute53RecoveryControlConfigEndpointProvider
implements Route53RecoveryControlConfigEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(Route53RecoveryControlConfigEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(Route53RecoveryControlConfigEndpointParams params, String region) {
        RuleResult result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule1(params);
        if (result.isResolved()) {
            return result;
        }
        return DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule6(params, region);
    }

    private static RuleResult endpointRule1(Route53RecoveryControlConfigEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            return DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule3(params);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(Route53RecoveryControlConfigEndpointParams params) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule6(Route53RecoveryControlConfigEndpointParams params, String region) {
        RuleResult result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule7(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule7(Route53RecoveryControlConfigEndpointParams params, String region) {
        if (region != null) {
            return DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule8(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(Route53RecoveryControlConfigEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            if ("aws".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53-recovery-control-config.us-west-2.amazonaws.com")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-west-2").build())).build());
            }
            if ("aws".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://arc-recovery-control-config.us-west-2.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion("us-west-2").build())).build());
            }
            RuleResult result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule11(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule15(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule19(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53-recovery-control-config." + partitionResult.implicitGlobalRegion() + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(partitionResult.implicitGlobalRegion()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(Route53RecoveryControlConfigEndpointParams params, RulePartition partitionResult) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule12(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(Route53RecoveryControlConfigEndpointParams params, RulePartition partitionResult) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53-recovery-control-config-fips." + partitionResult.implicitGlobalRegion() + "." + partitionResult.dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(partitionResult.implicitGlobalRegion()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(Route53RecoveryControlConfigEndpointParams params, RulePartition partitionResult) {
        if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            RuleResult result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule16(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(Route53RecoveryControlConfigEndpointParams params, RulePartition partitionResult) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53-recovery-control-config-fips." + partitionResult.implicitGlobalRegion() + "." + partitionResult.dnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(partitionResult.implicitGlobalRegion()).build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule19(Route53RecoveryControlConfigEndpointParams params, RulePartition partitionResult) {
        if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultRoute53RecoveryControlConfigEndpointProvider.endpointRule20(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(Route53RecoveryControlConfigEndpointParams params, RulePartition partitionResult) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://route53-recovery-control-config." + partitionResult.implicitGlobalRegion() + "." + partitionResult.dualStackDnsSuffix())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingRegion(partitionResult.implicitGlobalRegion()).build())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

