/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Recommendations that are provided to make an application more recovery resilient.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Recommendation implements SdkPojo, Serializable, ToCopyableBuilder<Recommendation.Builder, Recommendation> {
    private static final SdkField<String> RECOMMENDATION_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationText").getter(getter(Recommendation::recommendationText))
            .setter(setter(Builder::recommendationText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationText").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_TEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recommendationText;

    private Recommendation(BuilderImpl builder) {
        this.recommendationText = builder.recommendationText;
    }

    /**
     * <p>
     * Text of the recommendations that are provided to make an application more recovery resilient.
     * </p>
     * 
     * @return Text of the recommendations that are provided to make an application more recovery resilient.
     */
    public final String recommendationText() {
        return recommendationText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommendationText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation) obj;
        return Objects.equals(recommendationText(), other.recommendationText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Recommendation").add("RecommendationText", recommendationText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommendationText":
            return Optional.ofNullable(clazz.cast(recommendationText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Recommendation, T> g) {
        return obj -> g.apply((Recommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Recommendation> {
        /**
         * <p>
         * Text of the recommendations that are provided to make an application more recovery resilient.
         * </p>
         * 
         * @param recommendationText
         *        Text of the recommendations that are provided to make an application more recovery resilient.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationText(String recommendationText);
    }

    static final class BuilderImpl implements Builder {
        private String recommendationText;

        private BuilderImpl() {
        }

        private BuilderImpl(Recommendation model) {
            recommendationText(model.recommendationText);
        }

        public final String getRecommendationText() {
            return recommendationText;
        }

        public final void setRecommendationText(String recommendationText) {
            this.recommendationText = recommendationText;
        }

        @Override
        public final Builder recommendationText(String recommendationText) {
            this.recommendationText = recommendationText;
            return this;
        }

        @Override
        public Recommendation build() {
            return new Recommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
