/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessAsyncClient;
import software.amazon.awssdk.services.route53recoveryreadiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListResourceSetsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListResourceSetsResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ResourceSetOutput;

public class ListResourceSetsPublisher
implements SdkPublisher<ListResourceSetsResponse> {
    private final Route53RecoveryReadinessAsyncClient client;
    private final ListResourceSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResourceSetsPublisher(Route53RecoveryReadinessAsyncClient client, ListResourceSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResourceSetsPublisher(Route53RecoveryReadinessAsyncClient client, ListResourceSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResourceSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResourceSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceSetOutput> resourceSets() {
        Function<ListResourceSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceSets() != null) {
                return response.resourceSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResourceSetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResourceSetsResponseFetcher
    implements AsyncPageFetcher<ListResourceSetsResponse> {
        private ListResourceSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResourceSetsResponse> nextPage(ListResourceSetsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceSetsPublisher.this.client.listResourceSets(ListResourceSetsPublisher.this.firstRequest);
            }
            return ListResourceSetsPublisher.this.client.listResourceSets((ListResourceSetsRequest)((Object)ListResourceSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

