/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverClient;
import software.amazon.awssdk.services.route53resolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53resolver.model.IpAddressResponse;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse;

public class ListResolverEndpointIpAddressesIterable
implements SdkIterable<ListResolverEndpointIpAddressesResponse> {
    private final Route53ResolverClient client;
    private final ListResolverEndpointIpAddressesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResolverEndpointIpAddressesIterable(Route53ResolverClient client, ListResolverEndpointIpAddressesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResolverEndpointIpAddressesResponseFetcher();
    }

    public Iterator<ListResolverEndpointIpAddressesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IpAddressResponse> ipAddresses() {
        Function<ListResolverEndpointIpAddressesResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipAddresses() != null) {
                return response.ipAddresses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResolverEndpointIpAddressesResponseFetcher
    implements SyncPageFetcher<ListResolverEndpointIpAddressesResponse> {
        private ListResolverEndpointIpAddressesResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverEndpointIpAddressesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResolverEndpointIpAddressesResponse nextPage(ListResolverEndpointIpAddressesResponse previousPage) {
            if (previousPage == null) {
                return ListResolverEndpointIpAddressesIterable.this.client.listResolverEndpointIpAddresses(ListResolverEndpointIpAddressesIterable.this.firstRequest);
            }
            return ListResolverEndpointIpAddressesIterable.this.client.listResolverEndpointIpAddresses((ListResolverEndpointIpAddressesRequest)((Object)ListResolverEndpointIpAddressesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

