/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DnsThreatProtection {
    DGA("DGA"),
    DNS_TUNNELING("DNS_TUNNELING"),
    DICTIONARY_DGA("DICTIONARY_DGA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DnsThreatProtection> VALUE_MAP;
    private final String value;

    private DnsThreatProtection(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DnsThreatProtection fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DnsThreatProtection> knownValues() {
        EnumSet<DnsThreatProtection> knownValues = EnumSet.allOf(DnsThreatProtection.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DnsThreatProtection.class, DnsThreatProtection::toString);
    }
}

