/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverClient;
import software.amazon.awssdk.services.route53resolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverConfigsResponse;
import software.amazon.awssdk.services.route53resolver.model.ResolverConfig;

public class ListResolverConfigsIterable
implements SdkIterable<ListResolverConfigsResponse> {
    private final Route53ResolverClient client;
    private final ListResolverConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResolverConfigsIterable(Route53ResolverClient client, ListResolverConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResolverConfigsResponseFetcher();
    }

    public Iterator<ListResolverConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResolverConfig> resolverConfigs() {
        Function<ListResolverConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resolverConfigs() != null) {
                return response.resolverConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResolverConfigsResponseFetcher
    implements SyncPageFetcher<ListResolverConfigsResponse> {
        private ListResolverConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResolverConfigsResponse nextPage(ListResolverConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListResolverConfigsIterable.this.client.listResolverConfigs(ListResolverConfigsIterable.this.firstRequest);
            }
            return ListResolverConfigsIterable.this.client.listResolverConfigs((ListResolverConfigsRequest)((Object)ListResolverConfigsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

