/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.ObjectLambdaConfiguration;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccessPointConfigurationForObjectLambdaResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, GetAccessPointConfigurationForObjectLambdaResponse> {
    private static final SdkField<ObjectLambdaConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(GetAccessPointConfigurationForObjectLambdaResponse.getter(GetAccessPointConfigurationForObjectLambdaResponse::configuration)).setter(GetAccessPointConfigurationForObjectLambdaResponse.setter(Builder::configuration)).constructor(ObjectLambdaConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").unmarshallLocationName("Configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD));
    private final ObjectLambdaConfiguration configuration;

    private GetAccessPointConfigurationForObjectLambdaResponse(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
    }

    public final ObjectLambdaConfiguration configuration() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessPointConfigurationForObjectLambdaResponse)) {
            return false;
        }
        GetAccessPointConfigurationForObjectLambdaResponse other = (GetAccessPointConfigurationForObjectLambdaResponse)((Object)obj);
        return Objects.equals(this.configuration(), other.configuration());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccessPointConfigurationForObjectLambdaResponse").add("Configuration", (Object)this.configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccessPointConfigurationForObjectLambdaResponse, T> g) {
        return obj -> g.apply((GetAccessPointConfigurationForObjectLambdaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private ObjectLambdaConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessPointConfigurationForObjectLambdaResponse model) {
            super(model);
            this.configuration(model.configuration);
        }

        public final ObjectLambdaConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(ObjectLambdaConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ObjectLambdaConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public GetAccessPointConfigurationForObjectLambdaResponse build() {
            return new GetAccessPointConfigurationForObjectLambdaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccessPointConfigurationForObjectLambdaResponse> {
        public Builder configuration(ObjectLambdaConfiguration var1);

        default public Builder configuration(Consumer<ObjectLambdaConfiguration.Builder> configuration) {
            return this.configuration((ObjectLambdaConfiguration)((ObjectLambdaConfiguration.Builder)ObjectLambdaConfiguration.builder().applyMutation(configuration)).build());
        }
    }
}

