/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.GranteeType;
import software.amazon.awssdk.services.s3control.model.Permission;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccessGrantsRequest
extends S3ControlRequest
implements ToCopyableBuilder<Builder, ListAccessGrantsRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ListAccessGrantsRequest.getter(ListAccessGrantsRequest::accountId)).setter(ListAccessGrantsRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id").unmarshallLocationName("x-amz-account-id").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAccessGrantsRequest.getter(ListAccessGrantsRequest::nextToken)).setter(ListAccessGrantsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListAccessGrantsRequest.getter(ListAccessGrantsRequest::maxResults)).setter(ListAccessGrantsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").unmarshallLocationName("maxResults").build()}).build();
    private static final SdkField<String> GRANTEE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GranteeType").getter(ListAccessGrantsRequest.getter(ListAccessGrantsRequest::granteeTypeAsString)).setter(ListAccessGrantsRequest.setter(Builder::granteeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("granteetype").unmarshallLocationName("granteetype").build()}).build();
    private static final SdkField<String> GRANTEE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GranteeIdentifier").getter(ListAccessGrantsRequest.getter(ListAccessGrantsRequest::granteeIdentifier)).setter(ListAccessGrantsRequest.setter(Builder::granteeIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("granteeidentifier").unmarshallLocationName("granteeidentifier").build()}).build();
    private static final SdkField<String> PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Permission").getter(ListAccessGrantsRequest.getter(ListAccessGrantsRequest::permissionAsString)).setter(ListAccessGrantsRequest.setter(Builder::permission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("permission").unmarshallLocationName("permission").build()}).build();
    private static final SdkField<String> GRANT_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantScope").getter(ListAccessGrantsRequest.getter(ListAccessGrantsRequest::grantScope)).setter(ListAccessGrantsRequest.setter(Builder::grantScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("grantscope").unmarshallLocationName("grantscope").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(ListAccessGrantsRequest.getter(ListAccessGrantsRequest::applicationArn)).setter(ListAccessGrantsRequest.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("application_arn").unmarshallLocationName("application_arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, GRANTEE_TYPE_FIELD, GRANTEE_IDENTIFIER_FIELD, PERMISSION_FIELD, GRANT_SCOPE_FIELD, APPLICATION_ARN_FIELD));
    private final String accountId;
    private final String nextToken;
    private final Integer maxResults;
    private final String granteeType;
    private final String granteeIdentifier;
    private final String permission;
    private final String grantScope;
    private final String applicationArn;

    private ListAccessGrantsRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.granteeType = builder.granteeType;
        this.granteeIdentifier = builder.granteeIdentifier;
        this.permission = builder.permission;
        this.grantScope = builder.grantScope;
        this.applicationArn = builder.applicationArn;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final GranteeType granteeType() {
        return GranteeType.fromValue(this.granteeType);
    }

    public final String granteeTypeAsString() {
        return this.granteeType;
    }

    public final String granteeIdentifier() {
        return this.granteeIdentifier;
    }

    public final Permission permission() {
        return Permission.fromValue(this.permission);
    }

    public final String permissionAsString() {
        return this.permission;
    }

    public final String grantScope() {
        return this.grantScope;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.granteeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.granteeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessGrantsRequest)) {
            return false;
        }
        ListAccessGrantsRequest other = (ListAccessGrantsRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.granteeTypeAsString(), other.granteeTypeAsString()) && Objects.equals(this.granteeIdentifier(), other.granteeIdentifier()) && Objects.equals(this.permissionAsString(), other.permissionAsString()) && Objects.equals(this.grantScope(), other.grantScope()) && Objects.equals(this.applicationArn(), other.applicationArn());
    }

    public final String toString() {
        return ToString.builder((String)"ListAccessGrantsRequest").add("AccountId", (Object)this.accountId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("GranteeType", (Object)this.granteeTypeAsString()).add("GranteeIdentifier", (Object)this.granteeIdentifier()).add("Permission", (Object)this.permissionAsString()).add("GrantScope", (Object)this.grantScope()).add("ApplicationArn", (Object)this.applicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "GranteeType": {
                return Optional.ofNullable(clazz.cast(this.granteeTypeAsString()));
            }
            case "GranteeIdentifier": {
                return Optional.ofNullable(clazz.cast(this.granteeIdentifier()));
            }
            case "Permission": {
                return Optional.ofNullable(clazz.cast(this.permissionAsString()));
            }
            case "GrantScope": {
                return Optional.ofNullable(clazz.cast(this.grantScope()));
            }
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessGrantsRequest, T> g) {
        return obj -> g.apply((ListAccessGrantsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String nextToken;
        private Integer maxResults;
        private String granteeType;
        private String granteeIdentifier;
        private String permission;
        private String grantScope;
        private String applicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessGrantsRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.granteeType(model.granteeType);
            this.granteeIdentifier(model.granteeIdentifier);
            this.permission(model.permission);
            this.grantScope(model.grantScope);
            this.applicationArn(model.applicationArn);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getGranteeType() {
            return this.granteeType;
        }

        public final void setGranteeType(String granteeType) {
            this.granteeType = granteeType;
        }

        @Override
        public final Builder granteeType(String granteeType) {
            this.granteeType = granteeType;
            return this;
        }

        @Override
        public final Builder granteeType(GranteeType granteeType) {
            this.granteeType(granteeType == null ? null : granteeType.toString());
            return this;
        }

        public final String getGranteeIdentifier() {
            return this.granteeIdentifier;
        }

        public final void setGranteeIdentifier(String granteeIdentifier) {
            this.granteeIdentifier = granteeIdentifier;
        }

        @Override
        public final Builder granteeIdentifier(String granteeIdentifier) {
            this.granteeIdentifier = granteeIdentifier;
            return this;
        }

        public final String getPermission() {
            return this.permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(Permission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final String getGrantScope() {
            return this.grantScope;
        }

        public final void setGrantScope(String grantScope) {
            this.grantScope = grantScope;
        }

        @Override
        public final Builder grantScope(String grantScope) {
            this.grantScope = grantScope;
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccessGrantsRequest build() {
            return new ListAccessGrantsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccessGrantsRequest> {
        public Builder accountId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder granteeType(String var1);

        public Builder granteeType(GranteeType var1);

        public Builder granteeIdentifier(String var1);

        public Builder permission(String var1);

        public Builder permission(Permission var1);

        public Builder grantScope(String var1);

        public Builder applicationArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

