/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3SSEAlgorithm {
    AES256("AES256"),
    KMS("KMS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3SSEAlgorithm> VALUE_MAP;
    private final String value;

    private S3SSEAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3SSEAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3SSEAlgorithm> knownValues() {
        EnumSet<S3SSEAlgorithm> knownValues = EnumSet.allOf(S3SSEAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3SSEAlgorithm.class, S3SSEAlgorithm::toString);
    }
}

