/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.s3control.S3ControlClient;
import software.amazon.awssdk.services.s3control.internal.UserAgentUtils;
import software.amazon.awssdk.services.s3control.model.ListStorageLensGroupsRequest;
import software.amazon.awssdk.services.s3control.model.ListStorageLensGroupsResponse;

public class ListStorageLensGroupsIterable
implements SdkIterable<ListStorageLensGroupsResponse> {
    private final S3ControlClient client;
    private final ListStorageLensGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStorageLensGroupsIterable(S3ControlClient client, ListStorageLensGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStorageLensGroupsResponseFetcher();
    }

    public Iterator<ListStorageLensGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListStorageLensGroupsResponseFetcher
    implements SyncPageFetcher<ListStorageLensGroupsResponse> {
        private ListStorageLensGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListStorageLensGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStorageLensGroupsResponse nextPage(ListStorageLensGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListStorageLensGroupsIterable.this.client.listStorageLensGroups(ListStorageLensGroupsIterable.this.firstRequest);
            }
            return ListStorageLensGroupsIterable.this.client.listStorageLensGroups((ListStorageLensGroupsRequest)((Object)ListStorageLensGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

