/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A value that indicates whether the update was successful.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LastUpdateStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<LastUpdateStatus.Builder, LastUpdateStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(LastUpdateStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(LastUpdateStatus::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String failureReason;

    private LastUpdateStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * A value that indicates whether the update was made successful.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LastUpdateStatusValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A value that indicates whether the update was made successful.
     * @see LastUpdateStatusValue
     */
    public final LastUpdateStatusValue status() {
        return LastUpdateStatusValue.fromValue(status);
    }

    /**
     * <p>
     * A value that indicates whether the update was made successful.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LastUpdateStatusValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A value that indicates whether the update was made successful.
     * @see LastUpdateStatusValue
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If the update wasn't successful, indicates the reason why it failed.
     * </p>
     * 
     * @return If the update wasn't successful, indicates the reason why it failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastUpdateStatus)) {
            return false;
        }
        LastUpdateStatus other = (LastUpdateStatus) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LastUpdateStatus").add("Status", statusAsString()).add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LastUpdateStatus, T> g) {
        return obj -> g.apply((LastUpdateStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LastUpdateStatus> {
        /**
         * <p>
         * A value that indicates whether the update was made successful.
         * </p>
         * 
         * @param status
         *        A value that indicates whether the update was made successful.
         * @see LastUpdateStatusValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastUpdateStatusValue
         */
        Builder status(String status);

        /**
         * <p>
         * A value that indicates whether the update was made successful.
         * </p>
         * 
         * @param status
         *        A value that indicates whether the update was made successful.
         * @see LastUpdateStatusValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastUpdateStatusValue
         */
        Builder status(LastUpdateStatusValue status);

        /**
         * <p>
         * If the update wasn't successful, indicates the reason why it failed.
         * </p>
         * 
         * @param failureReason
         *        If the update wasn't successful, indicates the reason why it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(LastUpdateStatus model) {
            status(model.status);
            failureReason(model.failureReason);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LastUpdateStatusValue status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public LastUpdateStatus build() {
            return new LastUpdateStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
