/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object where you specify the anticipated traffic pattern for an endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalingPolicyObjective implements SdkPojo, Serializable,
        ToCopyableBuilder<ScalingPolicyObjective.Builder, ScalingPolicyObjective> {
    private static final SdkField<Integer> MIN_INVOCATIONS_PER_MINUTE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinInvocationsPerMinute").getter(getter(ScalingPolicyObjective::minInvocationsPerMinute))
            .setter(setter(Builder::minInvocationsPerMinute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinInvocationsPerMinute").build())
            .build();

    private static final SdkField<Integer> MAX_INVOCATIONS_PER_MINUTE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxInvocationsPerMinute").getter(getter(ScalingPolicyObjective::maxInvocationsPerMinute))
            .setter(setter(Builder::maxInvocationsPerMinute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInvocationsPerMinute").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MIN_INVOCATIONS_PER_MINUTE_FIELD, MAX_INVOCATIONS_PER_MINUTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer minInvocationsPerMinute;

    private final Integer maxInvocationsPerMinute;

    private ScalingPolicyObjective(BuilderImpl builder) {
        this.minInvocationsPerMinute = builder.minInvocationsPerMinute;
        this.maxInvocationsPerMinute = builder.maxInvocationsPerMinute;
    }

    /**
     * <p>
     * The minimum number of expected requests to your endpoint per minute.
     * </p>
     * 
     * @return The minimum number of expected requests to your endpoint per minute.
     */
    public final Integer minInvocationsPerMinute() {
        return minInvocationsPerMinute;
    }

    /**
     * <p>
     * The maximum number of expected requests to your endpoint per minute.
     * </p>
     * 
     * @return The maximum number of expected requests to your endpoint per minute.
     */
    public final Integer maxInvocationsPerMinute() {
        return maxInvocationsPerMinute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minInvocationsPerMinute());
        hashCode = 31 * hashCode + Objects.hashCode(maxInvocationsPerMinute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicyObjective)) {
            return false;
        }
        ScalingPolicyObjective other = (ScalingPolicyObjective) obj;
        return Objects.equals(minInvocationsPerMinute(), other.minInvocationsPerMinute())
                && Objects.equals(maxInvocationsPerMinute(), other.maxInvocationsPerMinute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScalingPolicyObjective").add("MinInvocationsPerMinute", minInvocationsPerMinute())
                .add("MaxInvocationsPerMinute", maxInvocationsPerMinute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinInvocationsPerMinute":
            return Optional.ofNullable(clazz.cast(minInvocationsPerMinute()));
        case "MaxInvocationsPerMinute":
            return Optional.ofNullable(clazz.cast(maxInvocationsPerMinute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingPolicyObjective, T> g) {
        return obj -> g.apply((ScalingPolicyObjective) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalingPolicyObjective> {
        /**
         * <p>
         * The minimum number of expected requests to your endpoint per minute.
         * </p>
         * 
         * @param minInvocationsPerMinute
         *        The minimum number of expected requests to your endpoint per minute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minInvocationsPerMinute(Integer minInvocationsPerMinute);

        /**
         * <p>
         * The maximum number of expected requests to your endpoint per minute.
         * </p>
         * 
         * @param maxInvocationsPerMinute
         *        The maximum number of expected requests to your endpoint per minute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxInvocationsPerMinute(Integer maxInvocationsPerMinute);
    }

    static final class BuilderImpl implements Builder {
        private Integer minInvocationsPerMinute;

        private Integer maxInvocationsPerMinute;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPolicyObjective model) {
            minInvocationsPerMinute(model.minInvocationsPerMinute);
            maxInvocationsPerMinute(model.maxInvocationsPerMinute);
        }

        public final Integer getMinInvocationsPerMinute() {
            return minInvocationsPerMinute;
        }

        public final void setMinInvocationsPerMinute(Integer minInvocationsPerMinute) {
            this.minInvocationsPerMinute = minInvocationsPerMinute;
        }

        @Override
        public final Builder minInvocationsPerMinute(Integer minInvocationsPerMinute) {
            this.minInvocationsPerMinute = minInvocationsPerMinute;
            return this;
        }

        public final Integer getMaxInvocationsPerMinute() {
            return maxInvocationsPerMinute;
        }

        public final void setMaxInvocationsPerMinute(Integer maxInvocationsPerMinute) {
            this.maxInvocationsPerMinute = maxInvocationsPerMinute;
        }

        @Override
        public final Builder maxInvocationsPerMinute(Integer maxInvocationsPerMinute) {
            this.maxInvocationsPerMinute = maxInvocationsPerMinute;
            return this;
        }

        @Override
        public ScalingPolicyObjective build() {
            return new ScalingPolicyObjective(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
