/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMonitoringScheduleRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateMonitoringScheduleRequest.Builder, UpdateMonitoringScheduleRequest> {
    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringScheduleName").getter(getter(UpdateMonitoringScheduleRequest::monitoringScheduleName))
            .setter(setter(Builder::monitoringScheduleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build())
            .build();

    private static final SdkField<MonitoringScheduleConfig> MONITORING_SCHEDULE_CONFIG_FIELD = SdkField
            .<MonitoringScheduleConfig> builder(MarshallingType.SDK_POJO).memberName("MonitoringScheduleConfig")
            .getter(getter(UpdateMonitoringScheduleRequest::monitoringScheduleConfig))
            .setter(setter(Builder::monitoringScheduleConfig)).constructor(MonitoringScheduleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_SCHEDULE_NAME_FIELD, MONITORING_SCHEDULE_CONFIG_FIELD));

    private final String monitoringScheduleName;

    private final MonitoringScheduleConfig monitoringScheduleConfig;

    private UpdateMonitoringScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.monitoringScheduleConfig = builder.monitoringScheduleConfig;
    }

    /**
     * <p>
     * The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region within an
     * Amazon Web Services account.
     * </p>
     * 
     * @return The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region within
     *         an Amazon Web Services account.
     */
    public final String monitoringScheduleName() {
        return monitoringScheduleName;
    }

    /**
     * <p>
     * The configuration object that specifies the monitoring schedule and defines the monitoring job.
     * </p>
     * 
     * @return The configuration object that specifies the monitoring schedule and defines the monitoring job.
     */
    public final MonitoringScheduleConfig monitoringScheduleConfig() {
        return monitoringScheduleConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMonitoringScheduleRequest)) {
            return false;
        }
        UpdateMonitoringScheduleRequest other = (UpdateMonitoringScheduleRequest) obj;
        return Objects.equals(monitoringScheduleName(), other.monitoringScheduleName())
                && Objects.equals(monitoringScheduleConfig(), other.monitoringScheduleConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMonitoringScheduleRequest").add("MonitoringScheduleName", monitoringScheduleName())
                .add("MonitoringScheduleConfig", monitoringScheduleConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringScheduleName":
            return Optional.ofNullable(clazz.cast(monitoringScheduleName()));
        case "MonitoringScheduleConfig":
            return Optional.ofNullable(clazz.cast(monitoringScheduleConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMonitoringScheduleRequest, T> g) {
        return obj -> g.apply((UpdateMonitoringScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMonitoringScheduleRequest> {
        /**
         * <p>
         * The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region within an
         * Amazon Web Services account.
         * </p>
         * 
         * @param monitoringScheduleName
         *        The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region
         *        within an Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleName(String monitoringScheduleName);

        /**
         * <p>
         * The configuration object that specifies the monitoring schedule and defines the monitoring job.
         * </p>
         * 
         * @param monitoringScheduleConfig
         *        The configuration object that specifies the monitoring schedule and defines the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleConfig(MonitoringScheduleConfig monitoringScheduleConfig);

        /**
         * <p>
         * The configuration object that specifies the monitoring schedule and defines the monitoring job.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringScheduleConfig.Builder}
         * avoiding the need to create one manually via {@link MonitoringScheduleConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringScheduleConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #monitoringScheduleConfig(MonitoringScheduleConfig)}.
         * 
         * @param monitoringScheduleConfig
         *        a consumer that will call methods on {@link MonitoringScheduleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringScheduleConfig(MonitoringScheduleConfig)
         */
        default Builder monitoringScheduleConfig(Consumer<MonitoringScheduleConfig.Builder> monitoringScheduleConfig) {
            return monitoringScheduleConfig(MonitoringScheduleConfig.builder().applyMutation(monitoringScheduleConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String monitoringScheduleName;

        private MonitoringScheduleConfig monitoringScheduleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMonitoringScheduleRequest model) {
            super(model);
            monitoringScheduleName(model.monitoringScheduleName);
            monitoringScheduleConfig(model.monitoringScheduleConfig);
        }

        public final String getMonitoringScheduleName() {
            return monitoringScheduleName;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final MonitoringScheduleConfig.Builder getMonitoringScheduleConfig() {
            return monitoringScheduleConfig != null ? monitoringScheduleConfig.toBuilder() : null;
        }

        public final void setMonitoringScheduleConfig(MonitoringScheduleConfig.BuilderImpl monitoringScheduleConfig) {
            this.monitoringScheduleConfig = monitoringScheduleConfig != null ? monitoringScheduleConfig.build() : null;
        }

        @Override
        public final Builder monitoringScheduleConfig(MonitoringScheduleConfig monitoringScheduleConfig) {
            this.monitoringScheduleConfig = monitoringScheduleConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMonitoringScheduleRequest build() {
            return new UpdateMonitoringScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
