/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeviceRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, DescribeDeviceRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeDeviceRequest.getter(DescribeDeviceRequest::nextToken)).setter(DescribeDeviceRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceName").getter(DescribeDeviceRequest.getter(DescribeDeviceRequest::deviceName)).setter(DescribeDeviceRequest.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()}).build();
    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceFleetName").getter(DescribeDeviceRequest.getter(DescribeDeviceRequest::deviceFleetName)).setter(DescribeDeviceRequest.setter(Builder::deviceFleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DEVICE_NAME_FIELD, DEVICE_FLEET_NAME_FIELD));
    private final String nextToken;
    private final String deviceName;
    private final String deviceFleetName;

    private DescribeDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.deviceName = builder.deviceName;
        this.deviceFleetName = builder.deviceFleetName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String deviceName() {
        return this.deviceName;
    }

    public final String deviceFleetName() {
        return this.deviceFleetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceFleetName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceRequest)) {
            return false;
        }
        DescribeDeviceRequest other = (DescribeDeviceRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.deviceFleetName(), other.deviceFleetName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDeviceRequest").add("NextToken", (Object)this.nextToken()).add("DeviceName", (Object)this.deviceName()).add("DeviceFleetName", (Object)this.deviceFleetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "DeviceFleetName": {
                return Optional.ofNullable(clazz.cast(this.deviceFleetName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceRequest, T> g) {
        return obj -> g.apply((DescribeDeviceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private String deviceName;
        private String deviceFleetName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.deviceName(model.deviceName);
            this.deviceFleetName(model.deviceFleetName);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getDeviceFleetName() {
            return this.deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDeviceRequest build() {
            return new DescribeDeviceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeviceRequest> {
        public Builder nextToken(String var1);

        public Builder deviceName(String var1);

        public Builder deviceFleetName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

