/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.UserSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserProfileRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateUserProfileRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(UpdateUserProfileRequest.getter(UpdateUserProfileRequest::domainId)).setter(UpdateUserProfileRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserProfileName").getter(UpdateUserProfileRequest.getter(UpdateUserProfileRequest::userProfileName)).setter(UpdateUserProfileRequest.setter(Builder::userProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()}).build();
    private static final SdkField<UserSettings> USER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserSettings").getter(UpdateUserProfileRequest.getter(UpdateUserProfileRequest::userSettings)).setter(UpdateUserProfileRequest.setter(Builder::userSettings)).constructor(UserSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, USER_PROFILE_NAME_FIELD, USER_SETTINGS_FIELD));
    private final String domainId;
    private final String userProfileName;
    private final UserSettings userSettings;

    private UpdateUserProfileRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.userProfileName = builder.userProfileName;
        this.userSettings = builder.userSettings;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String userProfileName() {
        return this.userProfileName;
    }

    public final UserSettings userSettings() {
        return this.userSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserProfileRequest)) {
            return false;
        }
        UpdateUserProfileRequest other = (UpdateUserProfileRequest)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.userProfileName(), other.userProfileName()) && Objects.equals(this.userSettings(), other.userSettings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserProfileRequest").add("DomainId", (Object)this.domainId()).add("UserProfileName", (Object)this.userProfileName()).add("UserSettings", (Object)this.userSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "UserProfileName": {
                return Optional.ofNullable(clazz.cast(this.userProfileName()));
            }
            case "UserSettings": {
                return Optional.ofNullable(clazz.cast(this.userSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserProfileRequest, T> g) {
        return obj -> g.apply((UpdateUserProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String domainId;
        private String userProfileName;
        private UserSettings userSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserProfileRequest model) {
            super(model);
            this.domainId(model.domainId);
            this.userProfileName(model.userProfileName);
            this.userSettings(model.userSettings);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getUserProfileName() {
            return this.userProfileName;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final UserSettings.Builder getUserSettings() {
            return this.userSettings != null ? this.userSettings.toBuilder() : null;
        }

        public final void setUserSettings(UserSettings.BuilderImpl userSettings) {
            this.userSettings = userSettings != null ? userSettings.build() : null;
        }

        @Override
        public final Builder userSettings(UserSettings userSettings) {
            this.userSettings = userSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserProfileRequest build() {
            return new UpdateUserProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserProfileRequest> {
        public Builder domainId(String var1);

        public Builder userProfileName(String var1);

        public Builder userSettings(UserSettings var1);

        default public Builder userSettings(Consumer<UserSettings.Builder> userSettings) {
            return this.userSettings((UserSettings)((UserSettings.Builder)UserSettings.builder().applyMutation(userSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

