/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.QueryLineageRequest;
import software.amazon.awssdk.services.sagemaker.model.QueryLineageResponse;

public class QueryLineagePublisher
implements SdkPublisher<QueryLineageResponse> {
    private final SageMakerAsyncClient client;
    private final QueryLineageRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public QueryLineagePublisher(SageMakerAsyncClient client, QueryLineageRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private QueryLineagePublisher(SageMakerAsyncClient client, QueryLineageRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new QueryLineageResponseFetcher();
    }

    public void subscribe(Subscriber<? super QueryLineageResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class QueryLineageResponseFetcher
    implements AsyncPageFetcher<QueryLineageResponse> {
        private QueryLineageResponseFetcher() {
        }

        public boolean hasNextPage(QueryLineageResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<QueryLineageResponse> nextPage(QueryLineageResponse previousPage) {
            if (previousPage == null) {
                return QueryLineagePublisher.this.client.queryLineage(QueryLineagePublisher.this.firstRequest);
            }
            return QueryLineagePublisher.this.client.queryLineage((QueryLineageRequest)((Object)QueryLineagePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

