/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification;
import software.amazon.awssdk.services.sagemaker.model.Channel;
import software.amazon.awssdk.services.sagemaker.model.CheckpointConfig;
import software.amazon.awssdk.services.sagemaker.model.DebugHookConfig;
import software.amazon.awssdk.services.sagemaker.model.DebugRuleConfiguration;
import software.amazon.awssdk.services.sagemaker.model.DebugRuleConfigurationsCopier;
import software.amazon.awssdk.services.sagemaker.model.DebugRuleEvaluationStatus;
import software.amazon.awssdk.services.sagemaker.model.DebugRuleEvaluationStatusesCopier;
import software.amazon.awssdk.services.sagemaker.model.ExperimentConfig;
import software.amazon.awssdk.services.sagemaker.model.FinalMetricDataListCopier;
import software.amazon.awssdk.services.sagemaker.model.HyperParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.InfraCheckConfig;
import software.amazon.awssdk.services.sagemaker.model.InputDataConfigCopier;
import software.amazon.awssdk.services.sagemaker.model.MetricData;
import software.amazon.awssdk.services.sagemaker.model.ModelArtifacts;
import software.amazon.awssdk.services.sagemaker.model.OutputDataConfig;
import software.amazon.awssdk.services.sagemaker.model.ProfilerConfig;
import software.amazon.awssdk.services.sagemaker.model.ProfilerRuleConfiguration;
import software.amazon.awssdk.services.sagemaker.model.ProfilerRuleConfigurationsCopier;
import software.amazon.awssdk.services.sagemaker.model.ProfilerRuleEvaluationStatus;
import software.amazon.awssdk.services.sagemaker.model.ProfilerRuleEvaluationStatusesCopier;
import software.amazon.awssdk.services.sagemaker.model.ProfilingStatus;
import software.amazon.awssdk.services.sagemaker.model.RemoteDebugConfig;
import software.amazon.awssdk.services.sagemaker.model.ResourceConfig;
import software.amazon.awssdk.services.sagemaker.model.RetryStrategy;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.SecondaryStatus;
import software.amazon.awssdk.services.sagemaker.model.SecondaryStatusTransition;
import software.amazon.awssdk.services.sagemaker.model.SecondaryStatusTransitionsCopier;
import software.amazon.awssdk.services.sagemaker.model.StoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.TensorBoardOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.TrainingEnvironmentMapCopier;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobStatus;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.services.sagemaker.model.WarmPoolStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrainingJobResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeTrainingJobResponse> {
    private static final SdkField<String> TRAINING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingJobName").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::trainingJobName)).setter(DescribeTrainingJobResponse.setter(Builder::trainingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobName").build()}).build();
    private static final SdkField<String> TRAINING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingJobArn").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::trainingJobArn)).setter(DescribeTrainingJobResponse.setter(Builder::trainingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobArn").build()}).build();
    private static final SdkField<String> TUNING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TuningJobArn").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::tuningJobArn)).setter(DescribeTrainingJobResponse.setter(Builder::tuningJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TuningJobArn").build()}).build();
    private static final SdkField<String> LABELING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelingJobArn").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::labelingJobArn)).setter(DescribeTrainingJobResponse.setter(Builder::labelingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobArn").build()}).build();
    private static final SdkField<String> AUTO_ML_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoMLJobArn").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::autoMLJobArn)).setter(DescribeTrainingJobResponse.setter(Builder::autoMLJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArn").build()}).build();
    private static final SdkField<ModelArtifacts> MODEL_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelArtifacts").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::modelArtifacts)).setter(DescribeTrainingJobResponse.setter(Builder::modelArtifacts)).constructor(ModelArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArtifacts").build()}).build();
    private static final SdkField<String> TRAINING_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingJobStatus").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::trainingJobStatusAsString)).setter(DescribeTrainingJobResponse.setter(Builder::trainingJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobStatus").build()}).build();
    private static final SdkField<String> SECONDARY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecondaryStatus").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::secondaryStatusAsString)).setter(DescribeTrainingJobResponse.setter(Builder::secondaryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::failureReason)).setter(DescribeTrainingJobResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("HyperParameters").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::hyperParameters)).setter(DescribeTrainingJobResponse.setter(Builder::hyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AlgorithmSpecification> ALGORITHM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AlgorithmSpecification").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::algorithmSpecification)).setter(DescribeTrainingJobResponse.setter(Builder::algorithmSpecification)).constructor(AlgorithmSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmSpecification").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::roleArn)).setter(DescribeTrainingJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<Channel>> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputDataConfig").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::inputDataConfig)).setter(DescribeTrainingJobResponse.setter(Builder::inputDataConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Channel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputDataConfig").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::outputDataConfig)).setter(DescribeTrainingJobResponse.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceConfig").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::resourceConfig)).setter(DescribeTrainingJobResponse.setter(Builder::resourceConfig)).constructor(ResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfig").build()}).build();
    private static final SdkField<WarmPoolStatus> WARM_POOL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WarmPoolStatus").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::warmPoolStatus)).setter(DescribeTrainingJobResponse.setter(Builder::warmPoolStatus)).constructor(WarmPoolStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmPoolStatus").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::vpcConfig)).setter(DescribeTrainingJobResponse.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingCondition").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::stoppingCondition)).setter(DescribeTrainingJobResponse.setter(Builder::stoppingCondition)).constructor(StoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::creationTime)).setter(DescribeTrainingJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> TRAINING_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingStartTime").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::trainingStartTime)).setter(DescribeTrainingJobResponse.setter(Builder::trainingStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingStartTime").build()}).build();
    private static final SdkField<Instant> TRAINING_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingEndTime").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::trainingEndTime)).setter(DescribeTrainingJobResponse.setter(Builder::trainingEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingEndTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::lastModifiedTime)).setter(DescribeTrainingJobResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<List<SecondaryStatusTransition>> SECONDARY_STATUS_TRANSITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecondaryStatusTransitions").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::secondaryStatusTransitions)).setter(DescribeTrainingJobResponse.setter(Builder::secondaryStatusTransitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryStatusTransitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecondaryStatusTransition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MetricData>> FINAL_METRIC_DATA_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FinalMetricDataList").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::finalMetricDataList)).setter(DescribeTrainingJobResponse.setter(Builder::finalMetricDataList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalMetricDataList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_NETWORK_ISOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableNetworkIsolation").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::enableNetworkIsolation)).setter(DescribeTrainingJobResponse.setter(Builder::enableNetworkIsolation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNetworkIsolation").build()}).build();
    private static final SdkField<Boolean> ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableInterContainerTrafficEncryption").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::enableInterContainerTrafficEncryption)).setter(DescribeTrainingJobResponse.setter(Builder::enableInterContainerTrafficEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableInterContainerTrafficEncryption").build()}).build();
    private static final SdkField<Boolean> ENABLE_MANAGED_SPOT_TRAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableManagedSpotTraining").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::enableManagedSpotTraining)).setter(DescribeTrainingJobResponse.setter(Builder::enableManagedSpotTraining)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableManagedSpotTraining").build()}).build();
    private static final SdkField<CheckpointConfig> CHECKPOINT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CheckpointConfig").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::checkpointConfig)).setter(DescribeTrainingJobResponse.setter(Builder::checkpointConfig)).constructor(CheckpointConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointConfig").build()}).build();
    private static final SdkField<Integer> TRAINING_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TrainingTimeInSeconds").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::trainingTimeInSeconds)).setter(DescribeTrainingJobResponse.setter(Builder::trainingTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingTimeInSeconds").build()}).build();
    private static final SdkField<Integer> BILLABLE_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BillableTimeInSeconds").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::billableTimeInSeconds)).setter(DescribeTrainingJobResponse.setter(Builder::billableTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillableTimeInSeconds").build()}).build();
    private static final SdkField<DebugHookConfig> DEBUG_HOOK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DebugHookConfig").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::debugHookConfig)).setter(DescribeTrainingJobResponse.setter(Builder::debugHookConfig)).constructor(DebugHookConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugHookConfig").build()}).build();
    private static final SdkField<ExperimentConfig> EXPERIMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExperimentConfig").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::experimentConfig)).setter(DescribeTrainingJobResponse.setter(Builder::experimentConfig)).constructor(ExperimentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentConfig").build()}).build();
    private static final SdkField<List<DebugRuleConfiguration>> DEBUG_RULE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DebugRuleConfigurations").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::debugRuleConfigurations)).setter(DescribeTrainingJobResponse.setter(Builder::debugRuleConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugRuleConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DebugRuleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TensorBoardOutputConfig> TENSOR_BOARD_OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TensorBoardOutputConfig").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::tensorBoardOutputConfig)).setter(DescribeTrainingJobResponse.setter(Builder::tensorBoardOutputConfig)).constructor(TensorBoardOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TensorBoardOutputConfig").build()}).build();
    private static final SdkField<List<DebugRuleEvaluationStatus>> DEBUG_RULE_EVALUATION_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DebugRuleEvaluationStatuses").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::debugRuleEvaluationStatuses)).setter(DescribeTrainingJobResponse.setter(Builder::debugRuleEvaluationStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugRuleEvaluationStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DebugRuleEvaluationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProfilerConfig> PROFILER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProfilerConfig").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::profilerConfig)).setter(DescribeTrainingJobResponse.setter(Builder::profilerConfig)).constructor(ProfilerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfilerConfig").build()}).build();
    private static final SdkField<List<ProfilerRuleConfiguration>> PROFILER_RULE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfilerRuleConfigurations").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::profilerRuleConfigurations)).setter(DescribeTrainingJobResponse.setter(Builder::profilerRuleConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfilerRuleConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfilerRuleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProfilerRuleEvaluationStatus>> PROFILER_RULE_EVALUATION_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfilerRuleEvaluationStatuses").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::profilerRuleEvaluationStatuses)).setter(DescribeTrainingJobResponse.setter(Builder::profilerRuleEvaluationStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfilerRuleEvaluationStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfilerRuleEvaluationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROFILING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfilingStatus").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::profilingStatusAsString)).setter(DescribeTrainingJobResponse.setter(Builder::profilingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfilingStatus").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Environment").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::environment)).setter(DescribeTrainingJobResponse.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<RetryStrategy> RETRY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryStrategy").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::retryStrategy)).setter(DescribeTrainingJobResponse.setter(Builder::retryStrategy)).constructor(RetryStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryStrategy").build()}).build();
    private static final SdkField<RemoteDebugConfig> REMOTE_DEBUG_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemoteDebugConfig").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::remoteDebugConfig)).setter(DescribeTrainingJobResponse.setter(Builder::remoteDebugConfig)).constructor(RemoteDebugConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDebugConfig").build()}).build();
    private static final SdkField<InfraCheckConfig> INFRA_CHECK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InfraCheckConfig").getter(DescribeTrainingJobResponse.getter(DescribeTrainingJobResponse::infraCheckConfig)).setter(DescribeTrainingJobResponse.setter(Builder::infraCheckConfig)).constructor(InfraCheckConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfraCheckConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_NAME_FIELD, TRAINING_JOB_ARN_FIELD, TUNING_JOB_ARN_FIELD, LABELING_JOB_ARN_FIELD, AUTO_ML_JOB_ARN_FIELD, MODEL_ARTIFACTS_FIELD, TRAINING_JOB_STATUS_FIELD, SECONDARY_STATUS_FIELD, FAILURE_REASON_FIELD, HYPER_PARAMETERS_FIELD, ALGORITHM_SPECIFICATION_FIELD, ROLE_ARN_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, RESOURCE_CONFIG_FIELD, WARM_POOL_STATUS_FIELD, VPC_CONFIG_FIELD, STOPPING_CONDITION_FIELD, CREATION_TIME_FIELD, TRAINING_START_TIME_FIELD, TRAINING_END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, SECONDARY_STATUS_TRANSITIONS_FIELD, FINAL_METRIC_DATA_LIST_FIELD, ENABLE_NETWORK_ISOLATION_FIELD, ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD, ENABLE_MANAGED_SPOT_TRAINING_FIELD, CHECKPOINT_CONFIG_FIELD, TRAINING_TIME_IN_SECONDS_FIELD, BILLABLE_TIME_IN_SECONDS_FIELD, DEBUG_HOOK_CONFIG_FIELD, EXPERIMENT_CONFIG_FIELD, DEBUG_RULE_CONFIGURATIONS_FIELD, TENSOR_BOARD_OUTPUT_CONFIG_FIELD, DEBUG_RULE_EVALUATION_STATUSES_FIELD, PROFILER_CONFIG_FIELD, PROFILER_RULE_CONFIGURATIONS_FIELD, PROFILER_RULE_EVALUATION_STATUSES_FIELD, PROFILING_STATUS_FIELD, ENVIRONMENT_FIELD, RETRY_STRATEGY_FIELD, REMOTE_DEBUG_CONFIG_FIELD, INFRA_CHECK_CONFIG_FIELD));
    private final String trainingJobName;
    private final String trainingJobArn;
    private final String tuningJobArn;
    private final String labelingJobArn;
    private final String autoMLJobArn;
    private final ModelArtifacts modelArtifacts;
    private final String trainingJobStatus;
    private final String secondaryStatus;
    private final String failureReason;
    private final Map<String, String> hyperParameters;
    private final AlgorithmSpecification algorithmSpecification;
    private final String roleArn;
    private final List<Channel> inputDataConfig;
    private final OutputDataConfig outputDataConfig;
    private final ResourceConfig resourceConfig;
    private final WarmPoolStatus warmPoolStatus;
    private final VpcConfig vpcConfig;
    private final StoppingCondition stoppingCondition;
    private final Instant creationTime;
    private final Instant trainingStartTime;
    private final Instant trainingEndTime;
    private final Instant lastModifiedTime;
    private final List<SecondaryStatusTransition> secondaryStatusTransitions;
    private final List<MetricData> finalMetricDataList;
    private final Boolean enableNetworkIsolation;
    private final Boolean enableInterContainerTrafficEncryption;
    private final Boolean enableManagedSpotTraining;
    private final CheckpointConfig checkpointConfig;
    private final Integer trainingTimeInSeconds;
    private final Integer billableTimeInSeconds;
    private final DebugHookConfig debugHookConfig;
    private final ExperimentConfig experimentConfig;
    private final List<DebugRuleConfiguration> debugRuleConfigurations;
    private final TensorBoardOutputConfig tensorBoardOutputConfig;
    private final List<DebugRuleEvaluationStatus> debugRuleEvaluationStatuses;
    private final ProfilerConfig profilerConfig;
    private final List<ProfilerRuleConfiguration> profilerRuleConfigurations;
    private final List<ProfilerRuleEvaluationStatus> profilerRuleEvaluationStatuses;
    private final String profilingStatus;
    private final Map<String, String> environment;
    private final RetryStrategy retryStrategy;
    private final RemoteDebugConfig remoteDebugConfig;
    private final InfraCheckConfig infraCheckConfig;

    private DescribeTrainingJobResponse(BuilderImpl builder) {
        super(builder);
        this.trainingJobName = builder.trainingJobName;
        this.trainingJobArn = builder.trainingJobArn;
        this.tuningJobArn = builder.tuningJobArn;
        this.labelingJobArn = builder.labelingJobArn;
        this.autoMLJobArn = builder.autoMLJobArn;
        this.modelArtifacts = builder.modelArtifacts;
        this.trainingJobStatus = builder.trainingJobStatus;
        this.secondaryStatus = builder.secondaryStatus;
        this.failureReason = builder.failureReason;
        this.hyperParameters = builder.hyperParameters;
        this.algorithmSpecification = builder.algorithmSpecification;
        this.roleArn = builder.roleArn;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.resourceConfig = builder.resourceConfig;
        this.warmPoolStatus = builder.warmPoolStatus;
        this.vpcConfig = builder.vpcConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.creationTime = builder.creationTime;
        this.trainingStartTime = builder.trainingStartTime;
        this.trainingEndTime = builder.trainingEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.secondaryStatusTransitions = builder.secondaryStatusTransitions;
        this.finalMetricDataList = builder.finalMetricDataList;
        this.enableNetworkIsolation = builder.enableNetworkIsolation;
        this.enableInterContainerTrafficEncryption = builder.enableInterContainerTrafficEncryption;
        this.enableManagedSpotTraining = builder.enableManagedSpotTraining;
        this.checkpointConfig = builder.checkpointConfig;
        this.trainingTimeInSeconds = builder.trainingTimeInSeconds;
        this.billableTimeInSeconds = builder.billableTimeInSeconds;
        this.debugHookConfig = builder.debugHookConfig;
        this.experimentConfig = builder.experimentConfig;
        this.debugRuleConfigurations = builder.debugRuleConfigurations;
        this.tensorBoardOutputConfig = builder.tensorBoardOutputConfig;
        this.debugRuleEvaluationStatuses = builder.debugRuleEvaluationStatuses;
        this.profilerConfig = builder.profilerConfig;
        this.profilerRuleConfigurations = builder.profilerRuleConfigurations;
        this.profilerRuleEvaluationStatuses = builder.profilerRuleEvaluationStatuses;
        this.profilingStatus = builder.profilingStatus;
        this.environment = builder.environment;
        this.retryStrategy = builder.retryStrategy;
        this.remoteDebugConfig = builder.remoteDebugConfig;
        this.infraCheckConfig = builder.infraCheckConfig;
    }

    public final String trainingJobName() {
        return this.trainingJobName;
    }

    public final String trainingJobArn() {
        return this.trainingJobArn;
    }

    public final String tuningJobArn() {
        return this.tuningJobArn;
    }

    public final String labelingJobArn() {
        return this.labelingJobArn;
    }

    public final String autoMLJobArn() {
        return this.autoMLJobArn;
    }

    public final ModelArtifacts modelArtifacts() {
        return this.modelArtifacts;
    }

    public final TrainingJobStatus trainingJobStatus() {
        return TrainingJobStatus.fromValue(this.trainingJobStatus);
    }

    public final String trainingJobStatusAsString() {
        return this.trainingJobStatus;
    }

    public final SecondaryStatus secondaryStatus() {
        return SecondaryStatus.fromValue(this.secondaryStatus);
    }

    public final String secondaryStatusAsString() {
        return this.secondaryStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final boolean hasHyperParameters() {
        return this.hyperParameters != null && !(this.hyperParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> hyperParameters() {
        return this.hyperParameters;
    }

    public final AlgorithmSpecification algorithmSpecification() {
        return this.algorithmSpecification;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasInputDataConfig() {
        return this.inputDataConfig != null && !(this.inputDataConfig instanceof SdkAutoConstructList);
    }

    public final List<Channel> inputDataConfig() {
        return this.inputDataConfig;
    }

    public final OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final ResourceConfig resourceConfig() {
        return this.resourceConfig;
    }

    public final WarmPoolStatus warmPoolStatus() {
        return this.warmPoolStatus;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final StoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant trainingStartTime() {
        return this.trainingStartTime;
    }

    public final Instant trainingEndTime() {
        return this.trainingEndTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final boolean hasSecondaryStatusTransitions() {
        return this.secondaryStatusTransitions != null && !(this.secondaryStatusTransitions instanceof SdkAutoConstructList);
    }

    public final List<SecondaryStatusTransition> secondaryStatusTransitions() {
        return this.secondaryStatusTransitions;
    }

    public final boolean hasFinalMetricDataList() {
        return this.finalMetricDataList != null && !(this.finalMetricDataList instanceof SdkAutoConstructList);
    }

    public final List<MetricData> finalMetricDataList() {
        return this.finalMetricDataList;
    }

    public final Boolean enableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public final Boolean enableInterContainerTrafficEncryption() {
        return this.enableInterContainerTrafficEncryption;
    }

    public final Boolean enableManagedSpotTraining() {
        return this.enableManagedSpotTraining;
    }

    public final CheckpointConfig checkpointConfig() {
        return this.checkpointConfig;
    }

    public final Integer trainingTimeInSeconds() {
        return this.trainingTimeInSeconds;
    }

    public final Integer billableTimeInSeconds() {
        return this.billableTimeInSeconds;
    }

    public final DebugHookConfig debugHookConfig() {
        return this.debugHookConfig;
    }

    public final ExperimentConfig experimentConfig() {
        return this.experimentConfig;
    }

    public final boolean hasDebugRuleConfigurations() {
        return this.debugRuleConfigurations != null && !(this.debugRuleConfigurations instanceof SdkAutoConstructList);
    }

    public final List<DebugRuleConfiguration> debugRuleConfigurations() {
        return this.debugRuleConfigurations;
    }

    public final TensorBoardOutputConfig tensorBoardOutputConfig() {
        return this.tensorBoardOutputConfig;
    }

    public final boolean hasDebugRuleEvaluationStatuses() {
        return this.debugRuleEvaluationStatuses != null && !(this.debugRuleEvaluationStatuses instanceof SdkAutoConstructList);
    }

    public final List<DebugRuleEvaluationStatus> debugRuleEvaluationStatuses() {
        return this.debugRuleEvaluationStatuses;
    }

    public final ProfilerConfig profilerConfig() {
        return this.profilerConfig;
    }

    public final boolean hasProfilerRuleConfigurations() {
        return this.profilerRuleConfigurations != null && !(this.profilerRuleConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ProfilerRuleConfiguration> profilerRuleConfigurations() {
        return this.profilerRuleConfigurations;
    }

    public final boolean hasProfilerRuleEvaluationStatuses() {
        return this.profilerRuleEvaluationStatuses != null && !(this.profilerRuleEvaluationStatuses instanceof SdkAutoConstructList);
    }

    public final List<ProfilerRuleEvaluationStatus> profilerRuleEvaluationStatuses() {
        return this.profilerRuleEvaluationStatuses;
    }

    public final ProfilingStatus profilingStatus() {
        return ProfilingStatus.fromValue(this.profilingStatus);
    }

    public final String profilingStatusAsString() {
        return this.profilingStatus;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environment() {
        return this.environment;
    }

    public final RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public final RemoteDebugConfig remoteDebugConfig() {
        return this.remoteDebugConfig;
    }

    public final InfraCheckConfig infraCheckConfig() {
        return this.infraCheckConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tuningJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHyperParameters() ? this.hyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputDataConfig() ? this.inputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmPoolStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondaryStatusTransitions() ? this.secondaryStatusTransitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFinalMetricDataList() ? this.finalMetricDataList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableNetworkIsolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableInterContainerTrafficEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableManagedSpotTraining());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.billableTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.debugHookConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDebugRuleConfigurations() ? this.debugRuleConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tensorBoardOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDebugRuleEvaluationStatuses() ? this.debugRuleEvaluationStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.profilerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfilerRuleConfigurations() ? this.profilerRuleConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfilerRuleEvaluationStatuses() ? this.profilerRuleEvaluationStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.profilingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.retryStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDebugConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.infraCheckConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrainingJobResponse)) {
            return false;
        }
        DescribeTrainingJobResponse other = (DescribeTrainingJobResponse)((Object)obj);
        return Objects.equals(this.trainingJobName(), other.trainingJobName()) && Objects.equals(this.trainingJobArn(), other.trainingJobArn()) && Objects.equals(this.tuningJobArn(), other.tuningJobArn()) && Objects.equals(this.labelingJobArn(), other.labelingJobArn()) && Objects.equals(this.autoMLJobArn(), other.autoMLJobArn()) && Objects.equals(this.modelArtifacts(), other.modelArtifacts()) && Objects.equals(this.trainingJobStatusAsString(), other.trainingJobStatusAsString()) && Objects.equals(this.secondaryStatusAsString(), other.secondaryStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && this.hasHyperParameters() == other.hasHyperParameters() && Objects.equals(this.hyperParameters(), other.hyperParameters()) && Objects.equals(this.algorithmSpecification(), other.algorithmSpecification()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasInputDataConfig() == other.hasInputDataConfig() && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.resourceConfig(), other.resourceConfig()) && Objects.equals(this.warmPoolStatus(), other.warmPoolStatus()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.trainingStartTime(), other.trainingStartTime()) && Objects.equals(this.trainingEndTime(), other.trainingEndTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && this.hasSecondaryStatusTransitions() == other.hasSecondaryStatusTransitions() && Objects.equals(this.secondaryStatusTransitions(), other.secondaryStatusTransitions()) && this.hasFinalMetricDataList() == other.hasFinalMetricDataList() && Objects.equals(this.finalMetricDataList(), other.finalMetricDataList()) && Objects.equals(this.enableNetworkIsolation(), other.enableNetworkIsolation()) && Objects.equals(this.enableInterContainerTrafficEncryption(), other.enableInterContainerTrafficEncryption()) && Objects.equals(this.enableManagedSpotTraining(), other.enableManagedSpotTraining()) && Objects.equals(this.checkpointConfig(), other.checkpointConfig()) && Objects.equals(this.trainingTimeInSeconds(), other.trainingTimeInSeconds()) && Objects.equals(this.billableTimeInSeconds(), other.billableTimeInSeconds()) && Objects.equals(this.debugHookConfig(), other.debugHookConfig()) && Objects.equals(this.experimentConfig(), other.experimentConfig()) && this.hasDebugRuleConfigurations() == other.hasDebugRuleConfigurations() && Objects.equals(this.debugRuleConfigurations(), other.debugRuleConfigurations()) && Objects.equals(this.tensorBoardOutputConfig(), other.tensorBoardOutputConfig()) && this.hasDebugRuleEvaluationStatuses() == other.hasDebugRuleEvaluationStatuses() && Objects.equals(this.debugRuleEvaluationStatuses(), other.debugRuleEvaluationStatuses()) && Objects.equals(this.profilerConfig(), other.profilerConfig()) && this.hasProfilerRuleConfigurations() == other.hasProfilerRuleConfigurations() && Objects.equals(this.profilerRuleConfigurations(), other.profilerRuleConfigurations()) && this.hasProfilerRuleEvaluationStatuses() == other.hasProfilerRuleEvaluationStatuses() && Objects.equals(this.profilerRuleEvaluationStatuses(), other.profilerRuleEvaluationStatuses()) && Objects.equals(this.profilingStatusAsString(), other.profilingStatusAsString()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.retryStrategy(), other.retryStrategy()) && Objects.equals(this.remoteDebugConfig(), other.remoteDebugConfig()) && Objects.equals(this.infraCheckConfig(), other.infraCheckConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTrainingJobResponse").add("TrainingJobName", (Object)this.trainingJobName()).add("TrainingJobArn", (Object)this.trainingJobArn()).add("TuningJobArn", (Object)this.tuningJobArn()).add("LabelingJobArn", (Object)this.labelingJobArn()).add("AutoMLJobArn", (Object)this.autoMLJobArn()).add("ModelArtifacts", (Object)this.modelArtifacts()).add("TrainingJobStatus", (Object)this.trainingJobStatusAsString()).add("SecondaryStatus", (Object)this.secondaryStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("HyperParameters", this.hasHyperParameters() ? this.hyperParameters() : null).add("AlgorithmSpecification", (Object)this.algorithmSpecification()).add("RoleArn", (Object)this.roleArn()).add("InputDataConfig", this.hasInputDataConfig() ? this.inputDataConfig() : null).add("OutputDataConfig", (Object)this.outputDataConfig()).add("ResourceConfig", (Object)this.resourceConfig()).add("WarmPoolStatus", (Object)this.warmPoolStatus()).add("VpcConfig", (Object)this.vpcConfig()).add("StoppingCondition", (Object)this.stoppingCondition()).add("CreationTime", (Object)this.creationTime()).add("TrainingStartTime", (Object)this.trainingStartTime()).add("TrainingEndTime", (Object)this.trainingEndTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("SecondaryStatusTransitions", this.hasSecondaryStatusTransitions() ? this.secondaryStatusTransitions() : null).add("FinalMetricDataList", this.hasFinalMetricDataList() ? this.finalMetricDataList() : null).add("EnableNetworkIsolation", (Object)this.enableNetworkIsolation()).add("EnableInterContainerTrafficEncryption", (Object)this.enableInterContainerTrafficEncryption()).add("EnableManagedSpotTraining", (Object)this.enableManagedSpotTraining()).add("CheckpointConfig", (Object)this.checkpointConfig()).add("TrainingTimeInSeconds", (Object)this.trainingTimeInSeconds()).add("BillableTimeInSeconds", (Object)this.billableTimeInSeconds()).add("DebugHookConfig", (Object)this.debugHookConfig()).add("ExperimentConfig", (Object)this.experimentConfig()).add("DebugRuleConfigurations", this.hasDebugRuleConfigurations() ? this.debugRuleConfigurations() : null).add("TensorBoardOutputConfig", (Object)this.tensorBoardOutputConfig()).add("DebugRuleEvaluationStatuses", this.hasDebugRuleEvaluationStatuses() ? this.debugRuleEvaluationStatuses() : null).add("ProfilerConfig", (Object)this.profilerConfig()).add("ProfilerRuleConfigurations", this.hasProfilerRuleConfigurations() ? this.profilerRuleConfigurations() : null).add("ProfilerRuleEvaluationStatuses", this.hasProfilerRuleEvaluationStatuses() ? this.profilerRuleEvaluationStatuses() : null).add("ProfilingStatus", (Object)this.profilingStatusAsString()).add("Environment", this.hasEnvironment() ? this.environment() : null).add("RetryStrategy", (Object)this.retryStrategy()).add("RemoteDebugConfig", (Object)this.remoteDebugConfig()).add("InfraCheckConfig", (Object)this.infraCheckConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingJobName": {
                return Optional.ofNullable(clazz.cast(this.trainingJobName()));
            }
            case "TrainingJobArn": {
                return Optional.ofNullable(clazz.cast(this.trainingJobArn()));
            }
            case "TuningJobArn": {
                return Optional.ofNullable(clazz.cast(this.tuningJobArn()));
            }
            case "LabelingJobArn": {
                return Optional.ofNullable(clazz.cast(this.labelingJobArn()));
            }
            case "AutoMLJobArn": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobArn()));
            }
            case "ModelArtifacts": {
                return Optional.ofNullable(clazz.cast(this.modelArtifacts()));
            }
            case "TrainingJobStatus": {
                return Optional.ofNullable(clazz.cast(this.trainingJobStatusAsString()));
            }
            case "SecondaryStatus": {
                return Optional.ofNullable(clazz.cast(this.secondaryStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "HyperParameters": {
                return Optional.ofNullable(clazz.cast(this.hyperParameters()));
            }
            case "AlgorithmSpecification": {
                return Optional.ofNullable(clazz.cast(this.algorithmSpecification()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "ResourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
            case "WarmPoolStatus": {
                return Optional.ofNullable(clazz.cast(this.warmPoolStatus()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TrainingStartTime": {
                return Optional.ofNullable(clazz.cast(this.trainingStartTime()));
            }
            case "TrainingEndTime": {
                return Optional.ofNullable(clazz.cast(this.trainingEndTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "SecondaryStatusTransitions": {
                return Optional.ofNullable(clazz.cast(this.secondaryStatusTransitions()));
            }
            case "FinalMetricDataList": {
                return Optional.ofNullable(clazz.cast(this.finalMetricDataList()));
            }
            case "EnableNetworkIsolation": {
                return Optional.ofNullable(clazz.cast(this.enableNetworkIsolation()));
            }
            case "EnableInterContainerTrafficEncryption": {
                return Optional.ofNullable(clazz.cast(this.enableInterContainerTrafficEncryption()));
            }
            case "EnableManagedSpotTraining": {
                return Optional.ofNullable(clazz.cast(this.enableManagedSpotTraining()));
            }
            case "CheckpointConfig": {
                return Optional.ofNullable(clazz.cast(this.checkpointConfig()));
            }
            case "TrainingTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.trainingTimeInSeconds()));
            }
            case "BillableTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.billableTimeInSeconds()));
            }
            case "DebugHookConfig": {
                return Optional.ofNullable(clazz.cast(this.debugHookConfig()));
            }
            case "ExperimentConfig": {
                return Optional.ofNullable(clazz.cast(this.experimentConfig()));
            }
            case "DebugRuleConfigurations": {
                return Optional.ofNullable(clazz.cast(this.debugRuleConfigurations()));
            }
            case "TensorBoardOutputConfig": {
                return Optional.ofNullable(clazz.cast(this.tensorBoardOutputConfig()));
            }
            case "DebugRuleEvaluationStatuses": {
                return Optional.ofNullable(clazz.cast(this.debugRuleEvaluationStatuses()));
            }
            case "ProfilerConfig": {
                return Optional.ofNullable(clazz.cast(this.profilerConfig()));
            }
            case "ProfilerRuleConfigurations": {
                return Optional.ofNullable(clazz.cast(this.profilerRuleConfigurations()));
            }
            case "ProfilerRuleEvaluationStatuses": {
                return Optional.ofNullable(clazz.cast(this.profilerRuleEvaluationStatuses()));
            }
            case "ProfilingStatus": {
                return Optional.ofNullable(clazz.cast(this.profilingStatusAsString()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "RetryStrategy": {
                return Optional.ofNullable(clazz.cast(this.retryStrategy()));
            }
            case "RemoteDebugConfig": {
                return Optional.ofNullable(clazz.cast(this.remoteDebugConfig()));
            }
            case "InfraCheckConfig": {
                return Optional.ofNullable(clazz.cast(this.infraCheckConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrainingJobResponse, T> g) {
        return obj -> g.apply((DescribeTrainingJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String trainingJobName;
        private String trainingJobArn;
        private String tuningJobArn;
        private String labelingJobArn;
        private String autoMLJobArn;
        private ModelArtifacts modelArtifacts;
        private String trainingJobStatus;
        private String secondaryStatus;
        private String failureReason;
        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private AlgorithmSpecification algorithmSpecification;
        private String roleArn;
        private List<Channel> inputDataConfig = DefaultSdkAutoConstructList.getInstance();
        private OutputDataConfig outputDataConfig;
        private ResourceConfig resourceConfig;
        private WarmPoolStatus warmPoolStatus;
        private VpcConfig vpcConfig;
        private StoppingCondition stoppingCondition;
        private Instant creationTime;
        private Instant trainingStartTime;
        private Instant trainingEndTime;
        private Instant lastModifiedTime;
        private List<SecondaryStatusTransition> secondaryStatusTransitions = DefaultSdkAutoConstructList.getInstance();
        private List<MetricData> finalMetricDataList = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableNetworkIsolation;
        private Boolean enableInterContainerTrafficEncryption;
        private Boolean enableManagedSpotTraining;
        private CheckpointConfig checkpointConfig;
        private Integer trainingTimeInSeconds;
        private Integer billableTimeInSeconds;
        private DebugHookConfig debugHookConfig;
        private ExperimentConfig experimentConfig;
        private List<DebugRuleConfiguration> debugRuleConfigurations = DefaultSdkAutoConstructList.getInstance();
        private TensorBoardOutputConfig tensorBoardOutputConfig;
        private List<DebugRuleEvaluationStatus> debugRuleEvaluationStatuses = DefaultSdkAutoConstructList.getInstance();
        private ProfilerConfig profilerConfig;
        private List<ProfilerRuleConfiguration> profilerRuleConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<ProfilerRuleEvaluationStatus> profilerRuleEvaluationStatuses = DefaultSdkAutoConstructList.getInstance();
        private String profilingStatus;
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();
        private RetryStrategy retryStrategy;
        private RemoteDebugConfig remoteDebugConfig;
        private InfraCheckConfig infraCheckConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrainingJobResponse model) {
            super(model);
            this.trainingJobName(model.trainingJobName);
            this.trainingJobArn(model.trainingJobArn);
            this.tuningJobArn(model.tuningJobArn);
            this.labelingJobArn(model.labelingJobArn);
            this.autoMLJobArn(model.autoMLJobArn);
            this.modelArtifacts(model.modelArtifacts);
            this.trainingJobStatus(model.trainingJobStatus);
            this.secondaryStatus(model.secondaryStatus);
            this.failureReason(model.failureReason);
            this.hyperParameters(model.hyperParameters);
            this.algorithmSpecification(model.algorithmSpecification);
            this.roleArn(model.roleArn);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.resourceConfig(model.resourceConfig);
            this.warmPoolStatus(model.warmPoolStatus);
            this.vpcConfig(model.vpcConfig);
            this.stoppingCondition(model.stoppingCondition);
            this.creationTime(model.creationTime);
            this.trainingStartTime(model.trainingStartTime);
            this.trainingEndTime(model.trainingEndTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.secondaryStatusTransitions(model.secondaryStatusTransitions);
            this.finalMetricDataList(model.finalMetricDataList);
            this.enableNetworkIsolation(model.enableNetworkIsolation);
            this.enableInterContainerTrafficEncryption(model.enableInterContainerTrafficEncryption);
            this.enableManagedSpotTraining(model.enableManagedSpotTraining);
            this.checkpointConfig(model.checkpointConfig);
            this.trainingTimeInSeconds(model.trainingTimeInSeconds);
            this.billableTimeInSeconds(model.billableTimeInSeconds);
            this.debugHookConfig(model.debugHookConfig);
            this.experimentConfig(model.experimentConfig);
            this.debugRuleConfigurations(model.debugRuleConfigurations);
            this.tensorBoardOutputConfig(model.tensorBoardOutputConfig);
            this.debugRuleEvaluationStatuses(model.debugRuleEvaluationStatuses);
            this.profilerConfig(model.profilerConfig);
            this.profilerRuleConfigurations(model.profilerRuleConfigurations);
            this.profilerRuleEvaluationStatuses(model.profilerRuleEvaluationStatuses);
            this.profilingStatus(model.profilingStatus);
            this.environment(model.environment);
            this.retryStrategy(model.retryStrategy);
            this.remoteDebugConfig(model.remoteDebugConfig);
            this.infraCheckConfig(model.infraCheckConfig);
        }

        public final String getTrainingJobName() {
            return this.trainingJobName;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final String getTrainingJobArn() {
            return this.trainingJobArn;
        }

        public final void setTrainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
        }

        @Override
        public final Builder trainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
            return this;
        }

        public final String getTuningJobArn() {
            return this.tuningJobArn;
        }

        public final void setTuningJobArn(String tuningJobArn) {
            this.tuningJobArn = tuningJobArn;
        }

        @Override
        public final Builder tuningJobArn(String tuningJobArn) {
            this.tuningJobArn = tuningJobArn;
            return this;
        }

        public final String getLabelingJobArn() {
            return this.labelingJobArn;
        }

        public final void setLabelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
        }

        @Override
        public final Builder labelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
            return this;
        }

        public final String getAutoMLJobArn() {
            return this.autoMLJobArn;
        }

        public final void setAutoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
        }

        @Override
        public final Builder autoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
            return this;
        }

        public final ModelArtifacts.Builder getModelArtifacts() {
            return this.modelArtifacts != null ? this.modelArtifacts.toBuilder() : null;
        }

        public final void setModelArtifacts(ModelArtifacts.BuilderImpl modelArtifacts) {
            this.modelArtifacts = modelArtifacts != null ? modelArtifacts.build() : null;
        }

        @Override
        public final Builder modelArtifacts(ModelArtifacts modelArtifacts) {
            this.modelArtifacts = modelArtifacts;
            return this;
        }

        public final String getTrainingJobStatus() {
            return this.trainingJobStatus;
        }

        public final void setTrainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
        }

        @Override
        public final Builder trainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
            return this;
        }

        @Override
        public final Builder trainingJobStatus(TrainingJobStatus trainingJobStatus) {
            this.trainingJobStatus(trainingJobStatus == null ? null : trainingJobStatus.toString());
            return this;
        }

        public final String getSecondaryStatus() {
            return this.secondaryStatus;
        }

        public final void setSecondaryStatus(String secondaryStatus) {
            this.secondaryStatus = secondaryStatus;
        }

        @Override
        public final Builder secondaryStatus(String secondaryStatus) {
            this.secondaryStatus = secondaryStatus;
            return this;
        }

        @Override
        public final Builder secondaryStatus(SecondaryStatus secondaryStatus) {
            this.secondaryStatus(secondaryStatus == null ? null : secondaryStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Map<String, String> getHyperParameters() {
            if (this.hyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.hyperParameters;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final AlgorithmSpecification.Builder getAlgorithmSpecification() {
            return this.algorithmSpecification != null ? this.algorithmSpecification.toBuilder() : null;
        }

        public final void setAlgorithmSpecification(AlgorithmSpecification.BuilderImpl algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification != null ? algorithmSpecification.build() : null;
        }

        @Override
        public final Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Channel.Builder> getInputDataConfig() {
            List<Channel.Builder> result = InputDataConfigCopier.copyToBuilder(this.inputDataConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDataConfig(Collection<Channel.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copyFromBuilder(inputDataConfig);
        }

        @Override
        public final Builder inputDataConfig(Collection<Channel> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Channel ... inputDataConfig) {
            this.inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<Channel.Builder> ... inputDataConfig) {
            this.inputDataConfig(Stream.of(inputDataConfig).map(c -> (Channel)((Channel.Builder)Channel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return this.resourceConfig != null ? this.resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final WarmPoolStatus.Builder getWarmPoolStatus() {
            return this.warmPoolStatus != null ? this.warmPoolStatus.toBuilder() : null;
        }

        public final void setWarmPoolStatus(WarmPoolStatus.BuilderImpl warmPoolStatus) {
            this.warmPoolStatus = warmPoolStatus != null ? warmPoolStatus.build() : null;
        }

        @Override
        public final Builder warmPoolStatus(WarmPoolStatus warmPoolStatus) {
            this.warmPoolStatus = warmPoolStatus;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getTrainingStartTime() {
            return this.trainingStartTime;
        }

        public final void setTrainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
        }

        @Override
        public final Builder trainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
            return this;
        }

        public final Instant getTrainingEndTime() {
            return this.trainingEndTime;
        }

        public final void setTrainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
        }

        @Override
        public final Builder trainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final List<SecondaryStatusTransition.Builder> getSecondaryStatusTransitions() {
            List<SecondaryStatusTransition.Builder> result = SecondaryStatusTransitionsCopier.copyToBuilder(this.secondaryStatusTransitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondaryStatusTransitions(Collection<SecondaryStatusTransition.BuilderImpl> secondaryStatusTransitions) {
            this.secondaryStatusTransitions = SecondaryStatusTransitionsCopier.copyFromBuilder(secondaryStatusTransitions);
        }

        @Override
        public final Builder secondaryStatusTransitions(Collection<SecondaryStatusTransition> secondaryStatusTransitions) {
            this.secondaryStatusTransitions = SecondaryStatusTransitionsCopier.copy(secondaryStatusTransitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryStatusTransitions(SecondaryStatusTransition ... secondaryStatusTransitions) {
            this.secondaryStatusTransitions(Arrays.asList(secondaryStatusTransitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryStatusTransitions(Consumer<SecondaryStatusTransition.Builder> ... secondaryStatusTransitions) {
            this.secondaryStatusTransitions(Stream.of(secondaryStatusTransitions).map(c -> (SecondaryStatusTransition)((SecondaryStatusTransition.Builder)SecondaryStatusTransition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MetricData.Builder> getFinalMetricDataList() {
            List<MetricData.Builder> result = FinalMetricDataListCopier.copyToBuilder(this.finalMetricDataList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFinalMetricDataList(Collection<MetricData.BuilderImpl> finalMetricDataList) {
            this.finalMetricDataList = FinalMetricDataListCopier.copyFromBuilder(finalMetricDataList);
        }

        @Override
        public final Builder finalMetricDataList(Collection<MetricData> finalMetricDataList) {
            this.finalMetricDataList = FinalMetricDataListCopier.copy(finalMetricDataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder finalMetricDataList(MetricData ... finalMetricDataList) {
            this.finalMetricDataList(Arrays.asList(finalMetricDataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder finalMetricDataList(Consumer<MetricData.Builder> ... finalMetricDataList) {
            this.finalMetricDataList(Stream.of(finalMetricDataList).map(c -> (MetricData)((MetricData.Builder)MetricData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnableNetworkIsolation() {
            return this.enableNetworkIsolation;
        }

        public final void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
        }

        @Override
        public final Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        public final Boolean getEnableInterContainerTrafficEncryption() {
            return this.enableInterContainerTrafficEncryption;
        }

        public final void setEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
        }

        @Override
        public final Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
            return this;
        }

        public final Boolean getEnableManagedSpotTraining() {
            return this.enableManagedSpotTraining;
        }

        public final void setEnableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
        }

        @Override
        public final Builder enableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
            return this;
        }

        public final CheckpointConfig.Builder getCheckpointConfig() {
            return this.checkpointConfig != null ? this.checkpointConfig.toBuilder() : null;
        }

        public final void setCheckpointConfig(CheckpointConfig.BuilderImpl checkpointConfig) {
            this.checkpointConfig = checkpointConfig != null ? checkpointConfig.build() : null;
        }

        @Override
        public final Builder checkpointConfig(CheckpointConfig checkpointConfig) {
            this.checkpointConfig = checkpointConfig;
            return this;
        }

        public final Integer getTrainingTimeInSeconds() {
            return this.trainingTimeInSeconds;
        }

        public final void setTrainingTimeInSeconds(Integer trainingTimeInSeconds) {
            this.trainingTimeInSeconds = trainingTimeInSeconds;
        }

        @Override
        public final Builder trainingTimeInSeconds(Integer trainingTimeInSeconds) {
            this.trainingTimeInSeconds = trainingTimeInSeconds;
            return this;
        }

        public final Integer getBillableTimeInSeconds() {
            return this.billableTimeInSeconds;
        }

        public final void setBillableTimeInSeconds(Integer billableTimeInSeconds) {
            this.billableTimeInSeconds = billableTimeInSeconds;
        }

        @Override
        public final Builder billableTimeInSeconds(Integer billableTimeInSeconds) {
            this.billableTimeInSeconds = billableTimeInSeconds;
            return this;
        }

        public final DebugHookConfig.Builder getDebugHookConfig() {
            return this.debugHookConfig != null ? this.debugHookConfig.toBuilder() : null;
        }

        public final void setDebugHookConfig(DebugHookConfig.BuilderImpl debugHookConfig) {
            this.debugHookConfig = debugHookConfig != null ? debugHookConfig.build() : null;
        }

        @Override
        public final Builder debugHookConfig(DebugHookConfig debugHookConfig) {
            this.debugHookConfig = debugHookConfig;
            return this;
        }

        public final ExperimentConfig.Builder getExperimentConfig() {
            return this.experimentConfig != null ? this.experimentConfig.toBuilder() : null;
        }

        public final void setExperimentConfig(ExperimentConfig.BuilderImpl experimentConfig) {
            this.experimentConfig = experimentConfig != null ? experimentConfig.build() : null;
        }

        @Override
        public final Builder experimentConfig(ExperimentConfig experimentConfig) {
            this.experimentConfig = experimentConfig;
            return this;
        }

        public final List<DebugRuleConfiguration.Builder> getDebugRuleConfigurations() {
            List<DebugRuleConfiguration.Builder> result = DebugRuleConfigurationsCopier.copyToBuilder(this.debugRuleConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDebugRuleConfigurations(Collection<DebugRuleConfiguration.BuilderImpl> debugRuleConfigurations) {
            this.debugRuleConfigurations = DebugRuleConfigurationsCopier.copyFromBuilder(debugRuleConfigurations);
        }

        @Override
        public final Builder debugRuleConfigurations(Collection<DebugRuleConfiguration> debugRuleConfigurations) {
            this.debugRuleConfigurations = DebugRuleConfigurationsCopier.copy(debugRuleConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugRuleConfigurations(DebugRuleConfiguration ... debugRuleConfigurations) {
            this.debugRuleConfigurations(Arrays.asList(debugRuleConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugRuleConfigurations(Consumer<DebugRuleConfiguration.Builder> ... debugRuleConfigurations) {
            this.debugRuleConfigurations(Stream.of(debugRuleConfigurations).map(c -> (DebugRuleConfiguration)((DebugRuleConfiguration.Builder)DebugRuleConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TensorBoardOutputConfig.Builder getTensorBoardOutputConfig() {
            return this.tensorBoardOutputConfig != null ? this.tensorBoardOutputConfig.toBuilder() : null;
        }

        public final void setTensorBoardOutputConfig(TensorBoardOutputConfig.BuilderImpl tensorBoardOutputConfig) {
            this.tensorBoardOutputConfig = tensorBoardOutputConfig != null ? tensorBoardOutputConfig.build() : null;
        }

        @Override
        public final Builder tensorBoardOutputConfig(TensorBoardOutputConfig tensorBoardOutputConfig) {
            this.tensorBoardOutputConfig = tensorBoardOutputConfig;
            return this;
        }

        public final List<DebugRuleEvaluationStatus.Builder> getDebugRuleEvaluationStatuses() {
            List<DebugRuleEvaluationStatus.Builder> result = DebugRuleEvaluationStatusesCopier.copyToBuilder(this.debugRuleEvaluationStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDebugRuleEvaluationStatuses(Collection<DebugRuleEvaluationStatus.BuilderImpl> debugRuleEvaluationStatuses) {
            this.debugRuleEvaluationStatuses = DebugRuleEvaluationStatusesCopier.copyFromBuilder(debugRuleEvaluationStatuses);
        }

        @Override
        public final Builder debugRuleEvaluationStatuses(Collection<DebugRuleEvaluationStatus> debugRuleEvaluationStatuses) {
            this.debugRuleEvaluationStatuses = DebugRuleEvaluationStatusesCopier.copy(debugRuleEvaluationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugRuleEvaluationStatuses(DebugRuleEvaluationStatus ... debugRuleEvaluationStatuses) {
            this.debugRuleEvaluationStatuses(Arrays.asList(debugRuleEvaluationStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugRuleEvaluationStatuses(Consumer<DebugRuleEvaluationStatus.Builder> ... debugRuleEvaluationStatuses) {
            this.debugRuleEvaluationStatuses(Stream.of(debugRuleEvaluationStatuses).map(c -> (DebugRuleEvaluationStatus)((DebugRuleEvaluationStatus.Builder)DebugRuleEvaluationStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProfilerConfig.Builder getProfilerConfig() {
            return this.profilerConfig != null ? this.profilerConfig.toBuilder() : null;
        }

        public final void setProfilerConfig(ProfilerConfig.BuilderImpl profilerConfig) {
            this.profilerConfig = profilerConfig != null ? profilerConfig.build() : null;
        }

        @Override
        public final Builder profilerConfig(ProfilerConfig profilerConfig) {
            this.profilerConfig = profilerConfig;
            return this;
        }

        public final List<ProfilerRuleConfiguration.Builder> getProfilerRuleConfigurations() {
            List<ProfilerRuleConfiguration.Builder> result = ProfilerRuleConfigurationsCopier.copyToBuilder(this.profilerRuleConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfilerRuleConfigurations(Collection<ProfilerRuleConfiguration.BuilderImpl> profilerRuleConfigurations) {
            this.profilerRuleConfigurations = ProfilerRuleConfigurationsCopier.copyFromBuilder(profilerRuleConfigurations);
        }

        @Override
        public final Builder profilerRuleConfigurations(Collection<ProfilerRuleConfiguration> profilerRuleConfigurations) {
            this.profilerRuleConfigurations = ProfilerRuleConfigurationsCopier.copy(profilerRuleConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilerRuleConfigurations(ProfilerRuleConfiguration ... profilerRuleConfigurations) {
            this.profilerRuleConfigurations(Arrays.asList(profilerRuleConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilerRuleConfigurations(Consumer<ProfilerRuleConfiguration.Builder> ... profilerRuleConfigurations) {
            this.profilerRuleConfigurations(Stream.of(profilerRuleConfigurations).map(c -> (ProfilerRuleConfiguration)((ProfilerRuleConfiguration.Builder)ProfilerRuleConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ProfilerRuleEvaluationStatus.Builder> getProfilerRuleEvaluationStatuses() {
            List<ProfilerRuleEvaluationStatus.Builder> result = ProfilerRuleEvaluationStatusesCopier.copyToBuilder(this.profilerRuleEvaluationStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfilerRuleEvaluationStatuses(Collection<ProfilerRuleEvaluationStatus.BuilderImpl> profilerRuleEvaluationStatuses) {
            this.profilerRuleEvaluationStatuses = ProfilerRuleEvaluationStatusesCopier.copyFromBuilder(profilerRuleEvaluationStatuses);
        }

        @Override
        public final Builder profilerRuleEvaluationStatuses(Collection<ProfilerRuleEvaluationStatus> profilerRuleEvaluationStatuses) {
            this.profilerRuleEvaluationStatuses = ProfilerRuleEvaluationStatusesCopier.copy(profilerRuleEvaluationStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilerRuleEvaluationStatuses(ProfilerRuleEvaluationStatus ... profilerRuleEvaluationStatuses) {
            this.profilerRuleEvaluationStatuses(Arrays.asList(profilerRuleEvaluationStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilerRuleEvaluationStatuses(Consumer<ProfilerRuleEvaluationStatus.Builder> ... profilerRuleEvaluationStatuses) {
            this.profilerRuleEvaluationStatuses(Stream.of(profilerRuleEvaluationStatuses).map(c -> (ProfilerRuleEvaluationStatus)((ProfilerRuleEvaluationStatus.Builder)ProfilerRuleEvaluationStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProfilingStatus() {
            return this.profilingStatus;
        }

        public final void setProfilingStatus(String profilingStatus) {
            this.profilingStatus = profilingStatus;
        }

        @Override
        public final Builder profilingStatus(String profilingStatus) {
            this.profilingStatus = profilingStatus;
            return this;
        }

        @Override
        public final Builder profilingStatus(ProfilingStatus profilingStatus) {
            this.profilingStatus(profilingStatus == null ? null : profilingStatus.toString());
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (this.environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = TrainingEnvironmentMapCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = TrainingEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return this.retryStrategy != null ? this.retryStrategy.toBuilder() : null;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public final RemoteDebugConfig.Builder getRemoteDebugConfig() {
            return this.remoteDebugConfig != null ? this.remoteDebugConfig.toBuilder() : null;
        }

        public final void setRemoteDebugConfig(RemoteDebugConfig.BuilderImpl remoteDebugConfig) {
            this.remoteDebugConfig = remoteDebugConfig != null ? remoteDebugConfig.build() : null;
        }

        @Override
        public final Builder remoteDebugConfig(RemoteDebugConfig remoteDebugConfig) {
            this.remoteDebugConfig = remoteDebugConfig;
            return this;
        }

        public final InfraCheckConfig.Builder getInfraCheckConfig() {
            return this.infraCheckConfig != null ? this.infraCheckConfig.toBuilder() : null;
        }

        public final void setInfraCheckConfig(InfraCheckConfig.BuilderImpl infraCheckConfig) {
            this.infraCheckConfig = infraCheckConfig != null ? infraCheckConfig.build() : null;
        }

        @Override
        public final Builder infraCheckConfig(InfraCheckConfig infraCheckConfig) {
            this.infraCheckConfig = infraCheckConfig;
            return this;
        }

        @Override
        public DescribeTrainingJobResponse build() {
            return new DescribeTrainingJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrainingJobResponse> {
        public Builder trainingJobName(String var1);

        public Builder trainingJobArn(String var1);

        public Builder tuningJobArn(String var1);

        public Builder labelingJobArn(String var1);

        public Builder autoMLJobArn(String var1);

        public Builder modelArtifacts(ModelArtifacts var1);

        default public Builder modelArtifacts(Consumer<ModelArtifacts.Builder> modelArtifacts) {
            return this.modelArtifacts((ModelArtifacts)((ModelArtifacts.Builder)ModelArtifacts.builder().applyMutation(modelArtifacts)).build());
        }

        public Builder trainingJobStatus(String var1);

        public Builder trainingJobStatus(TrainingJobStatus var1);

        public Builder secondaryStatus(String var1);

        public Builder secondaryStatus(SecondaryStatus var1);

        public Builder failureReason(String var1);

        public Builder hyperParameters(Map<String, String> var1);

        public Builder algorithmSpecification(AlgorithmSpecification var1);

        default public Builder algorithmSpecification(Consumer<AlgorithmSpecification.Builder> algorithmSpecification) {
            return this.algorithmSpecification((AlgorithmSpecification)((AlgorithmSpecification.Builder)AlgorithmSpecification.builder().applyMutation(algorithmSpecification)).build());
        }

        public Builder roleArn(String var1);

        public Builder inputDataConfig(Collection<Channel> var1);

        public Builder inputDataConfig(Channel ... var1);

        public Builder inputDataConfig(Consumer<Channel.Builder> ... var1);

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder resourceConfig(ResourceConfig var1);

        default public Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return this.resourceConfig((ResourceConfig)((ResourceConfig.Builder)ResourceConfig.builder().applyMutation(resourceConfig)).build());
        }

        public Builder warmPoolStatus(WarmPoolStatus var1);

        default public Builder warmPoolStatus(Consumer<WarmPoolStatus.Builder> warmPoolStatus) {
            return this.warmPoolStatus((WarmPoolStatus)((WarmPoolStatus.Builder)WarmPoolStatus.builder().applyMutation(warmPoolStatus)).build());
        }

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder stoppingCondition(StoppingCondition var1);

        default public Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((StoppingCondition)((StoppingCondition.Builder)StoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder trainingStartTime(Instant var1);

        public Builder trainingEndTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder secondaryStatusTransitions(Collection<SecondaryStatusTransition> var1);

        public Builder secondaryStatusTransitions(SecondaryStatusTransition ... var1);

        public Builder secondaryStatusTransitions(Consumer<SecondaryStatusTransition.Builder> ... var1);

        public Builder finalMetricDataList(Collection<MetricData> var1);

        public Builder finalMetricDataList(MetricData ... var1);

        public Builder finalMetricDataList(Consumer<MetricData.Builder> ... var1);

        public Builder enableNetworkIsolation(Boolean var1);

        public Builder enableInterContainerTrafficEncryption(Boolean var1);

        public Builder enableManagedSpotTraining(Boolean var1);

        public Builder checkpointConfig(CheckpointConfig var1);

        default public Builder checkpointConfig(Consumer<CheckpointConfig.Builder> checkpointConfig) {
            return this.checkpointConfig((CheckpointConfig)((CheckpointConfig.Builder)CheckpointConfig.builder().applyMutation(checkpointConfig)).build());
        }

        public Builder trainingTimeInSeconds(Integer var1);

        public Builder billableTimeInSeconds(Integer var1);

        public Builder debugHookConfig(DebugHookConfig var1);

        default public Builder debugHookConfig(Consumer<DebugHookConfig.Builder> debugHookConfig) {
            return this.debugHookConfig((DebugHookConfig)((DebugHookConfig.Builder)DebugHookConfig.builder().applyMutation(debugHookConfig)).build());
        }

        public Builder experimentConfig(ExperimentConfig var1);

        default public Builder experimentConfig(Consumer<ExperimentConfig.Builder> experimentConfig) {
            return this.experimentConfig((ExperimentConfig)((ExperimentConfig.Builder)ExperimentConfig.builder().applyMutation(experimentConfig)).build());
        }

        public Builder debugRuleConfigurations(Collection<DebugRuleConfiguration> var1);

        public Builder debugRuleConfigurations(DebugRuleConfiguration ... var1);

        public Builder debugRuleConfigurations(Consumer<DebugRuleConfiguration.Builder> ... var1);

        public Builder tensorBoardOutputConfig(TensorBoardOutputConfig var1);

        default public Builder tensorBoardOutputConfig(Consumer<TensorBoardOutputConfig.Builder> tensorBoardOutputConfig) {
            return this.tensorBoardOutputConfig((TensorBoardOutputConfig)((TensorBoardOutputConfig.Builder)TensorBoardOutputConfig.builder().applyMutation(tensorBoardOutputConfig)).build());
        }

        public Builder debugRuleEvaluationStatuses(Collection<DebugRuleEvaluationStatus> var1);

        public Builder debugRuleEvaluationStatuses(DebugRuleEvaluationStatus ... var1);

        public Builder debugRuleEvaluationStatuses(Consumer<DebugRuleEvaluationStatus.Builder> ... var1);

        public Builder profilerConfig(ProfilerConfig var1);

        default public Builder profilerConfig(Consumer<ProfilerConfig.Builder> profilerConfig) {
            return this.profilerConfig((ProfilerConfig)((ProfilerConfig.Builder)ProfilerConfig.builder().applyMutation(profilerConfig)).build());
        }

        public Builder profilerRuleConfigurations(Collection<ProfilerRuleConfiguration> var1);

        public Builder profilerRuleConfigurations(ProfilerRuleConfiguration ... var1);

        public Builder profilerRuleConfigurations(Consumer<ProfilerRuleConfiguration.Builder> ... var1);

        public Builder profilerRuleEvaluationStatuses(Collection<ProfilerRuleEvaluationStatus> var1);

        public Builder profilerRuleEvaluationStatuses(ProfilerRuleEvaluationStatus ... var1);

        public Builder profilerRuleEvaluationStatuses(Consumer<ProfilerRuleEvaluationStatus.Builder> ... var1);

        public Builder profilingStatus(String var1);

        public Builder profilingStatus(ProfilingStatus var1);

        public Builder environment(Map<String, String> var1);

        public Builder retryStrategy(RetryStrategy var1);

        default public Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return this.retryStrategy((RetryStrategy)((RetryStrategy.Builder)RetryStrategy.builder().applyMutation(retryStrategy)).build());
        }

        public Builder remoteDebugConfig(RemoteDebugConfig var1);

        default public Builder remoteDebugConfig(Consumer<RemoteDebugConfig.Builder> remoteDebugConfig) {
            return this.remoteDebugConfig((RemoteDebugConfig)((RemoteDebugConfig.Builder)RemoteDebugConfig.builder().applyMutation(remoteDebugConfig)).build());
        }

        public Builder infraCheckConfig(InfraCheckConfig var1);

        default public Builder infraCheckConfig(Consumer<InfraCheckConfig.Builder> infraCheckConfig) {
            return this.infraCheckConfig((InfraCheckConfig)((InfraCheckConfig.Builder)InfraCheckConfig.builder().applyMutation(infraCheckConfig)).build());
        }
    }
}

