/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakera2iruntime.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopOutput;
import software.amazon.awssdk.services.sagemakera2iruntime.model.HumanLoopStatus;
import software.amazon.awssdk.services.sagemakera2iruntime.model.SageMakerA2IRuntimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHumanLoopResponse
extends SageMakerA2IRuntimeResponse
implements ToCopyableBuilder<Builder, DescribeHumanLoopResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeHumanLoopResponse.getter(DescribeHumanLoopResponse::creationTime)).setter(DescribeHumanLoopResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeHumanLoopResponse.getter(DescribeHumanLoopResponse::failureReason)).setter(DescribeHumanLoopResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureCode").getter(DescribeHumanLoopResponse.getter(DescribeHumanLoopResponse::failureCode)).setter(DescribeHumanLoopResponse.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()}).build();
    private static final SdkField<String> HUMAN_LOOP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HumanLoopStatus").getter(DescribeHumanLoopResponse.getter(DescribeHumanLoopResponse::humanLoopStatusAsString)).setter(DescribeHumanLoopResponse.setter(Builder::humanLoopStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopStatus").build()}).build();
    private static final SdkField<String> HUMAN_LOOP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HumanLoopName").getter(DescribeHumanLoopResponse.getter(DescribeHumanLoopResponse::humanLoopName)).setter(DescribeHumanLoopResponse.setter(Builder::humanLoopName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopName").build()}).build();
    private static final SdkField<String> HUMAN_LOOP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HumanLoopArn").getter(DescribeHumanLoopResponse.getter(DescribeHumanLoopResponse::humanLoopArn)).setter(DescribeHumanLoopResponse.setter(Builder::humanLoopArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopArn").build()}).build();
    private static final SdkField<String> FLOW_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowDefinitionArn").getter(DescribeHumanLoopResponse.getter(DescribeHumanLoopResponse::flowDefinitionArn)).setter(DescribeHumanLoopResponse.setter(Builder::flowDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionArn").build()}).build();
    private static final SdkField<HumanLoopOutput> HUMAN_LOOP_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HumanLoopOutput").getter(DescribeHumanLoopResponse.getter(DescribeHumanLoopResponse::humanLoopOutput)).setter(DescribeHumanLoopResponse.setter(Builder::humanLoopOutput)).constructor(HumanLoopOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopOutput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, FAILURE_REASON_FIELD, FAILURE_CODE_FIELD, HUMAN_LOOP_STATUS_FIELD, HUMAN_LOOP_NAME_FIELD, HUMAN_LOOP_ARN_FIELD, FLOW_DEFINITION_ARN_FIELD, HUMAN_LOOP_OUTPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeHumanLoopResponse.memberNameToFieldInitializer();
    private final Instant creationTime;
    private final String failureReason;
    private final String failureCode;
    private final String humanLoopStatus;
    private final String humanLoopName;
    private final String humanLoopArn;
    private final String flowDefinitionArn;
    private final HumanLoopOutput humanLoopOutput;

    private DescribeHumanLoopResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
        this.failureCode = builder.failureCode;
        this.humanLoopStatus = builder.humanLoopStatus;
        this.humanLoopName = builder.humanLoopName;
        this.humanLoopArn = builder.humanLoopArn;
        this.flowDefinitionArn = builder.flowDefinitionArn;
        this.humanLoopOutput = builder.humanLoopOutput;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String failureCode() {
        return this.failureCode;
    }

    public final HumanLoopStatus humanLoopStatus() {
        return HumanLoopStatus.fromValue(this.humanLoopStatus);
    }

    public final String humanLoopStatusAsString() {
        return this.humanLoopStatus;
    }

    public final String humanLoopName() {
        return this.humanLoopName;
    }

    public final String humanLoopArn() {
        return this.humanLoopArn;
    }

    public final String flowDefinitionArn() {
        return this.flowDefinitionArn;
    }

    public final HumanLoopOutput humanLoopOutput() {
        return this.humanLoopOutput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopName());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanLoopOutput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHumanLoopResponse)) {
            return false;
        }
        DescribeHumanLoopResponse other = (DescribeHumanLoopResponse)((Object)obj);
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.failureCode(), other.failureCode()) && Objects.equals(this.humanLoopStatusAsString(), other.humanLoopStatusAsString()) && Objects.equals(this.humanLoopName(), other.humanLoopName()) && Objects.equals(this.humanLoopArn(), other.humanLoopArn()) && Objects.equals(this.flowDefinitionArn(), other.flowDefinitionArn()) && Objects.equals(this.humanLoopOutput(), other.humanLoopOutput());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeHumanLoopResponse").add("CreationTime", (Object)this.creationTime()).add("FailureReason", (Object)this.failureReason()).add("FailureCode", (Object)this.failureCode()).add("HumanLoopStatus", (Object)this.humanLoopStatusAsString()).add("HumanLoopName", (Object)this.humanLoopName()).add("HumanLoopArn", (Object)this.humanLoopArn()).add("FlowDefinitionArn", (Object)this.flowDefinitionArn()).add("HumanLoopOutput", (Object)this.humanLoopOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "FailureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCode()));
            }
            case "HumanLoopStatus": {
                return Optional.ofNullable(clazz.cast(this.humanLoopStatusAsString()));
            }
            case "HumanLoopName": {
                return Optional.ofNullable(clazz.cast(this.humanLoopName()));
            }
            case "HumanLoopArn": {
                return Optional.ofNullable(clazz.cast(this.humanLoopArn()));
            }
            case "FlowDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.flowDefinitionArn()));
            }
            case "HumanLoopOutput": {
                return Optional.ofNullable(clazz.cast(this.humanLoopOutput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("FailureCode", FAILURE_CODE_FIELD);
        map.put("HumanLoopStatus", HUMAN_LOOP_STATUS_FIELD);
        map.put("HumanLoopName", HUMAN_LOOP_NAME_FIELD);
        map.put("HumanLoopArn", HUMAN_LOOP_ARN_FIELD);
        map.put("FlowDefinitionArn", FLOW_DEFINITION_ARN_FIELD);
        map.put("HumanLoopOutput", HUMAN_LOOP_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHumanLoopResponse, T> g) {
        return obj -> g.apply((DescribeHumanLoopResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerA2IRuntimeResponse.BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String failureReason;
        private String failureCode;
        private String humanLoopStatus;
        private String humanLoopName;
        private String humanLoopArn;
        private String flowDefinitionArn;
        private HumanLoopOutput humanLoopOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHumanLoopResponse model) {
            super(model);
            this.creationTime(model.creationTime);
            this.failureReason(model.failureReason);
            this.failureCode(model.failureCode);
            this.humanLoopStatus(model.humanLoopStatus);
            this.humanLoopName(model.humanLoopName);
            this.humanLoopArn(model.humanLoopArn);
            this.flowDefinitionArn(model.flowDefinitionArn);
            this.humanLoopOutput(model.humanLoopOutput);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getHumanLoopStatus() {
            return this.humanLoopStatus;
        }

        public final void setHumanLoopStatus(String humanLoopStatus) {
            this.humanLoopStatus = humanLoopStatus;
        }

        @Override
        public final Builder humanLoopStatus(String humanLoopStatus) {
            this.humanLoopStatus = humanLoopStatus;
            return this;
        }

        @Override
        public final Builder humanLoopStatus(HumanLoopStatus humanLoopStatus) {
            this.humanLoopStatus(humanLoopStatus == null ? null : humanLoopStatus.toString());
            return this;
        }

        public final String getHumanLoopName() {
            return this.humanLoopName;
        }

        public final void setHumanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
        }

        @Override
        public final Builder humanLoopName(String humanLoopName) {
            this.humanLoopName = humanLoopName;
            return this;
        }

        public final String getHumanLoopArn() {
            return this.humanLoopArn;
        }

        public final void setHumanLoopArn(String humanLoopArn) {
            this.humanLoopArn = humanLoopArn;
        }

        @Override
        public final Builder humanLoopArn(String humanLoopArn) {
            this.humanLoopArn = humanLoopArn;
            return this;
        }

        public final String getFlowDefinitionArn() {
            return this.flowDefinitionArn;
        }

        public final void setFlowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
        }

        @Override
        public final Builder flowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
            return this;
        }

        public final HumanLoopOutput.Builder getHumanLoopOutput() {
            return this.humanLoopOutput != null ? this.humanLoopOutput.toBuilder() : null;
        }

        public final void setHumanLoopOutput(HumanLoopOutput.BuilderImpl humanLoopOutput) {
            this.humanLoopOutput = humanLoopOutput != null ? humanLoopOutput.build() : null;
        }

        @Override
        public final Builder humanLoopOutput(HumanLoopOutput humanLoopOutput) {
            this.humanLoopOutput = humanLoopOutput;
            return this;
        }

        @Override
        public DescribeHumanLoopResponse build() {
            return new DescribeHumanLoopResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerA2IRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHumanLoopResponse> {
        public Builder creationTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder failureCode(String var1);

        public Builder humanLoopStatus(String var1);

        public Builder humanLoopStatus(HumanLoopStatus var1);

        public Builder humanLoopName(String var1);

        public Builder humanLoopArn(String var1);

        public Builder flowDefinitionArn(String var1);

        public Builder humanLoopOutput(HumanLoopOutput var1);

        default public Builder humanLoopOutput(Consumer<HumanLoopOutput.Builder> humanLoopOutput) {
            return this.humanLoopOutput((HumanLoopOutput)((HumanLoopOutput.Builder)HumanLoopOutput.builder().applyMutation(humanLoopOutput)).build());
        }
    }
}

