/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakergeospatial.model.EarthObservationJobExportStatus;
import software.amazon.awssdk.services.sagemakergeospatial.model.OutputConfigInput;
import software.amazon.awssdk.services.sagemakergeospatial.model.SageMakerGeospatialResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportEarthObservationJobResponse
extends SageMakerGeospatialResponse
implements ToCopyableBuilder<Builder, ExportEarthObservationJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ExportEarthObservationJobResponse.getter(ExportEarthObservationJobResponse::arn)).setter(ExportEarthObservationJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ExportEarthObservationJobResponse.getter(ExportEarthObservationJobResponse::creationTime)).setter(ExportEarthObservationJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(ExportEarthObservationJobResponse.getter(ExportEarthObservationJobResponse::executionRoleArn)).setter(ExportEarthObservationJobResponse.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<Boolean> EXPORT_SOURCE_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExportSourceImages").getter(ExportEarthObservationJobResponse.getter(ExportEarthObservationJobResponse::exportSourceImages)).setter(ExportEarthObservationJobResponse.setter(Builder::exportSourceImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportSourceImages").build()}).build();
    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportStatus").getter(ExportEarthObservationJobResponse.getter(ExportEarthObservationJobResponse::exportStatusAsString)).setter(ExportEarthObservationJobResponse.setter(Builder::exportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportStatus").build()}).build();
    private static final SdkField<OutputConfigInput> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(ExportEarthObservationJobResponse.getter(ExportEarthObservationJobResponse::outputConfig)).setter(ExportEarthObservationJobResponse.setter(Builder::outputConfig)).constructor(OutputConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIME_FIELD, EXECUTION_ROLE_ARN_FIELD, EXPORT_SOURCE_IMAGES_FIELD, EXPORT_STATUS_FIELD, OUTPUT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportEarthObservationJobResponse.memberNameToFieldInitializer();
    private final String arn;
    private final Instant creationTime;
    private final String executionRoleArn;
    private final Boolean exportSourceImages;
    private final String exportStatus;
    private final OutputConfigInput outputConfig;

    private ExportEarthObservationJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.executionRoleArn = builder.executionRoleArn;
        this.exportSourceImages = builder.exportSourceImages;
        this.exportStatus = builder.exportStatus;
        this.outputConfig = builder.outputConfig;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final Boolean exportSourceImages() {
        return this.exportSourceImages;
    }

    public final EarthObservationJobExportStatus exportStatus() {
        return EarthObservationJobExportStatus.fromValue(this.exportStatus);
    }

    public final String exportStatusAsString() {
        return this.exportStatus;
    }

    public final OutputConfigInput outputConfig() {
        return this.outputConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportSourceImages());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportEarthObservationJobResponse)) {
            return false;
        }
        ExportEarthObservationJobResponse other = (ExportEarthObservationJobResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.exportSourceImages(), other.exportSourceImages()) && Objects.equals(this.exportStatusAsString(), other.exportStatusAsString()) && Objects.equals(this.outputConfig(), other.outputConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ExportEarthObservationJobResponse").add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("ExportSourceImages", (Object)this.exportSourceImages()).add("ExportStatus", (Object)this.exportStatusAsString()).add("OutputConfig", (Object)this.outputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "ExportSourceImages": {
                return Optional.ofNullable(clazz.cast(this.exportSourceImages()));
            }
            case "ExportStatus": {
                return Optional.ofNullable(clazz.cast(this.exportStatusAsString()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("ExportSourceImages", EXPORT_SOURCE_IMAGES_FIELD);
        map.put("ExportStatus", EXPORT_STATUS_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportEarthObservationJobResponse, T> g) {
        return obj -> g.apply((ExportEarthObservationJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerGeospatialResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationTime;
        private String executionRoleArn;
        private Boolean exportSourceImages;
        private String exportStatus;
        private OutputConfigInput outputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportEarthObservationJobResponse model) {
            super(model);
            this.arn(model.arn);
            this.creationTime(model.creationTime);
            this.executionRoleArn(model.executionRoleArn);
            this.exportSourceImages(model.exportSourceImages);
            this.exportStatus(model.exportStatus);
            this.outputConfig(model.outputConfig);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final Boolean getExportSourceImages() {
            return this.exportSourceImages;
        }

        public final void setExportSourceImages(Boolean exportSourceImages) {
            this.exportSourceImages = exportSourceImages;
        }

        @Override
        public final Builder exportSourceImages(Boolean exportSourceImages) {
            this.exportSourceImages = exportSourceImages;
            return this;
        }

        public final String getExportStatus() {
            return this.exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(EarthObservationJobExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final OutputConfigInput.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfigInput.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfigInput outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        @Override
        public ExportEarthObservationJobResponse build() {
            return new ExportEarthObservationJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerGeospatialResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportEarthObservationJobResponse> {
        public Builder arn(String var1);

        public Builder creationTime(Instant var1);

        public Builder executionRoleArn(String var1);

        public Builder exportSourceImages(Boolean var1);

        public Builder exportStatus(String var1);

        public Builder exportStatus(EarthObservationJobExportStatus var1);

        public Builder outputConfig(OutputConfigInput var1);

        default public Builder outputConfig(Consumer<OutputConfigInput.Builder> outputConfig) {
            return this.outputConfig((OutputConfigInput)((OutputConfigInput.Builder)OutputConfigInput.builder().applyMutation(outputConfig)).build());
        }
    }
}

