/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakergeospatial.model.EarthObservationJobListCopier;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobOutputConfig;
import software.amazon.awssdk.services.sagemakergeospatial.model.SageMakerGeospatialResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEarthObservationJobsResponse
extends SageMakerGeospatialResponse
implements ToCopyableBuilder<Builder, ListEarthObservationJobsResponse> {
    private static final SdkField<List<ListEarthObservationJobOutputConfig>> EARTH_OBSERVATION_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EarthObservationJobSummaries").getter(ListEarthObservationJobsResponse.getter(ListEarthObservationJobsResponse::earthObservationJobSummaries)).setter(ListEarthObservationJobsResponse.setter(Builder::earthObservationJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EarthObservationJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListEarthObservationJobOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEarthObservationJobsResponse.getter(ListEarthObservationJobsResponse::nextToken)).setter(ListEarthObservationJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EARTH_OBSERVATION_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEarthObservationJobsResponse.memberNameToFieldInitializer();
    private final List<ListEarthObservationJobOutputConfig> earthObservationJobSummaries;
    private final String nextToken;

    private ListEarthObservationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.earthObservationJobSummaries = builder.earthObservationJobSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEarthObservationJobSummaries() {
        return this.earthObservationJobSummaries != null && !(this.earthObservationJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<ListEarthObservationJobOutputConfig> earthObservationJobSummaries() {
        return this.earthObservationJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEarthObservationJobSummaries() ? this.earthObservationJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEarthObservationJobsResponse)) {
            return false;
        }
        ListEarthObservationJobsResponse other = (ListEarthObservationJobsResponse)((Object)obj);
        return this.hasEarthObservationJobSummaries() == other.hasEarthObservationJobSummaries() && Objects.equals(this.earthObservationJobSummaries(), other.earthObservationJobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEarthObservationJobsResponse").add("EarthObservationJobSummaries", this.hasEarthObservationJobSummaries() ? this.earthObservationJobSummaries() : null).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EarthObservationJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.earthObservationJobSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EarthObservationJobSummaries", EARTH_OBSERVATION_JOB_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEarthObservationJobsResponse, T> g) {
        return obj -> g.apply((ListEarthObservationJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerGeospatialResponse.BuilderImpl
    implements Builder {
        private List<ListEarthObservationJobOutputConfig> earthObservationJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEarthObservationJobsResponse model) {
            super(model);
            this.earthObservationJobSummaries(model.earthObservationJobSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ListEarthObservationJobOutputConfig.Builder> getEarthObservationJobSummaries() {
            List<ListEarthObservationJobOutputConfig.Builder> result = EarthObservationJobListCopier.copyToBuilder(this.earthObservationJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEarthObservationJobSummaries(Collection<ListEarthObservationJobOutputConfig.BuilderImpl> earthObservationJobSummaries) {
            this.earthObservationJobSummaries = EarthObservationJobListCopier.copyFromBuilder(earthObservationJobSummaries);
        }

        @Override
        public final Builder earthObservationJobSummaries(Collection<ListEarthObservationJobOutputConfig> earthObservationJobSummaries) {
            this.earthObservationJobSummaries = EarthObservationJobListCopier.copy(earthObservationJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder earthObservationJobSummaries(ListEarthObservationJobOutputConfig ... earthObservationJobSummaries) {
            this.earthObservationJobSummaries(Arrays.asList(earthObservationJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder earthObservationJobSummaries(Consumer<ListEarthObservationJobOutputConfig.Builder> ... earthObservationJobSummaries) {
            this.earthObservationJobSummaries(Stream.of(earthObservationJobSummaries).map(c -> (ListEarthObservationJobOutputConfig)((ListEarthObservationJobOutputConfig.Builder)ListEarthObservationJobOutputConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEarthObservationJobsResponse build() {
            return new ListEarthObservationJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerGeospatialResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEarthObservationJobsResponse> {
        public Builder earthObservationJobSummaries(Collection<ListEarthObservationJobOutputConfig> var1);

        public Builder earthObservationJobSummaries(ListEarthObservationJobOutputConfig ... var1);

        public Builder earthObservationJobSummaries(Consumer<ListEarthObservationJobOutputConfig.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

