/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakergeospatial.model.AreaOfInterest;
import software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilters;
import software.amazon.awssdk.services.sagemakergeospatial.model.TimeRangeFilterInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RasterDataCollectionQueryInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RasterDataCollectionQueryInput> {
    private static final SdkField<AreaOfInterest> AREA_OF_INTEREST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AreaOfInterest").getter(RasterDataCollectionQueryInput.getter(RasterDataCollectionQueryInput::areaOfInterest)).setter(RasterDataCollectionQueryInput.setter(Builder::areaOfInterest)).constructor(AreaOfInterest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AreaOfInterest").build()}).build();
    private static final SdkField<PropertyFilters> PROPERTY_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PropertyFilters").getter(RasterDataCollectionQueryInput.getter(RasterDataCollectionQueryInput::propertyFilters)).setter(RasterDataCollectionQueryInput.setter(Builder::propertyFilters)).constructor(PropertyFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyFilters").build()}).build();
    private static final SdkField<String> RASTER_DATA_COLLECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RasterDataCollectionArn").getter(RasterDataCollectionQueryInput.getter(RasterDataCollectionQueryInput::rasterDataCollectionArn)).setter(RasterDataCollectionQueryInput.setter(Builder::rasterDataCollectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RasterDataCollectionArn").build()}).build();
    private static final SdkField<TimeRangeFilterInput> TIME_RANGE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeRangeFilter").getter(RasterDataCollectionQueryInput.getter(RasterDataCollectionQueryInput::timeRangeFilter)).setter(RasterDataCollectionQueryInput.setter(Builder::timeRangeFilter)).constructor(TimeRangeFilterInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AREA_OF_INTEREST_FIELD, PROPERTY_FILTERS_FIELD, RASTER_DATA_COLLECTION_ARN_FIELD, TIME_RANGE_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RasterDataCollectionQueryInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AreaOfInterest areaOfInterest;
    private final PropertyFilters propertyFilters;
    private final String rasterDataCollectionArn;
    private final TimeRangeFilterInput timeRangeFilter;

    private RasterDataCollectionQueryInput(BuilderImpl builder) {
        this.areaOfInterest = builder.areaOfInterest;
        this.propertyFilters = builder.propertyFilters;
        this.rasterDataCollectionArn = builder.rasterDataCollectionArn;
        this.timeRangeFilter = builder.timeRangeFilter;
    }

    public final AreaOfInterest areaOfInterest() {
        return this.areaOfInterest;
    }

    public final PropertyFilters propertyFilters() {
        return this.propertyFilters;
    }

    public final String rasterDataCollectionArn() {
        return this.rasterDataCollectionArn;
    }

    public final TimeRangeFilterInput timeRangeFilter() {
        return this.timeRangeFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.areaOfInterest());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.rasterDataCollectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRangeFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RasterDataCollectionQueryInput)) {
            return false;
        }
        RasterDataCollectionQueryInput other = (RasterDataCollectionQueryInput)obj;
        return Objects.equals(this.areaOfInterest(), other.areaOfInterest()) && Objects.equals(this.propertyFilters(), other.propertyFilters()) && Objects.equals(this.rasterDataCollectionArn(), other.rasterDataCollectionArn()) && Objects.equals(this.timeRangeFilter(), other.timeRangeFilter());
    }

    public final String toString() {
        return ToString.builder((String)"RasterDataCollectionQueryInput").add("AreaOfInterest", (Object)this.areaOfInterest()).add("PropertyFilters", (Object)this.propertyFilters()).add("RasterDataCollectionArn", (Object)this.rasterDataCollectionArn()).add("TimeRangeFilter", (Object)(this.timeRangeFilter() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AreaOfInterest": {
                return Optional.ofNullable(clazz.cast(this.areaOfInterest()));
            }
            case "PropertyFilters": {
                return Optional.ofNullable(clazz.cast(this.propertyFilters()));
            }
            case "RasterDataCollectionArn": {
                return Optional.ofNullable(clazz.cast(this.rasterDataCollectionArn()));
            }
            case "TimeRangeFilter": {
                return Optional.ofNullable(clazz.cast(this.timeRangeFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AreaOfInterest", AREA_OF_INTEREST_FIELD);
        map.put("PropertyFilters", PROPERTY_FILTERS_FIELD);
        map.put("RasterDataCollectionArn", RASTER_DATA_COLLECTION_ARN_FIELD);
        map.put("TimeRangeFilter", TIME_RANGE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RasterDataCollectionQueryInput, T> g) {
        return obj -> g.apply((RasterDataCollectionQueryInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AreaOfInterest areaOfInterest;
        private PropertyFilters propertyFilters;
        private String rasterDataCollectionArn;
        private TimeRangeFilterInput timeRangeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(RasterDataCollectionQueryInput model) {
            this.areaOfInterest(model.areaOfInterest);
            this.propertyFilters(model.propertyFilters);
            this.rasterDataCollectionArn(model.rasterDataCollectionArn);
            this.timeRangeFilter(model.timeRangeFilter);
        }

        public final AreaOfInterest.Builder getAreaOfInterest() {
            return this.areaOfInterest != null ? this.areaOfInterest.toBuilder() : null;
        }

        public final void setAreaOfInterest(AreaOfInterest.BuilderImpl areaOfInterest) {
            this.areaOfInterest = areaOfInterest != null ? areaOfInterest.build() : null;
        }

        @Override
        public final Builder areaOfInterest(AreaOfInterest areaOfInterest) {
            this.areaOfInterest = areaOfInterest;
            return this;
        }

        public final PropertyFilters.Builder getPropertyFilters() {
            return this.propertyFilters != null ? this.propertyFilters.toBuilder() : null;
        }

        public final void setPropertyFilters(PropertyFilters.BuilderImpl propertyFilters) {
            this.propertyFilters = propertyFilters != null ? propertyFilters.build() : null;
        }

        @Override
        public final Builder propertyFilters(PropertyFilters propertyFilters) {
            this.propertyFilters = propertyFilters;
            return this;
        }

        public final String getRasterDataCollectionArn() {
            return this.rasterDataCollectionArn;
        }

        public final void setRasterDataCollectionArn(String rasterDataCollectionArn) {
            this.rasterDataCollectionArn = rasterDataCollectionArn;
        }

        @Override
        public final Builder rasterDataCollectionArn(String rasterDataCollectionArn) {
            this.rasterDataCollectionArn = rasterDataCollectionArn;
            return this;
        }

        public final TimeRangeFilterInput.Builder getTimeRangeFilter() {
            return this.timeRangeFilter != null ? this.timeRangeFilter.toBuilder() : null;
        }

        public final void setTimeRangeFilter(TimeRangeFilterInput.BuilderImpl timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter != null ? timeRangeFilter.build() : null;
        }

        @Override
        public final Builder timeRangeFilter(TimeRangeFilterInput timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter;
            return this;
        }

        public RasterDataCollectionQueryInput build() {
            return new RasterDataCollectionQueryInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RasterDataCollectionQueryInput> {
        public Builder areaOfInterest(AreaOfInterest var1);

        default public Builder areaOfInterest(Consumer<AreaOfInterest.Builder> areaOfInterest) {
            return this.areaOfInterest((AreaOfInterest)((AreaOfInterest.Builder)AreaOfInterest.builder().applyMutation(areaOfInterest)).build());
        }

        public Builder propertyFilters(PropertyFilters var1);

        default public Builder propertyFilters(Consumer<PropertyFilters.Builder> propertyFilters) {
            return this.propertyFilters((PropertyFilters)((PropertyFilters.Builder)PropertyFilters.builder().applyMutation(propertyFilters)).build());
        }

        public Builder rasterDataCollectionArn(String var1);

        public Builder timeRangeFilter(TimeRangeFilterInput var1);

        default public Builder timeRangeFilter(Consumer<TimeRangeFilterInput.Builder> timeRangeFilter) {
            return this.timeRangeFilter((TimeRangeFilterInput)((TimeRangeFilterInput.Builder)TimeRangeFilterInput.builder().applyMutation(timeRangeFilter)).build());
        }
    }
}

