/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakergeospatial.model.GroupBy;
import software.amazon.awssdk.services.sagemakergeospatial.model.StringListInputCopier;
import software.amazon.awssdk.services.sagemakergeospatial.model.TemporalStatistics;
import software.amazon.awssdk.services.sagemakergeospatial.model.TemporalStatisticsListInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemporalStatisticsConfigInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemporalStatisticsConfigInput> {
    private static final SdkField<String> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupBy").getter(TemporalStatisticsConfigInput.getter(TemporalStatisticsConfigInput::groupByAsString)).setter(TemporalStatisticsConfigInput.setter(Builder::groupBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build()}).build();
    private static final SdkField<List<String>> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Statistics").getter(TemporalStatisticsConfigInput.getter(TemporalStatisticsConfigInput::statisticsAsStrings)).setter(TemporalStatisticsConfigInput.setter(Builder::statisticsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TARGET_BANDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetBands").getter(TemporalStatisticsConfigInput.getter(TemporalStatisticsConfigInput::targetBands)).setter(TemporalStatisticsConfigInput.setter(Builder::targetBands)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetBands").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_FIELD, STATISTICS_FIELD, TARGET_BANDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TemporalStatisticsConfigInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String groupBy;
    private final List<String> statistics;
    private final List<String> targetBands;

    private TemporalStatisticsConfigInput(BuilderImpl builder) {
        this.groupBy = builder.groupBy;
        this.statistics = builder.statistics;
        this.targetBands = builder.targetBands;
    }

    public final GroupBy groupBy() {
        return GroupBy.fromValue(this.groupBy);
    }

    public final String groupByAsString() {
        return this.groupBy;
    }

    public final List<TemporalStatistics> statistics() {
        return TemporalStatisticsListInputCopier.copyStringToEnum(this.statistics);
    }

    public final boolean hasStatistics() {
        return this.statistics != null && !(this.statistics instanceof SdkAutoConstructList);
    }

    public final List<String> statisticsAsStrings() {
        return this.statistics;
    }

    public final boolean hasTargetBands() {
        return this.targetBands != null && !(this.targetBands instanceof SdkAutoConstructList);
    }

    public final List<String> targetBands() {
        return this.targetBands;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatistics() ? this.statisticsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetBands() ? this.targetBands() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemporalStatisticsConfigInput)) {
            return false;
        }
        TemporalStatisticsConfigInput other = (TemporalStatisticsConfigInput)obj;
        return Objects.equals(this.groupByAsString(), other.groupByAsString()) && this.hasStatistics() == other.hasStatistics() && Objects.equals(this.statisticsAsStrings(), other.statisticsAsStrings()) && this.hasTargetBands() == other.hasTargetBands() && Objects.equals(this.targetBands(), other.targetBands());
    }

    public final String toString() {
        return ToString.builder((String)"TemporalStatisticsConfigInput").add("GroupBy", (Object)this.groupByAsString()).add("Statistics", this.hasStatistics() ? this.statisticsAsStrings() : null).add("TargetBands", this.hasTargetBands() ? this.targetBands() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupBy": {
                return Optional.ofNullable(clazz.cast(this.groupByAsString()));
            }
            case "Statistics": {
                return Optional.ofNullable(clazz.cast(this.statisticsAsStrings()));
            }
            case "TargetBands": {
                return Optional.ofNullable(clazz.cast(this.targetBands()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GroupBy", GROUP_BY_FIELD);
        map.put("Statistics", STATISTICS_FIELD);
        map.put("TargetBands", TARGET_BANDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemporalStatisticsConfigInput, T> g) {
        return obj -> g.apply((TemporalStatisticsConfigInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupBy;
        private List<String> statistics = DefaultSdkAutoConstructList.getInstance();
        private List<String> targetBands = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TemporalStatisticsConfigInput model) {
            this.groupBy(model.groupBy);
            this.statisticsWithStrings(model.statistics);
            this.targetBands(model.targetBands);
        }

        public final String getGroupBy() {
            return this.groupBy;
        }

        public final void setGroupBy(String groupBy) {
            this.groupBy = groupBy;
        }

        @Override
        public final Builder groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        @Override
        public final Builder groupBy(GroupBy groupBy) {
            this.groupBy(groupBy == null ? null : groupBy.toString());
            return this;
        }

        public final Collection<String> getStatistics() {
            if (this.statistics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statistics;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = TemporalStatisticsListInputCopier.copy(statistics);
        }

        @Override
        public final Builder statisticsWithStrings(Collection<String> statistics) {
            this.statistics = TemporalStatisticsListInputCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsWithStrings(String ... statistics) {
            this.statisticsWithStrings(Arrays.asList(statistics));
            return this;
        }

        @Override
        public final Builder statistics(Collection<TemporalStatistics> statistics) {
            this.statistics = TemporalStatisticsListInputCopier.copyEnumToString(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(TemporalStatistics ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        public final Collection<String> getTargetBands() {
            if (this.targetBands instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetBands;
        }

        public final void setTargetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
        }

        @Override
        public final Builder targetBands(Collection<String> targetBands) {
            this.targetBands = StringListInputCopier.copy(targetBands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetBands(String ... targetBands) {
            this.targetBands(Arrays.asList(targetBands));
            return this;
        }

        public TemporalStatisticsConfigInput build() {
            return new TemporalStatisticsConfigInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemporalStatisticsConfigInput> {
        public Builder groupBy(String var1);

        public Builder groupBy(GroupBy var1);

        public Builder statisticsWithStrings(Collection<String> var1);

        public Builder statisticsWithStrings(String ... var1);

        public Builder statistics(Collection<TemporalStatistics> var1);

        public Builder statistics(TemporalStatistics ... var1);

        public Builder targetBands(Collection<String> var1);

        public Builder targetBands(String ... var1);
    }
}

