/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCodeBindingResponse extends SchemasResponse implements
        ToCopyableBuilder<DescribeCodeBindingResponse.Builder, DescribeCodeBindingResponse> {
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate")
            .getter(getter(DescribeCodeBindingResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModified")
            .getter(getter(DescribeCodeBindingResponse::lastModified))
            .setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaVersion").getter(getter(DescribeCodeBindingResponse::schemaVersion))
            .setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersion").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeCodeBindingResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_FIELD,
            LAST_MODIFIED_FIELD, SCHEMA_VERSION_FIELD, STATUS_FIELD));

    private final Instant creationDate;

    private final Instant lastModified;

    private final String schemaVersion;

    private final String status;

    private DescribeCodeBindingResponse(BuilderImpl builder) {
        super(builder);
        this.creationDate = builder.creationDate;
        this.lastModified = builder.lastModified;
        this.schemaVersion = builder.schemaVersion;
        this.status = builder.status;
    }

    /**
     * <p>
     * The time and date that the code binding was created.
     * </p>
     * 
     * @return The time and date that the code binding was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time that code bindings were modified.
     * </p>
     * 
     * @return The date and time that code bindings were modified.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The version number of the schema.
     * </p>
     * 
     * @return The version number of the schema.
     */
    public final String schemaVersion() {
        return schemaVersion;
    }

    /**
     * <p>
     * The current status of code binding generation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CodeGenerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of code binding generation.
     * @see CodeGenerationStatus
     */
    public final CodeGenerationStatus status() {
        return CodeGenerationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of code binding generation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CodeGenerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of code binding generation.
     * @see CodeGenerationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCodeBindingResponse)) {
            return false;
        }
        DescribeCodeBindingResponse other = (DescribeCodeBindingResponse) obj;
        return Objects.equals(creationDate(), other.creationDate()) && Objects.equals(lastModified(), other.lastModified())
                && Objects.equals(schemaVersion(), other.schemaVersion())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCodeBindingResponse").add("CreationDate", creationDate())
                .add("LastModified", lastModified()).add("SchemaVersion", schemaVersion()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "SchemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCodeBindingResponse, T> g) {
        return obj -> g.apply((DescribeCodeBindingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchemasResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCodeBindingResponse> {
        /**
         * <p>
         * The time and date that the code binding was created.
         * </p>
         * 
         * @param creationDate
         *        The time and date that the code binding was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time that code bindings were modified.
         * </p>
         * 
         * @param lastModified
         *        The date and time that code bindings were modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * The version number of the schema.
         * </p>
         * 
         * @param schemaVersion
         *        The version number of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * <p>
         * The current status of code binding generation.
         * </p>
         * 
         * @param status
         *        The current status of code binding generation.
         * @see CodeGenerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeGenerationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of code binding generation.
         * </p>
         * 
         * @param status
         *        The current status of code binding generation.
         * @see CodeGenerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeGenerationStatus
         */
        Builder status(CodeGenerationStatus status);
    }

    static final class BuilderImpl extends SchemasResponse.BuilderImpl implements Builder {
        private Instant creationDate;

        private Instant lastModified;

        private String schemaVersion;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCodeBindingResponse model) {
            super(model);
            creationDate(model.creationDate);
            lastModified(model.lastModified);
            schemaVersion(model.schemaVersion);
            status(model.status);
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CodeGenerationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DescribeCodeBindingResponse build() {
            return new DescribeCodeBindingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
