/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * One or more actions to update finding fields if a finding matches the defined criteria of the rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomationRulesAction implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomationRulesAction.Builder, AutomationRulesAction> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AutomationRulesAction::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<AutomationRulesFindingFieldsUpdate> FINDING_FIELDS_UPDATE_FIELD = SdkField
            .<AutomationRulesFindingFieldsUpdate> builder(MarshallingType.SDK_POJO).memberName("FindingFieldsUpdate")
            .getter(getter(AutomationRulesAction::findingFieldsUpdate)).setter(setter(Builder::findingFieldsUpdate))
            .constructor(AutomationRulesFindingFieldsUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingFieldsUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            FINDING_FIELDS_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final AutomationRulesFindingFieldsUpdate findingFieldsUpdate;

    private AutomationRulesAction(BuilderImpl builder) {
        this.type = builder.type;
        this.findingFieldsUpdate = builder.findingFieldsUpdate;
    }

    /**
     * <p>
     * Specifies that the rule action should update the <code>Types</code> finding field. The <code>Types</code> finding
     * field classifies findings in the format of namespace/category/classifier. For more information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html"
     * >Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AutomationRulesActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies that the rule action should update the <code>Types</code> finding field. The <code>Types</code>
     *         finding field classifies findings in the format of namespace/category/classifier. For more information,
     *         see <a href=
     *         "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html"
     *         >Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>.
     * @see AutomationRulesActionType
     */
    public final AutomationRulesActionType type() {
        return AutomationRulesActionType.fromValue(type);
    }

    /**
     * <p>
     * Specifies that the rule action should update the <code>Types</code> finding field. The <code>Types</code> finding
     * field classifies findings in the format of namespace/category/classifier. For more information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html"
     * >Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AutomationRulesActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies that the rule action should update the <code>Types</code> finding field. The <code>Types</code>
     *         finding field classifies findings in the format of namespace/category/classifier. For more information,
     *         see <a href=
     *         "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html"
     *         >Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>.
     * @see AutomationRulesActionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Specifies that the automation rule action is an update to a finding field.
     * </p>
     * 
     * @return Specifies that the automation rule action is an update to a finding field.
     */
    public final AutomationRulesFindingFieldsUpdate findingFieldsUpdate() {
        return findingFieldsUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(findingFieldsUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationRulesAction)) {
            return false;
        }
        AutomationRulesAction other = (AutomationRulesAction) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(findingFieldsUpdate(), other.findingFieldsUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomationRulesAction").add("Type", typeAsString())
                .add("FindingFieldsUpdate", findingFieldsUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "FindingFieldsUpdate":
            return Optional.ofNullable(clazz.cast(findingFieldsUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomationRulesAction, T> g) {
        return obj -> g.apply((AutomationRulesAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomationRulesAction> {
        /**
         * <p>
         * Specifies that the rule action should update the <code>Types</code> finding field. The <code>Types</code>
         * finding field classifies findings in the format of namespace/category/classifier. For more information, see
         * <a href=
         * "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html"
         * >Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>.
         * </p>
         * 
         * @param type
         *        Specifies that the rule action should update the <code>Types</code> finding field. The
         *        <code>Types</code> finding field classifies findings in the format of namespace/category/classifier.
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html"
         *        >Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>.
         * @see AutomationRulesActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationRulesActionType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies that the rule action should update the <code>Types</code> finding field. The <code>Types</code>
         * finding field classifies findings in the format of namespace/category/classifier. For more information, see
         * <a href=
         * "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html"
         * >Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>.
         * </p>
         * 
         * @param type
         *        Specifies that the rule action should update the <code>Types</code> finding field. The
         *        <code>Types</code> finding field classifies findings in the format of namespace/category/classifier.
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html"
         *        >Types taxonomy for ASFF</a> in the <i>Security Hub User Guide</i>.
         * @see AutomationRulesActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomationRulesActionType
         */
        Builder type(AutomationRulesActionType type);

        /**
         * <p>
         * Specifies that the automation rule action is an update to a finding field.
         * </p>
         * 
         * @param findingFieldsUpdate
         *        Specifies that the automation rule action is an update to a finding field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingFieldsUpdate(AutomationRulesFindingFieldsUpdate findingFieldsUpdate);

        /**
         * <p>
         * Specifies that the automation rule action is an update to a finding field.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomationRulesFindingFieldsUpdate.Builder} avoiding the need to create one manually via
         * {@link AutomationRulesFindingFieldsUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomationRulesFindingFieldsUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #findingFieldsUpdate(AutomationRulesFindingFieldsUpdate)}.
         * 
         * @param findingFieldsUpdate
         *        a consumer that will call methods on {@link AutomationRulesFindingFieldsUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingFieldsUpdate(AutomationRulesFindingFieldsUpdate)
         */
        default Builder findingFieldsUpdate(Consumer<AutomationRulesFindingFieldsUpdate.Builder> findingFieldsUpdate) {
            return findingFieldsUpdate(AutomationRulesFindingFieldsUpdate.builder().applyMutation(findingFieldsUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private AutomationRulesFindingFieldsUpdate findingFieldsUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationRulesAction model) {
            type(model.type);
            findingFieldsUpdate(model.findingFieldsUpdate);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AutomationRulesActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final AutomationRulesFindingFieldsUpdate.Builder getFindingFieldsUpdate() {
            return findingFieldsUpdate != null ? findingFieldsUpdate.toBuilder() : null;
        }

        public final void setFindingFieldsUpdate(AutomationRulesFindingFieldsUpdate.BuilderImpl findingFieldsUpdate) {
            this.findingFieldsUpdate = findingFieldsUpdate != null ? findingFieldsUpdate.build() : null;
        }

        @Override
        public final Builder findingFieldsUpdate(AutomationRulesFindingFieldsUpdate findingFieldsUpdate) {
            this.findingFieldsUpdate = findingFieldsUpdate;
            return this;
        }

        @Override
        public AutomationRulesAction build() {
            return new AutomationRulesAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
