/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Nests a stack as a resource in a top-level template. Nested stacks are stacks created as resources for another stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFormationStackDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudFormationStackDetails.Builder, AwsCloudFormationStackDetails> {
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Capabilities")
            .getter(getter(AwsCloudFormationStackDetails::capabilities))
            .setter(setter(Builder::capabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTime").getter(getter(AwsCloudFormationStackDetails::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsCloudFormationStackDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> DISABLE_ROLLBACK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableRollback").getter(getter(AwsCloudFormationStackDetails::disableRollback))
            .setter(setter(Builder::disableRollback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableRollback").build()).build();

    private static final SdkField<AwsCloudFormationStackDriftInformationDetails> DRIFT_INFORMATION_FIELD = SdkField
            .<AwsCloudFormationStackDriftInformationDetails> builder(MarshallingType.SDK_POJO).memberName("DriftInformation")
            .getter(getter(AwsCloudFormationStackDetails::driftInformation)).setter(setter(Builder::driftInformation))
            .constructor(AwsCloudFormationStackDriftInformationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftInformation").build()).build();

    private static final SdkField<Boolean> ENABLE_TERMINATION_PROTECTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableTerminationProtection")
            .getter(getter(AwsCloudFormationStackDetails::enableTerminationProtection))
            .setter(setter(Builder::enableTerminationProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableTerminationProtection")
                    .build()).build();

    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedTime").getter(getter(AwsCloudFormationStackDetails::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<List<String>> NOTIFICATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotificationArns")
            .getter(getter(AwsCloudFormationStackDetails::notificationArns))
            .setter(setter(Builder::notificationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsCloudFormationStackOutputsDetails>> OUTPUTS_FIELD = SdkField
            .<List<AwsCloudFormationStackOutputsDetails>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(AwsCloudFormationStackDetails::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsCloudFormationStackOutputsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsCloudFormationStackOutputsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(AwsCloudFormationStackDetails::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(AwsCloudFormationStackDetails::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(AwsCloudFormationStackDetails::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> STACK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackStatus").getter(getter(AwsCloudFormationStackDetails::stackStatus))
            .setter(setter(Builder::stackStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackStatus").build()).build();

    private static final SdkField<String> STACK_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackStatusReason").getter(getter(AwsCloudFormationStackDetails::stackStatusReason))
            .setter(setter(Builder::stackStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackStatusReason").build()).build();

    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeoutInMinutes").getter(getter(AwsCloudFormationStackDetails::timeoutInMinutes))
            .setter(setter(Builder::timeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInMinutes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITIES_FIELD,
            CREATION_TIME_FIELD, DESCRIPTION_FIELD, DISABLE_ROLLBACK_FIELD, DRIFT_INFORMATION_FIELD,
            ENABLE_TERMINATION_PROTECTION_FIELD, LAST_UPDATED_TIME_FIELD, NOTIFICATION_ARNS_FIELD, OUTPUTS_FIELD, ROLE_ARN_FIELD,
            STACK_ID_FIELD, STACK_NAME_FIELD, STACK_STATUS_FIELD, STACK_STATUS_REASON_FIELD, TIMEOUT_IN_MINUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> capabilities;

    private final String creationTime;

    private final String description;

    private final Boolean disableRollback;

    private final AwsCloudFormationStackDriftInformationDetails driftInformation;

    private final Boolean enableTerminationProtection;

    private final String lastUpdatedTime;

    private final List<String> notificationArns;

    private final List<AwsCloudFormationStackOutputsDetails> outputs;

    private final String roleArn;

    private final String stackId;

    private final String stackName;

    private final String stackStatus;

    private final String stackStatusReason;

    private final Integer timeoutInMinutes;

    private AwsCloudFormationStackDetails(BuilderImpl builder) {
        this.capabilities = builder.capabilities;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.disableRollback = builder.disableRollback;
        this.driftInformation = builder.driftInformation;
        this.enableTerminationProtection = builder.enableTerminationProtection;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.notificationArns = builder.notificationArns;
        this.outputs = builder.outputs;
        this.roleArn = builder.roleArn;
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.stackStatus = builder.stackStatus;
        this.stackStatusReason = builder.stackStatusReason;
        this.timeoutInMinutes = builder.timeoutInMinutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capabilities allowed in the stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return The capabilities allowed in the stack.
     */
    public final List<String> capabilities() {
        return capabilities;
    }

    /**
     * <p>
     * The time at which the stack was created.
     * </p>
     * 
     * @return The time at which the stack was created.
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A user-defined description associated with the stack.
     * </p>
     * 
     * @return A user-defined description associated with the stack.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Boolean to enable or disable rollback on stack creation failures.
     * </p>
     * 
     * @return Boolean to enable or disable rollback on stack creation failures.
     */
    public final Boolean disableRollback() {
        return disableRollback;
    }

    /**
     * <p>
     * Information about whether a stack's actual configuration differs, or has drifted, from its expected
     * configuration, as defined in the stack template and any values specified as template parameters.
     * </p>
     * 
     * @return Information about whether a stack's actual configuration differs, or has drifted, from its expected
     *         configuration, as defined in the stack template and any values specified as template parameters.
     */
    public final AwsCloudFormationStackDriftInformationDetails driftInformation() {
        return driftInformation;
    }

    /**
     * <p>
     * Whether termination protection is enabled for the stack.
     * </p>
     * 
     * @return Whether termination protection is enabled for the stack.
     */
    public final Boolean enableTerminationProtection() {
        return enableTerminationProtection;
    }

    /**
     * <p>
     * The time the nested stack was last updated. This field will only be returned if the stack has been updated at
     * least once.
     * </p>
     * 
     * @return The time the nested stack was last updated. This field will only be returned if the stack has been
     *         updated at least once.
     */
    public final String lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotificationArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotificationArns() {
        return notificationArns != null && !(notificationArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the Amazon SNS topic to which stack-related events are published.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotificationArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the Amazon SNS topic to which stack-related events are published.
     */
    public final List<String> notificationArns() {
        return notificationArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of output structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return A list of output structures.
     */
    public final List<AwsCloudFormationStackOutputsDetails> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The ARN of an IAM role that's associated with the stack.
     * </p>
     * 
     * @return The ARN of an IAM role that's associated with the stack.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Unique identifier of the stack.
     * </p>
     * 
     * @return Unique identifier of the stack.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The name associated with the stack.
     * </p>
     * 
     * @return The name associated with the stack.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * Current status of the stack.
     * </p>
     * 
     * @return Current status of the stack.
     */
    public final String stackStatus() {
        return stackStatus;
    }

    /**
     * <p>
     * Success or failure message associated with the stack status.
     * </p>
     * 
     * @return Success or failure message associated with the stack status.
     */
    public final String stackStatusReason() {
        return stackStatusReason;
    }

    /**
     * <p>
     * The length of time, in minutes, that CloudFormation waits for the nested stack to reach the
     * <code>CREATE_COMPLETE</code> state.
     * </p>
     * 
     * @return The length of time, in minutes, that CloudFormation waits for the nested stack to reach the
     *         <code>CREATE_COMPLETE</code> state.
     */
    public final Integer timeoutInMinutes() {
        return timeoutInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(disableRollback());
        hashCode = 31 * hashCode + Objects.hashCode(driftInformation());
        hashCode = 31 * hashCode + Objects.hashCode(enableTerminationProtection());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasNotificationArns() ? notificationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(stackStatus());
        hashCode = 31 * hashCode + Objects.hashCode(stackStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFormationStackDetails)) {
            return false;
        }
        AwsCloudFormationStackDetails other = (AwsCloudFormationStackDetails) obj;
        return hasCapabilities() == other.hasCapabilities() && Objects.equals(capabilities(), other.capabilities())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(description(), other.description())
                && Objects.equals(disableRollback(), other.disableRollback())
                && Objects.equals(driftInformation(), other.driftInformation())
                && Objects.equals(enableTerminationProtection(), other.enableTerminationProtection())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && hasNotificationArns() == other.hasNotificationArns()
                && Objects.equals(notificationArns(), other.notificationArns()) && hasOutputs() == other.hasOutputs()
                && Objects.equals(outputs(), other.outputs()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(stackId(), other.stackId()) && Objects.equals(stackName(), other.stackName())
                && Objects.equals(stackStatus(), other.stackStatus())
                && Objects.equals(stackStatusReason(), other.stackStatusReason())
                && Objects.equals(timeoutInMinutes(), other.timeoutInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudFormationStackDetails").add("Capabilities", hasCapabilities() ? capabilities() : null)
                .add("CreationTime", creationTime()).add("Description", description()).add("DisableRollback", disableRollback())
                .add("DriftInformation", driftInformation()).add("EnableTerminationProtection", enableTerminationProtection())
                .add("LastUpdatedTime", lastUpdatedTime())
                .add("NotificationArns", hasNotificationArns() ? notificationArns() : null)
                .add("Outputs", hasOutputs() ? outputs() : null).add("RoleArn", roleArn()).add("StackId", stackId())
                .add("StackName", stackName()).add("StackStatus", stackStatus()).add("StackStatusReason", stackStatusReason())
                .add("TimeoutInMinutes", timeoutInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisableRollback":
            return Optional.ofNullable(clazz.cast(disableRollback()));
        case "DriftInformation":
            return Optional.ofNullable(clazz.cast(driftInformation()));
        case "EnableTerminationProtection":
            return Optional.ofNullable(clazz.cast(enableTerminationProtection()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "NotificationArns":
            return Optional.ofNullable(clazz.cast(notificationArns()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "StackStatus":
            return Optional.ofNullable(clazz.cast(stackStatus()));
        case "StackStatusReason":
            return Optional.ofNullable(clazz.cast(stackStatusReason()));
        case "TimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(timeoutInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFormationStackDetails, T> g) {
        return obj -> g.apply((AwsCloudFormationStackDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFormationStackDetails> {
        /**
         * <p>
         * The capabilities allowed in the stack.
         * </p>
         * 
         * @param capabilities
         *        The capabilities allowed in the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<String> capabilities);

        /**
         * <p>
         * The capabilities allowed in the stack.
         * </p>
         * 
         * @param capabilities
         *        The capabilities allowed in the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(String... capabilities);

        /**
         * <p>
         * The time at which the stack was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the stack was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * A user-defined description associated with the stack.
         * </p>
         * 
         * @param description
         *        A user-defined description associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Boolean to enable or disable rollback on stack creation failures.
         * </p>
         * 
         * @param disableRollback
         *        Boolean to enable or disable rollback on stack creation failures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableRollback(Boolean disableRollback);

        /**
         * <p>
         * Information about whether a stack's actual configuration differs, or has drifted, from its expected
         * configuration, as defined in the stack template and any values specified as template parameters.
         * </p>
         * 
         * @param driftInformation
         *        Information about whether a stack's actual configuration differs, or has drifted, from its expected
         *        configuration, as defined in the stack template and any values specified as template parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driftInformation(AwsCloudFormationStackDriftInformationDetails driftInformation);

        /**
         * <p>
         * Information about whether a stack's actual configuration differs, or has drifted, from its expected
         * configuration, as defined in the stack template and any values specified as template parameters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsCloudFormationStackDriftInformationDetails.Builder} avoiding the need to create one manually via
         * {@link AwsCloudFormationStackDriftInformationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCloudFormationStackDriftInformationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #driftInformation(AwsCloudFormationStackDriftInformationDetails)}.
         * 
         * @param driftInformation
         *        a consumer that will call methods on {@link AwsCloudFormationStackDriftInformationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #driftInformation(AwsCloudFormationStackDriftInformationDetails)
         */
        default Builder driftInformation(Consumer<AwsCloudFormationStackDriftInformationDetails.Builder> driftInformation) {
            return driftInformation(AwsCloudFormationStackDriftInformationDetails.builder().applyMutation(driftInformation)
                    .build());
        }

        /**
         * <p>
         * Whether termination protection is enabled for the stack.
         * </p>
         * 
         * @param enableTerminationProtection
         *        Whether termination protection is enabled for the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableTerminationProtection(Boolean enableTerminationProtection);

        /**
         * <p>
         * The time the nested stack was last updated. This field will only be returned if the stack has been updated at
         * least once.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time the nested stack was last updated. This field will only be returned if the stack has been
         *        updated at least once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(String lastUpdatedTime);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the Amazon SNS topic to which stack-related events are published.
         * </p>
         * 
         * @param notificationArns
         *        The Amazon Resource Names (ARNs) of the Amazon SNS topic to which stack-related events are published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationArns(Collection<String> notificationArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the Amazon SNS topic to which stack-related events are published.
         * </p>
         * 
         * @param notificationArns
         *        The Amazon Resource Names (ARNs) of the Amazon SNS topic to which stack-related events are published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationArns(String... notificationArns);

        /**
         * <p>
         * A list of output structures.
         * </p>
         * 
         * @param outputs
         *        A list of output structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<AwsCloudFormationStackOutputsDetails> outputs);

        /**
         * <p>
         * A list of output structures.
         * </p>
         * 
         * @param outputs
         *        A list of output structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(AwsCloudFormationStackOutputsDetails... outputs);

        /**
         * <p>
         * A list of output structures.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackOutputsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackOutputsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackOutputsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #outputs(List<AwsCloudFormationStackOutputsDetails>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsCloudFormationStackOutputsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<AwsCloudFormationStackOutputsDetails>)
         */
        Builder outputs(Consumer<AwsCloudFormationStackOutputsDetails.Builder>... outputs);

        /**
         * <p>
         * The ARN of an IAM role that's associated with the stack.
         * </p>
         * 
         * @param roleArn
         *        The ARN of an IAM role that's associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Unique identifier of the stack.
         * </p>
         * 
         * @param stackId
         *        Unique identifier of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The name associated with the stack.
         * </p>
         * 
         * @param stackName
         *        The name associated with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * Current status of the stack.
         * </p>
         * 
         * @param stackStatus
         *        Current status of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackStatus(String stackStatus);

        /**
         * <p>
         * Success or failure message associated with the stack status.
         * </p>
         * 
         * @param stackStatusReason
         *        Success or failure message associated with the stack status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackStatusReason(String stackStatusReason);

        /**
         * <p>
         * The length of time, in minutes, that CloudFormation waits for the nested stack to reach the
         * <code>CREATE_COMPLETE</code> state.
         * </p>
         * 
         * @param timeoutInMinutes
         *        The length of time, in minutes, that CloudFormation waits for the nested stack to reach the
         *        <code>CREATE_COMPLETE</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInMinutes(Integer timeoutInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private String creationTime;

        private String description;

        private Boolean disableRollback;

        private AwsCloudFormationStackDriftInformationDetails driftInformation;

        private Boolean enableTerminationProtection;

        private String lastUpdatedTime;

        private List<String> notificationArns = DefaultSdkAutoConstructList.getInstance();

        private List<AwsCloudFormationStackOutputsDetails> outputs = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private String stackId;

        private String stackName;

        private String stackStatus;

        private String stackStatusReason;

        private Integer timeoutInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFormationStackDetails model) {
            capabilities(model.capabilities);
            creationTime(model.creationTime);
            description(model.description);
            disableRollback(model.disableRollback);
            driftInformation(model.driftInformation);
            enableTerminationProtection(model.enableTerminationProtection);
            lastUpdatedTime(model.lastUpdatedTime);
            notificationArns(model.notificationArns);
            outputs(model.outputs);
            roleArn(model.roleArn);
            stackId(model.stackId);
            stackName(model.stackName);
            stackStatus(model.stackStatus);
            stackStatusReason(model.stackStatusReason);
            timeoutInMinutes(model.timeoutInMinutes);
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = NonEmptyStringListCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = NonEmptyStringListCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDisableRollback() {
            return disableRollback;
        }

        public final void setDisableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
        }

        @Override
        public final Builder disableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
            return this;
        }

        public final AwsCloudFormationStackDriftInformationDetails.Builder getDriftInformation() {
            return driftInformation != null ? driftInformation.toBuilder() : null;
        }

        public final void setDriftInformation(AwsCloudFormationStackDriftInformationDetails.BuilderImpl driftInformation) {
            this.driftInformation = driftInformation != null ? driftInformation.build() : null;
        }

        @Override
        public final Builder driftInformation(AwsCloudFormationStackDriftInformationDetails driftInformation) {
            this.driftInformation = driftInformation;
            return this;
        }

        public final Boolean getEnableTerminationProtection() {
            return enableTerminationProtection;
        }

        public final void setEnableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
        }

        @Override
        public final Builder enableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
            return this;
        }

        public final String getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Collection<String> getNotificationArns() {
            if (notificationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return notificationArns;
        }

        public final void setNotificationArns(Collection<String> notificationArns) {
            this.notificationArns = NonEmptyStringListCopier.copy(notificationArns);
        }

        @Override
        public final Builder notificationArns(Collection<String> notificationArns) {
            this.notificationArns = NonEmptyStringListCopier.copy(notificationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationArns(String... notificationArns) {
            notificationArns(Arrays.asList(notificationArns));
            return this;
        }

        public final List<AwsCloudFormationStackOutputsDetails.Builder> getOutputs() {
            List<AwsCloudFormationStackOutputsDetails.Builder> result = AwsCloudFormationStackOutputsListCopier
                    .copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<AwsCloudFormationStackOutputsDetails.BuilderImpl> outputs) {
            this.outputs = AwsCloudFormationStackOutputsListCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<AwsCloudFormationStackOutputsDetails> outputs) {
            this.outputs = AwsCloudFormationStackOutputsListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(AwsCloudFormationStackOutputsDetails... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<AwsCloudFormationStackOutputsDetails.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> AwsCloudFormationStackOutputsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getStackStatus() {
            return stackStatus;
        }

        public final void setStackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
        }

        @Override
        public final Builder stackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
            return this;
        }

        public final String getStackStatusReason() {
            return stackStatusReason;
        }

        public final void setStackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
        }

        @Override
        public final Builder stackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
            return this;
        }

        public final Integer getTimeoutInMinutes() {
            return timeoutInMinutes;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        @Override
        public AwsCloudFormationStackDetails build() {
            return new AwsCloudFormationStackDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
