/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the routing configuration of the endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEventsEndpointRoutingConfigDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEventsEndpointRoutingConfigDetails.Builder, AwsEventsEndpointRoutingConfigDetails> {
    private static final SdkField<AwsEventsEndpointRoutingConfigFailoverConfigDetails> FAILOVER_CONFIG_FIELD = SdkField
            .<AwsEventsEndpointRoutingConfigFailoverConfigDetails> builder(MarshallingType.SDK_POJO).memberName("FailoverConfig")
            .getter(getter(AwsEventsEndpointRoutingConfigDetails::failoverConfig)).setter(setter(Builder::failoverConfig))
            .constructor(AwsEventsEndpointRoutingConfigFailoverConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailoverConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILOVER_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsEventsEndpointRoutingConfigFailoverConfigDetails failoverConfig;

    private AwsEventsEndpointRoutingConfigDetails(BuilderImpl builder) {
        this.failoverConfig = builder.failoverConfig;
    }

    /**
     * <p>
     * The failover configuration for an endpoint. This includes what triggers failover and what happens when it's
     * triggered.
     * </p>
     * 
     * @return The failover configuration for an endpoint. This includes what triggers failover and what happens when
     *         it's triggered.
     */
    public final AwsEventsEndpointRoutingConfigFailoverConfigDetails failoverConfig() {
        return failoverConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failoverConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEventsEndpointRoutingConfigDetails)) {
            return false;
        }
        AwsEventsEndpointRoutingConfigDetails other = (AwsEventsEndpointRoutingConfigDetails) obj;
        return Objects.equals(failoverConfig(), other.failoverConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEventsEndpointRoutingConfigDetails").add("FailoverConfig", failoverConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailoverConfig":
            return Optional.ofNullable(clazz.cast(failoverConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEventsEndpointRoutingConfigDetails, T> g) {
        return obj -> g.apply((AwsEventsEndpointRoutingConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEventsEndpointRoutingConfigDetails> {
        /**
         * <p>
         * The failover configuration for an endpoint. This includes what triggers failover and what happens when it's
         * triggered.
         * </p>
         * 
         * @param failoverConfig
         *        The failover configuration for an endpoint. This includes what triggers failover and what happens when
         *        it's triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failoverConfig(AwsEventsEndpointRoutingConfigFailoverConfigDetails failoverConfig);

        /**
         * <p>
         * The failover configuration for an endpoint. This includes what triggers failover and what happens when it's
         * triggered.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEventsEndpointRoutingConfigFailoverConfigDetails.Builder} avoiding the need to create one manually
         * via {@link AwsEventsEndpointRoutingConfigFailoverConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEventsEndpointRoutingConfigFailoverConfigDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #failoverConfig(AwsEventsEndpointRoutingConfigFailoverConfigDetails)}.
         * 
         * @param failoverConfig
         *        a consumer that will call methods on
         *        {@link AwsEventsEndpointRoutingConfigFailoverConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failoverConfig(AwsEventsEndpointRoutingConfigFailoverConfigDetails)
         */
        default Builder failoverConfig(Consumer<AwsEventsEndpointRoutingConfigFailoverConfigDetails.Builder> failoverConfig) {
            return failoverConfig(AwsEventsEndpointRoutingConfigFailoverConfigDetails.builder().applyMutation(failoverConfig)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsEventsEndpointRoutingConfigFailoverConfigDetails failoverConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEventsEndpointRoutingConfigDetails model) {
            failoverConfig(model.failoverConfig);
        }

        public final AwsEventsEndpointRoutingConfigFailoverConfigDetails.Builder getFailoverConfig() {
            return failoverConfig != null ? failoverConfig.toBuilder() : null;
        }

        public final void setFailoverConfig(AwsEventsEndpointRoutingConfigFailoverConfigDetails.BuilderImpl failoverConfig) {
            this.failoverConfig = failoverConfig != null ? failoverConfig.build() : null;
        }

        @Override
        public final Builder failoverConfig(AwsEventsEndpointRoutingConfigFailoverConfigDetails failoverConfig) {
            this.failoverConfig = failoverConfig;
            return this;
        }

        @Override
        public AwsEventsEndpointRoutingConfigDetails build() {
            return new AwsEventsEndpointRoutingConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
