/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * IP range information for an RDS DB security group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRdsDbSecurityGroupIpRange implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRdsDbSecurityGroupIpRange.Builder, AwsRdsDbSecurityGroupIpRange> {
    private static final SdkField<String> CIDR_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CidrIp")
            .getter(getter(AwsRdsDbSecurityGroupIpRange::cidrIp)).setter(setter(Builder::cidrIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIp").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsRdsDbSecurityGroupIpRange::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_IP_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cidrIp;

    private final String status;

    private AwsRdsDbSecurityGroupIpRange(BuilderImpl builder) {
        this.cidrIp = builder.cidrIp;
        this.status = builder.status;
    }

    /**
     * <p>
     * Specifies the IP range.
     * </p>
     * 
     * @return Specifies the IP range.
     */
    public final String cidrIp() {
        return cidrIp;
    }

    /**
     * <p>
     * Specifies the status of the IP range.
     * </p>
     * 
     * @return Specifies the status of the IP range.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidrIp());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbSecurityGroupIpRange)) {
            return false;
        }
        AwsRdsDbSecurityGroupIpRange other = (AwsRdsDbSecurityGroupIpRange) obj;
        return Objects.equals(cidrIp(), other.cidrIp()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRdsDbSecurityGroupIpRange").add("CidrIp", cidrIp()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrIp":
            return Optional.ofNullable(clazz.cast(cidrIp()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbSecurityGroupIpRange, T> g) {
        return obj -> g.apply((AwsRdsDbSecurityGroupIpRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRdsDbSecurityGroupIpRange> {
        /**
         * <p>
         * Specifies the IP range.
         * </p>
         * 
         * @param cidrIp
         *        Specifies the IP range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIp(String cidrIp);

        /**
         * <p>
         * Specifies the status of the IP range.
         * </p>
         * 
         * @param status
         *        Specifies the status of the IP range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String cidrIp;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbSecurityGroupIpRange model) {
            cidrIp(model.cidrIp);
            status(model.status);
        }

        public final String getCidrIp() {
            return cidrIp;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public AwsRdsDbSecurityGroupIpRange build() {
            return new AwsRdsDbSecurityGroupIpRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
