/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AwsRoute53HostedZoneVpcsListCopier {
    static List<AwsRoute53HostedZoneVpcDetails> copy(
            Collection<? extends AwsRoute53HostedZoneVpcDetails> awsRoute53HostedZoneVpcsListParam) {
        List<AwsRoute53HostedZoneVpcDetails> list;
        if (awsRoute53HostedZoneVpcsListParam == null || awsRoute53HostedZoneVpcsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsRoute53HostedZoneVpcDetails> modifiableList = new ArrayList<>();
            awsRoute53HostedZoneVpcsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AwsRoute53HostedZoneVpcDetails> copyFromBuilder(
            Collection<? extends AwsRoute53HostedZoneVpcDetails.Builder> awsRoute53HostedZoneVpcsListParam) {
        List<AwsRoute53HostedZoneVpcDetails> list;
        if (awsRoute53HostedZoneVpcsListParam == null || awsRoute53HostedZoneVpcsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsRoute53HostedZoneVpcDetails> modifiableList = new ArrayList<>();
            awsRoute53HostedZoneVpcsListParam.forEach(entry -> {
                AwsRoute53HostedZoneVpcDetails member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AwsRoute53HostedZoneVpcDetails.Builder> copyToBuilder(
            Collection<? extends AwsRoute53HostedZoneVpcDetails> awsRoute53HostedZoneVpcsListParam) {
        List<AwsRoute53HostedZoneVpcDetails.Builder> list;
        if (awsRoute53HostedZoneVpcsListParam == null || awsRoute53HostedZoneVpcsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsRoute53HostedZoneVpcDetails.Builder> modifiableList = new ArrayList<>();
            awsRoute53HostedZoneVpcsListParam.forEach(entry -> {
                AwsRoute53HostedZoneVpcDetails.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
