/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the encryption configuration for X-Ray.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsXrayEncryptionConfigDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsXrayEncryptionConfigDetails.Builder, AwsXrayEncryptionConfigDetails> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyId")
            .getter(getter(AwsXrayEncryptionConfigDetails::keyId)).setter(setter(Builder::keyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsXrayEncryptionConfigDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsXrayEncryptionConfigDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, STATUS_FIELD,
            TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String keyId;

    private final String status;

    private final String type;

    private AwsXrayEncryptionConfigDetails(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.status = builder.status;
        this.type = builder.type;
    }

    /**
     * <p>
     * The identifier of the KMS key that is used for encryption. Provided if <code>Type</code> is <code>KMS</code>.
     * </p>
     * 
     * @return The identifier of the KMS key that is used for encryption. Provided if <code>Type</code> is
     *         <code>KMS</code>.
     */
    public final String keyId() {
        return keyId;
    }

    /**
     * <p>
     * The current status of the encryption configuration. Valid values are <code>ACTIVE</code> or <code>UPDATING</code>
     * .
     * </p>
     * <p>
     * When <code>Status</code> is equal to <code>UPDATING</code>, X-Ray might use both the old and new encryption.
     * </p>
     * 
     * @return The current status of the encryption configuration. Valid values are <code>ACTIVE</code> or
     *         <code>UPDATING</code>.</p>
     *         <p>
     *         When <code>Status</code> is equal to <code>UPDATING</code>, X-Ray might use both the old and new
     *         encryption.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The type of encryption. <code>KMS</code> indicates that the encryption uses KMS keys. <code>NONE</code> indicates
     * the default encryption.
     * </p>
     * 
     * @return The type of encryption. <code>KMS</code> indicates that the encryption uses KMS keys. <code>NONE</code>
     *         indicates the default encryption.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsXrayEncryptionConfigDetails)) {
            return false;
        }
        AwsXrayEncryptionConfigDetails other = (AwsXrayEncryptionConfigDetails) obj;
        return Objects.equals(keyId(), other.keyId()) && Objects.equals(status(), other.status())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsXrayEncryptionConfigDetails").add("KeyId", keyId()).add("Status", status())
                .add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyId":
            return Optional.ofNullable(clazz.cast(keyId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsXrayEncryptionConfigDetails, T> g) {
        return obj -> g.apply((AwsXrayEncryptionConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsXrayEncryptionConfigDetails> {
        /**
         * <p>
         * The identifier of the KMS key that is used for encryption. Provided if <code>Type</code> is <code>KMS</code>.
         * </p>
         * 
         * @param keyId
         *        The identifier of the KMS key that is used for encryption. Provided if <code>Type</code> is
         *        <code>KMS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        /**
         * <p>
         * The current status of the encryption configuration. Valid values are <code>ACTIVE</code> or
         * <code>UPDATING</code>.
         * </p>
         * <p>
         * When <code>Status</code> is equal to <code>UPDATING</code>, X-Ray might use both the old and new encryption.
         * </p>
         * 
         * @param status
         *        The current status of the encryption configuration. Valid values are <code>ACTIVE</code> or
         *        <code>UPDATING</code>.</p>
         *        <p>
         *        When <code>Status</code> is equal to <code>UPDATING</code>, X-Ray might use both the old and new
         *        encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The type of encryption. <code>KMS</code> indicates that the encryption uses KMS keys. <code>NONE</code>
         * indicates the default encryption.
         * </p>
         * 
         * @param type
         *        The type of encryption. <code>KMS</code> indicates that the encryption uses KMS keys.
         *        <code>NONE</code> indicates the default encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String keyId;

        private String status;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsXrayEncryptionConfigDetails model) {
            keyId(model.keyId);
            status(model.status);
            type(model.type);
        }

        public final String getKeyId() {
            return keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AwsXrayEncryptionConfigDetails build() {
            return new AwsXrayEncryptionConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
