/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Criteria for the stateless rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupSourceStatelessRuleMatchAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleGroupSourceStatelessRuleMatchAttributes.Builder, RuleGroupSourceStatelessRuleMatchAttributes> {
    private static final SdkField<List<RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts>> DESTINATION_PORTS_FIELD = SdkField
            .<List<RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts>> builder(MarshallingType.LIST)
            .memberName("DestinationPorts")
            .getter(getter(RuleGroupSourceStatelessRuleMatchAttributes::destinationPorts))
            .setter(setter(Builder::destinationPorts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPorts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RuleGroupSourceStatelessRuleMatchAttributesDestinations>> DESTINATIONS_FIELD = SdkField
            .<List<RuleGroupSourceStatelessRuleMatchAttributesDestinations>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(RuleGroupSourceStatelessRuleMatchAttributes::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleGroupSourceStatelessRuleMatchAttributesDestinations> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(RuleGroupSourceStatelessRuleMatchAttributesDestinations::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Integer>> PROTOCOLS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("Protocols")
            .getter(getter(RuleGroupSourceStatelessRuleMatchAttributes::protocols))
            .setter(setter(Builder::protocols))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocols").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts>> SOURCE_PORTS_FIELD = SdkField
            .<List<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts>> builder(MarshallingType.LIST)
            .memberName("SourcePorts")
            .getter(getter(RuleGroupSourceStatelessRuleMatchAttributes::sourcePorts))
            .setter(setter(Builder::sourcePorts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePorts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(RuleGroupSourceStatelessRuleMatchAttributesSourcePorts::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RuleGroupSourceStatelessRuleMatchAttributesSources>> SOURCES_FIELD = SdkField
            .<List<RuleGroupSourceStatelessRuleMatchAttributesSources>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(RuleGroupSourceStatelessRuleMatchAttributes::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleGroupSourceStatelessRuleMatchAttributesSources> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(RuleGroupSourceStatelessRuleMatchAttributesSources::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags>> TCP_FLAGS_FIELD = SdkField
            .<List<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags>> builder(MarshallingType.LIST)
            .memberName("TcpFlags")
            .getter(getter(RuleGroupSourceStatelessRuleMatchAttributes::tcpFlags))
            .setter(setter(Builder::tcpFlags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TcpFlags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(RuleGroupSourceStatelessRuleMatchAttributesTcpFlags::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_PORTS_FIELD,
            DESTINATIONS_FIELD, PROTOCOLS_FIELD, SOURCE_PORTS_FIELD, SOURCES_FIELD, TCP_FLAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts> destinationPorts;

    private final List<RuleGroupSourceStatelessRuleMatchAttributesDestinations> destinations;

    private final List<Integer> protocols;

    private final List<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts> sourcePorts;

    private final List<RuleGroupSourceStatelessRuleMatchAttributesSources> sources;

    private final List<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags> tcpFlags;

    private RuleGroupSourceStatelessRuleMatchAttributes(BuilderImpl builder) {
        this.destinationPorts = builder.destinationPorts;
        this.destinations = builder.destinations;
        this.protocols = builder.protocols;
        this.sourcePorts = builder.sourcePorts;
        this.sources = builder.sources;
        this.tcpFlags = builder.tcpFlags;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationPorts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinationPorts() {
        return destinationPorts != null && !(destinationPorts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of port ranges to specify the destination ports to inspect for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationPorts} method.
     * </p>
     * 
     * @return A list of port ranges to specify the destination ports to inspect for.
     */
    public final List<RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts> destinationPorts() {
        return destinationPorts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination IP addresses and address ranges to inspect for, in CIDR notation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return The destination IP addresses and address ranges to inspect for, in CIDR notation.
     */
    public final List<RuleGroupSourceStatelessRuleMatchAttributesDestinations> destinations() {
        return destinations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Protocols property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProtocols() {
        return protocols != null && !(protocols instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The protocols to inspect for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtocols} method.
     * </p>
     * 
     * @return The protocols to inspect for.
     */
    public final List<Integer> protocols() {
        return protocols;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourcePorts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourcePorts() {
        return sourcePorts != null && !(sourcePorts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of port ranges to specify the source ports to inspect for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourcePorts} method.
     * </p>
     * 
     * @return A list of port ranges to specify the source ports to inspect for.
     */
    public final List<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts> sourcePorts() {
        return sourcePorts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source IP addresses and address ranges to inspect for, in CIDR notation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The source IP addresses and address ranges to inspect for, in CIDR notation.
     */
    public final List<RuleGroupSourceStatelessRuleMatchAttributesSources> sources() {
        return sources;
    }

    /**
     * For responses, this returns true if the service returned a value for the TcpFlags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTcpFlags() {
        return tcpFlags != null && !(tcpFlags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The TCP flags and masks to inspect for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTcpFlags} method.
     * </p>
     * 
     * @return The TCP flags and masks to inspect for.
     */
    public final List<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags> tcpFlags() {
        return tcpFlags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationPorts() ? destinationPorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProtocols() ? protocols() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourcePorts() ? sourcePorts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTcpFlags() ? tcpFlags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSourceStatelessRuleMatchAttributes)) {
            return false;
        }
        RuleGroupSourceStatelessRuleMatchAttributes other = (RuleGroupSourceStatelessRuleMatchAttributes) obj;
        return hasDestinationPorts() == other.hasDestinationPorts()
                && Objects.equals(destinationPorts(), other.destinationPorts()) && hasDestinations() == other.hasDestinations()
                && Objects.equals(destinations(), other.destinations()) && hasProtocols() == other.hasProtocols()
                && Objects.equals(protocols(), other.protocols()) && hasSourcePorts() == other.hasSourcePorts()
                && Objects.equals(sourcePorts(), other.sourcePorts()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources()) && hasTcpFlags() == other.hasTcpFlags()
                && Objects.equals(tcpFlags(), other.tcpFlags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupSourceStatelessRuleMatchAttributes")
                .add("DestinationPorts", hasDestinationPorts() ? destinationPorts() : null)
                .add("Destinations", hasDestinations() ? destinations() : null)
                .add("Protocols", hasProtocols() ? protocols() : null)
                .add("SourcePorts", hasSourcePorts() ? sourcePorts() : null).add("Sources", hasSources() ? sources() : null)
                .add("TcpFlags", hasTcpFlags() ? tcpFlags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationPorts":
            return Optional.ofNullable(clazz.cast(destinationPorts()));
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "Protocols":
            return Optional.ofNullable(clazz.cast(protocols()));
        case "SourcePorts":
            return Optional.ofNullable(clazz.cast(sourcePorts()));
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "TcpFlags":
            return Optional.ofNullable(clazz.cast(tcpFlags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSourceStatelessRuleMatchAttributes, T> g) {
        return obj -> g.apply((RuleGroupSourceStatelessRuleMatchAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupSourceStatelessRuleMatchAttributes> {
        /**
         * <p>
         * A list of port ranges to specify the destination ports to inspect for.
         * </p>
         * 
         * @param destinationPorts
         *        A list of port ranges to specify the destination ports to inspect for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPorts(Collection<RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts> destinationPorts);

        /**
         * <p>
         * A list of port ranges to specify the destination ports to inspect for.
         * </p>
         * 
         * @param destinationPorts
         *        A list of port ranges to specify the destination ports to inspect for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPorts(RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts... destinationPorts);

        /**
         * <p>
         * A list of port ranges to specify the destination ports to inspect for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #destinationPorts(List<RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts>)}.
         * 
         * @param destinationPorts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationPorts(java.util.Collection<RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts>)
         */
        Builder destinationPorts(
                Consumer<RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts.Builder>... destinationPorts);

        /**
         * <p>
         * The destination IP addresses and address ranges to inspect for, in CIDR notation.
         * </p>
         * 
         * @param destinations
         *        The destination IP addresses and address ranges to inspect for, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<RuleGroupSourceStatelessRuleMatchAttributesDestinations> destinations);

        /**
         * <p>
         * The destination IP addresses and address ranges to inspect for, in CIDR notation.
         * </p>
         * 
         * @param destinations
         *        The destination IP addresses and address ranges to inspect for, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(RuleGroupSourceStatelessRuleMatchAttributesDestinations... destinations);

        /**
         * <p>
         * The destination IP addresses and address ranges to inspect for, in CIDR notation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #destinations(List<RuleGroupSourceStatelessRuleMatchAttributesDestinations>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesDestinations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(java.util.Collection<RuleGroupSourceStatelessRuleMatchAttributesDestinations>)
         */
        Builder destinations(Consumer<RuleGroupSourceStatelessRuleMatchAttributesDestinations.Builder>... destinations);

        /**
         * <p>
         * The protocols to inspect for.
         * </p>
         * 
         * @param protocols
         *        The protocols to inspect for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocols(Collection<Integer> protocols);

        /**
         * <p>
         * The protocols to inspect for.
         * </p>
         * 
         * @param protocols
         *        The protocols to inspect for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocols(Integer... protocols);

        /**
         * <p>
         * A list of port ranges to specify the source ports to inspect for.
         * </p>
         * 
         * @param sourcePorts
         *        A list of port ranges to specify the source ports to inspect for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePorts(Collection<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts> sourcePorts);

        /**
         * <p>
         * A list of port ranges to specify the source ports to inspect for.
         * </p>
         * 
         * @param sourcePorts
         *        A list of port ranges to specify the source ports to inspect for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePorts(RuleGroupSourceStatelessRuleMatchAttributesSourcePorts... sourcePorts);

        /**
         * <p>
         * A list of port ranges to specify the source ports to inspect for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #sourcePorts(List<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts>)}.
         * 
         * @param sourcePorts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourcePorts(java.util.Collection<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts>)
         */
        Builder sourcePorts(Consumer<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.Builder>... sourcePorts);

        /**
         * <p>
         * The source IP addresses and address ranges to inspect for, in CIDR notation.
         * </p>
         * 
         * @param sources
         *        The source IP addresses and address ranges to inspect for, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<RuleGroupSourceStatelessRuleMatchAttributesSources> sources);

        /**
         * <p>
         * The source IP addresses and address ranges to inspect for, in CIDR notation.
         * </p>
         * 
         * @param sources
         *        The source IP addresses and address ranges to inspect for, in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(RuleGroupSourceStatelessRuleMatchAttributesSources... sources);

        /**
         * <p>
         * The source IP addresses and address ranges to inspect for, in CIDR notation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #sources(List<RuleGroupSourceStatelessRuleMatchAttributesSources>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesSources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<RuleGroupSourceStatelessRuleMatchAttributesSources>)
         */
        Builder sources(Consumer<RuleGroupSourceStatelessRuleMatchAttributesSources.Builder>... sources);

        /**
         * <p>
         * The TCP flags and masks to inspect for.
         * </p>
         * 
         * @param tcpFlags
         *        The TCP flags and masks to inspect for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcpFlags(Collection<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags> tcpFlags);

        /**
         * <p>
         * The TCP flags and masks to inspect for.
         * </p>
         * 
         * @param tcpFlags
         *        The TCP flags and masks to inspect for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcpFlags(RuleGroupSourceStatelessRuleMatchAttributesTcpFlags... tcpFlags);

        /**
         * <p>
         * The TCP flags and masks to inspect for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #tcpFlags(List<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags>)}.
         * 
         * @param tcpFlags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tcpFlags(java.util.Collection<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags>)
         */
        Builder tcpFlags(Consumer<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.Builder>... tcpFlags);
    }

    static final class BuilderImpl implements Builder {
        private List<RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts> destinationPorts = DefaultSdkAutoConstructList
                .getInstance();

        private List<RuleGroupSourceStatelessRuleMatchAttributesDestinations> destinations = DefaultSdkAutoConstructList
                .getInstance();

        private List<Integer> protocols = DefaultSdkAutoConstructList.getInstance();

        private List<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts> sourcePorts = DefaultSdkAutoConstructList
                .getInstance();

        private List<RuleGroupSourceStatelessRuleMatchAttributesSources> sources = DefaultSdkAutoConstructList.getInstance();

        private List<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags> tcpFlags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSourceStatelessRuleMatchAttributes model) {
            destinationPorts(model.destinationPorts);
            destinations(model.destinations);
            protocols(model.protocols);
            sourcePorts(model.sourcePorts);
            sources(model.sources);
            tcpFlags(model.tcpFlags);
        }

        public final List<RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts.Builder> getDestinationPorts() {
            List<RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts.Builder> result = RuleGroupSourceStatelessRuleMatchAttributesDestinationPortsListCopier
                    .copyToBuilder(this.destinationPorts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationPorts(
                Collection<RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts.BuilderImpl> destinationPorts) {
            this.destinationPorts = RuleGroupSourceStatelessRuleMatchAttributesDestinationPortsListCopier
                    .copyFromBuilder(destinationPorts);
        }

        @Override
        public final Builder destinationPorts(
                Collection<RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts> destinationPorts) {
            this.destinationPorts = RuleGroupSourceStatelessRuleMatchAttributesDestinationPortsListCopier.copy(destinationPorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPorts(RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts... destinationPorts) {
            destinationPorts(Arrays.asList(destinationPorts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPorts(
                Consumer<RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts.Builder>... destinationPorts) {
            destinationPorts(Stream.of(destinationPorts)
                    .map(c -> RuleGroupSourceStatelessRuleMatchAttributesDestinationPorts.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RuleGroupSourceStatelessRuleMatchAttributesDestinations.Builder> getDestinations() {
            List<RuleGroupSourceStatelessRuleMatchAttributesDestinations.Builder> result = RuleGroupSourceStatelessRuleMatchAttributesDestinationsListCopier
                    .copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(
                Collection<RuleGroupSourceStatelessRuleMatchAttributesDestinations.BuilderImpl> destinations) {
            this.destinations = RuleGroupSourceStatelessRuleMatchAttributesDestinationsListCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<RuleGroupSourceStatelessRuleMatchAttributesDestinations> destinations) {
            this.destinations = RuleGroupSourceStatelessRuleMatchAttributesDestinationsListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(RuleGroupSourceStatelessRuleMatchAttributesDestinations... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(
                Consumer<RuleGroupSourceStatelessRuleMatchAttributesDestinations.Builder>... destinations) {
            destinations(Stream.of(destinations)
                    .map(c -> RuleGroupSourceStatelessRuleMatchAttributesDestinations.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<Integer> getProtocols() {
            if (protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return protocols;
        }

        public final void setProtocols(Collection<Integer> protocols) {
            this.protocols = RuleGroupSourceStatelessRuleMatchAttributesProtocolsListCopier.copy(protocols);
        }

        @Override
        public final Builder protocols(Collection<Integer> protocols) {
            this.protocols = RuleGroupSourceStatelessRuleMatchAttributesProtocolsListCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(Integer... protocols) {
            protocols(Arrays.asList(protocols));
            return this;
        }

        public final List<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.Builder> getSourcePorts() {
            List<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.Builder> result = RuleGroupSourceStatelessRuleMatchAttributesSourcePortsListCopier
                    .copyToBuilder(this.sourcePorts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourcePorts(
                Collection<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.BuilderImpl> sourcePorts) {
            this.sourcePorts = RuleGroupSourceStatelessRuleMatchAttributesSourcePortsListCopier.copyFromBuilder(sourcePorts);
        }

        @Override
        public final Builder sourcePorts(Collection<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts> sourcePorts) {
            this.sourcePorts = RuleGroupSourceStatelessRuleMatchAttributesSourcePortsListCopier.copy(sourcePorts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePorts(RuleGroupSourceStatelessRuleMatchAttributesSourcePorts... sourcePorts) {
            sourcePorts(Arrays.asList(sourcePorts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePorts(Consumer<RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.Builder>... sourcePorts) {
            sourcePorts(Stream.of(sourcePorts)
                    .map(c -> RuleGroupSourceStatelessRuleMatchAttributesSourcePorts.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RuleGroupSourceStatelessRuleMatchAttributesSources.Builder> getSources() {
            List<RuleGroupSourceStatelessRuleMatchAttributesSources.Builder> result = RuleGroupSourceStatelessRuleMatchAttributesSourcesListCopier
                    .copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<RuleGroupSourceStatelessRuleMatchAttributesSources.BuilderImpl> sources) {
            this.sources = RuleGroupSourceStatelessRuleMatchAttributesSourcesListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<RuleGroupSourceStatelessRuleMatchAttributesSources> sources) {
            this.sources = RuleGroupSourceStatelessRuleMatchAttributesSourcesListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(RuleGroupSourceStatelessRuleMatchAttributesSources... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<RuleGroupSourceStatelessRuleMatchAttributesSources.Builder>... sources) {
            sources(Stream.of(sources)
                    .map(c -> RuleGroupSourceStatelessRuleMatchAttributesSources.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.Builder> getTcpFlags() {
            List<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.Builder> result = RuleGroupSourceStatelessRuleMatchAttributesTcpFlagsListCopier
                    .copyToBuilder(this.tcpFlags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTcpFlags(Collection<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.BuilderImpl> tcpFlags) {
            this.tcpFlags = RuleGroupSourceStatelessRuleMatchAttributesTcpFlagsListCopier.copyFromBuilder(tcpFlags);
        }

        @Override
        public final Builder tcpFlags(Collection<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags> tcpFlags) {
            this.tcpFlags = RuleGroupSourceStatelessRuleMatchAttributesTcpFlagsListCopier.copy(tcpFlags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tcpFlags(RuleGroupSourceStatelessRuleMatchAttributesTcpFlags... tcpFlags) {
            tcpFlags(Arrays.asList(tcpFlags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tcpFlags(Consumer<RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.Builder>... tcpFlags) {
            tcpFlags(Stream.of(tcpFlags)
                    .map(c -> RuleGroupSourceStatelessRuleMatchAttributesTcpFlags.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RuleGroupSourceStatelessRuleMatchAttributes build() {
            return new RuleGroupSourceStatelessRuleMatchAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
