/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorDataSourcesDetails;
import software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorFeaturesDetails;
import software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorFeaturesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsGuardDutyDetectorDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsGuardDutyDetectorDetails> {
    private static final SdkField<AwsGuardDutyDetectorDataSourcesDetails> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSources").getter(AwsGuardDutyDetectorDetails.getter(AwsGuardDutyDetectorDetails::dataSources)).setter(AwsGuardDutyDetectorDetails.setter(Builder::dataSources)).constructor(AwsGuardDutyDetectorDataSourcesDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSources").build()}).build();
    private static final SdkField<List<AwsGuardDutyDetectorFeaturesDetails>> FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Features").getter(AwsGuardDutyDetectorDetails.getter(AwsGuardDutyDetectorDetails::features)).setter(AwsGuardDutyDetectorDetails.setter(Builder::features)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Features").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsGuardDutyDetectorFeaturesDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FINDING_PUBLISHING_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FindingPublishingFrequency").getter(AwsGuardDutyDetectorDetails.getter(AwsGuardDutyDetectorDetails::findingPublishingFrequency)).setter(AwsGuardDutyDetectorDetails.setter(Builder::findingPublishingFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingPublishingFrequency").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRole").getter(AwsGuardDutyDetectorDetails.getter(AwsGuardDutyDetectorDetails::serviceRole)).setter(AwsGuardDutyDetectorDetails.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AwsGuardDutyDetectorDetails.getter(AwsGuardDutyDetectorDetails::status)).setter(AwsGuardDutyDetectorDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCES_FIELD, FEATURES_FIELD, FINDING_PUBLISHING_FREQUENCY_FIELD, SERVICE_ROLE_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final AwsGuardDutyDetectorDataSourcesDetails dataSources;
    private final List<AwsGuardDutyDetectorFeaturesDetails> features;
    private final String findingPublishingFrequency;
    private final String serviceRole;
    private final String status;

    private AwsGuardDutyDetectorDetails(BuilderImpl builder) {
        this.dataSources = builder.dataSources;
        this.features = builder.features;
        this.findingPublishingFrequency = builder.findingPublishingFrequency;
        this.serviceRole = builder.serviceRole;
        this.status = builder.status;
    }

    public final AwsGuardDutyDetectorDataSourcesDetails dataSources() {
        return this.dataSources;
    }

    public final boolean hasFeatures() {
        return this.features != null && !(this.features instanceof SdkAutoConstructList);
    }

    public final List<AwsGuardDutyDetectorFeaturesDetails> features() {
        return this.features;
    }

    public final String findingPublishingFrequency() {
        return this.findingPublishingFrequency;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatures() ? this.features() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.findingPublishingFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsGuardDutyDetectorDetails)) {
            return false;
        }
        AwsGuardDutyDetectorDetails other = (AwsGuardDutyDetectorDetails)obj;
        return Objects.equals(this.dataSources(), other.dataSources()) && this.hasFeatures() == other.hasFeatures() && Objects.equals(this.features(), other.features()) && Objects.equals(this.findingPublishingFrequency(), other.findingPublishingFrequency()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"AwsGuardDutyDetectorDetails").add("DataSources", (Object)this.dataSources()).add("Features", this.hasFeatures() ? this.features() : null).add("FindingPublishingFrequency", (Object)this.findingPublishingFrequency()).add("ServiceRole", (Object)this.serviceRole()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
            case "Features": {
                return Optional.ofNullable(clazz.cast(this.features()));
            }
            case "FindingPublishingFrequency": {
                return Optional.ofNullable(clazz.cast(this.findingPublishingFrequency()));
            }
            case "ServiceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsGuardDutyDetectorDetails, T> g) {
        return obj -> g.apply((AwsGuardDutyDetectorDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsGuardDutyDetectorDataSourcesDetails dataSources;
        private List<AwsGuardDutyDetectorFeaturesDetails> features = DefaultSdkAutoConstructList.getInstance();
        private String findingPublishingFrequency;
        private String serviceRole;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsGuardDutyDetectorDetails model) {
            this.dataSources(model.dataSources);
            this.features(model.features);
            this.findingPublishingFrequency(model.findingPublishingFrequency);
            this.serviceRole(model.serviceRole);
            this.status(model.status);
        }

        public final AwsGuardDutyDetectorDataSourcesDetails.Builder getDataSources() {
            return this.dataSources != null ? this.dataSources.toBuilder() : null;
        }

        public final void setDataSources(AwsGuardDutyDetectorDataSourcesDetails.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        public final Builder dataSources(AwsGuardDutyDetectorDataSourcesDetails dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final List<AwsGuardDutyDetectorFeaturesDetails.Builder> getFeatures() {
            List<AwsGuardDutyDetectorFeaturesDetails.Builder> result = AwsGuardDutyDetectorFeaturesListCopier.copyToBuilder(this.features);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatures(Collection<AwsGuardDutyDetectorFeaturesDetails.BuilderImpl> features) {
            this.features = AwsGuardDutyDetectorFeaturesListCopier.copyFromBuilder(features);
        }

        @Override
        public final Builder features(Collection<AwsGuardDutyDetectorFeaturesDetails> features) {
            this.features = AwsGuardDutyDetectorFeaturesListCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(AwsGuardDutyDetectorFeaturesDetails ... features) {
            this.features(Arrays.asList(features));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(Consumer<AwsGuardDutyDetectorFeaturesDetails.Builder> ... features) {
            this.features(Stream.of(features).map(c -> (AwsGuardDutyDetectorFeaturesDetails)((AwsGuardDutyDetectorFeaturesDetails.Builder)AwsGuardDutyDetectorFeaturesDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFindingPublishingFrequency() {
            return this.findingPublishingFrequency;
        }

        public final void setFindingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
        }

        @Override
        public final Builder findingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public AwsGuardDutyDetectorDetails build() {
            return new AwsGuardDutyDetectorDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsGuardDutyDetectorDetails> {
        public Builder dataSources(AwsGuardDutyDetectorDataSourcesDetails var1);

        default public Builder dataSources(Consumer<AwsGuardDutyDetectorDataSourcesDetails.Builder> dataSources) {
            return this.dataSources((AwsGuardDutyDetectorDataSourcesDetails)((AwsGuardDutyDetectorDataSourcesDetails.Builder)AwsGuardDutyDetectorDataSourcesDetails.builder().applyMutation(dataSources)).build());
        }

        public Builder features(Collection<AwsGuardDutyDetectorFeaturesDetails> var1);

        public Builder features(AwsGuardDutyDetectorFeaturesDetails ... var1);

        public Builder features(Consumer<AwsGuardDutyDetectorFeaturesDetails.Builder> ... var1);

        public Builder findingPublishingFrequency(String var1);

        public Builder serviceRole(String var1);

        public Builder status(String var1);
    }
}

