/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCloudFrontDistributionViewerCertificate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCloudFrontDistributionViewerCertificate> {
    private static final SdkField<String> ACM_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcmCertificateArn").getter(AwsCloudFrontDistributionViewerCertificate.getter(AwsCloudFrontDistributionViewerCertificate::acmCertificateArn)).setter(AwsCloudFrontDistributionViewerCertificate.setter(Builder::acmCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcmCertificateArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Certificate").getter(AwsCloudFrontDistributionViewerCertificate.getter(AwsCloudFrontDistributionViewerCertificate::certificate)).setter(AwsCloudFrontDistributionViewerCertificate.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()}).build();
    private static final SdkField<String> CERTIFICATE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateSource").getter(AwsCloudFrontDistributionViewerCertificate.getter(AwsCloudFrontDistributionViewerCertificate::certificateSource)).setter(AwsCloudFrontDistributionViewerCertificate.setter(Builder::certificateSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateSource").build()}).build();
    private static final SdkField<Boolean> CLOUD_FRONT_DEFAULT_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CloudFrontDefaultCertificate").getter(AwsCloudFrontDistributionViewerCertificate.getter(AwsCloudFrontDistributionViewerCertificate::cloudFrontDefaultCertificate)).setter(AwsCloudFrontDistributionViewerCertificate.setter(Builder::cloudFrontDefaultCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFrontDefaultCertificate").build()}).build();
    private static final SdkField<String> IAM_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamCertificateId").getter(AwsCloudFrontDistributionViewerCertificate.getter(AwsCloudFrontDistributionViewerCertificate::iamCertificateId)).setter(AwsCloudFrontDistributionViewerCertificate.setter(Builder::iamCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamCertificateId").build()}).build();
    private static final SdkField<String> MINIMUM_PROTOCOL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinimumProtocolVersion").getter(AwsCloudFrontDistributionViewerCertificate.getter(AwsCloudFrontDistributionViewerCertificate::minimumProtocolVersion)).setter(AwsCloudFrontDistributionViewerCertificate.setter(Builder::minimumProtocolVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumProtocolVersion").build()}).build();
    private static final SdkField<String> SSL_SUPPORT_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SslSupportMethod").getter(AwsCloudFrontDistributionViewerCertificate.getter(AwsCloudFrontDistributionViewerCertificate::sslSupportMethod)).setter(AwsCloudFrontDistributionViewerCertificate.setter(Builder::sslSupportMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslSupportMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACM_CERTIFICATE_ARN_FIELD, CERTIFICATE_FIELD, CERTIFICATE_SOURCE_FIELD, CLOUD_FRONT_DEFAULT_CERTIFICATE_FIELD, IAM_CERTIFICATE_ID_FIELD, MINIMUM_PROTOCOL_VERSION_FIELD, SSL_SUPPORT_METHOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String acmCertificateArn;
    private final String certificate;
    private final String certificateSource;
    private final Boolean cloudFrontDefaultCertificate;
    private final String iamCertificateId;
    private final String minimumProtocolVersion;
    private final String sslSupportMethod;

    private AwsCloudFrontDistributionViewerCertificate(BuilderImpl builder) {
        this.acmCertificateArn = builder.acmCertificateArn;
        this.certificate = builder.certificate;
        this.certificateSource = builder.certificateSource;
        this.cloudFrontDefaultCertificate = builder.cloudFrontDefaultCertificate;
        this.iamCertificateId = builder.iamCertificateId;
        this.minimumProtocolVersion = builder.minimumProtocolVersion;
        this.sslSupportMethod = builder.sslSupportMethod;
    }

    public final String acmCertificateArn() {
        return this.acmCertificateArn;
    }

    public final String certificate() {
        return this.certificate;
    }

    public final String certificateSource() {
        return this.certificateSource;
    }

    public final Boolean cloudFrontDefaultCertificate() {
        return this.cloudFrontDefaultCertificate;
    }

    public final String iamCertificateId() {
        return this.iamCertificateId;
    }

    public final String minimumProtocolVersion() {
        return this.minimumProtocolVersion;
    }

    public final String sslSupportMethod() {
        return this.sslSupportMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acmCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFrontDefaultCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumProtocolVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslSupportMethod());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionViewerCertificate)) {
            return false;
        }
        AwsCloudFrontDistributionViewerCertificate other = (AwsCloudFrontDistributionViewerCertificate)obj;
        return Objects.equals(this.acmCertificateArn(), other.acmCertificateArn()) && Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.certificateSource(), other.certificateSource()) && Objects.equals(this.cloudFrontDefaultCertificate(), other.cloudFrontDefaultCertificate()) && Objects.equals(this.iamCertificateId(), other.iamCertificateId()) && Objects.equals(this.minimumProtocolVersion(), other.minimumProtocolVersion()) && Objects.equals(this.sslSupportMethod(), other.sslSupportMethod());
    }

    public final String toString() {
        return ToString.builder((String)"AwsCloudFrontDistributionViewerCertificate").add("AcmCertificateArn", (Object)this.acmCertificateArn()).add("Certificate", (Object)this.certificate()).add("CertificateSource", (Object)this.certificateSource()).add("CloudFrontDefaultCertificate", (Object)this.cloudFrontDefaultCertificate()).add("IamCertificateId", (Object)this.iamCertificateId()).add("MinimumProtocolVersion", (Object)this.minimumProtocolVersion()).add("SslSupportMethod", (Object)this.sslSupportMethod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcmCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.acmCertificateArn()));
            }
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "CertificateSource": {
                return Optional.ofNullable(clazz.cast(this.certificateSource()));
            }
            case "CloudFrontDefaultCertificate": {
                return Optional.ofNullable(clazz.cast(this.cloudFrontDefaultCertificate()));
            }
            case "IamCertificateId": {
                return Optional.ofNullable(clazz.cast(this.iamCertificateId()));
            }
            case "MinimumProtocolVersion": {
                return Optional.ofNullable(clazz.cast(this.minimumProtocolVersion()));
            }
            case "SslSupportMethod": {
                return Optional.ofNullable(clazz.cast(this.sslSupportMethod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionViewerCertificate, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionViewerCertificate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String acmCertificateArn;
        private String certificate;
        private String certificateSource;
        private Boolean cloudFrontDefaultCertificate;
        private String iamCertificateId;
        private String minimumProtocolVersion;
        private String sslSupportMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionViewerCertificate model) {
            this.acmCertificateArn(model.acmCertificateArn);
            this.certificate(model.certificate);
            this.certificateSource(model.certificateSource);
            this.cloudFrontDefaultCertificate(model.cloudFrontDefaultCertificate);
            this.iamCertificateId(model.iamCertificateId);
            this.minimumProtocolVersion(model.minimumProtocolVersion);
            this.sslSupportMethod(model.sslSupportMethod);
        }

        public final String getAcmCertificateArn() {
            return this.acmCertificateArn;
        }

        public final void setAcmCertificateArn(String acmCertificateArn) {
            this.acmCertificateArn = acmCertificateArn;
        }

        @Override
        public final Builder acmCertificateArn(String acmCertificateArn) {
            this.acmCertificateArn = acmCertificateArn;
            return this;
        }

        public final String getCertificate() {
            return this.certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final String getCertificateSource() {
            return this.certificateSource;
        }

        public final void setCertificateSource(String certificateSource) {
            this.certificateSource = certificateSource;
        }

        @Override
        public final Builder certificateSource(String certificateSource) {
            this.certificateSource = certificateSource;
            return this;
        }

        public final Boolean getCloudFrontDefaultCertificate() {
            return this.cloudFrontDefaultCertificate;
        }

        public final void setCloudFrontDefaultCertificate(Boolean cloudFrontDefaultCertificate) {
            this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
        }

        @Override
        public final Builder cloudFrontDefaultCertificate(Boolean cloudFrontDefaultCertificate) {
            this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
            return this;
        }

        public final String getIamCertificateId() {
            return this.iamCertificateId;
        }

        public final void setIamCertificateId(String iamCertificateId) {
            this.iamCertificateId = iamCertificateId;
        }

        @Override
        public final Builder iamCertificateId(String iamCertificateId) {
            this.iamCertificateId = iamCertificateId;
            return this;
        }

        public final String getMinimumProtocolVersion() {
            return this.minimumProtocolVersion;
        }

        public final void setMinimumProtocolVersion(String minimumProtocolVersion) {
            this.minimumProtocolVersion = minimumProtocolVersion;
        }

        @Override
        public final Builder minimumProtocolVersion(String minimumProtocolVersion) {
            this.minimumProtocolVersion = minimumProtocolVersion;
            return this;
        }

        public final String getSslSupportMethod() {
            return this.sslSupportMethod;
        }

        public final void setSslSupportMethod(String sslSupportMethod) {
            this.sslSupportMethod = sslSupportMethod;
        }

        @Override
        public final Builder sslSupportMethod(String sslSupportMethod) {
            this.sslSupportMethod = sslSupportMethod;
            return this;
        }

        public AwsCloudFrontDistributionViewerCertificate build() {
            return new AwsCloudFrontDistributionViewerCertificate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCloudFrontDistributionViewerCertificate> {
        public Builder acmCertificateArn(String var1);

        public Builder certificate(String var1);

        public Builder certificateSource(String var1);

        public Builder cloudFrontDefaultCertificate(Boolean var1);

        public Builder iamCertificateId(String var1);

        public Builder minimumProtocolVersion(String var1);

        public Builder sslSupportMethod(String var1);
    }
}

