/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneNameServersListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneObjectDetails;
import software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneVpcDetails;
import software.amazon.awssdk.services.securityhub.model.AwsRoute53HostedZoneVpcsListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsRoute53QueryLoggingConfigDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsRoute53HostedZoneDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsRoute53HostedZoneDetails> {
    private static final SdkField<AwsRoute53HostedZoneObjectDetails> HOSTED_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HostedZone").getter(AwsRoute53HostedZoneDetails.getter(AwsRoute53HostedZoneDetails::hostedZone)).setter(AwsRoute53HostedZoneDetails.setter(Builder::hostedZone)).constructor(AwsRoute53HostedZoneObjectDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZone").build()}).build();
    private static final SdkField<List<AwsRoute53HostedZoneVpcDetails>> VPCS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Vpcs").getter(AwsRoute53HostedZoneDetails.getter(AwsRoute53HostedZoneDetails::vpcs)).setter(AwsRoute53HostedZoneDetails.setter(Builder::vpcs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpcs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsRoute53HostedZoneVpcDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NAME_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NameServers").getter(AwsRoute53HostedZoneDetails.getter(AwsRoute53HostedZoneDetails::nameServers)).setter(AwsRoute53HostedZoneDetails.setter(Builder::nameServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsRoute53QueryLoggingConfigDetails> QUERY_LOGGING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryLoggingConfig").getter(AwsRoute53HostedZoneDetails.getter(AwsRoute53HostedZoneDetails::queryLoggingConfig)).setter(AwsRoute53HostedZoneDetails.setter(Builder::queryLoggingConfig)).constructor(AwsRoute53QueryLoggingConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryLoggingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_FIELD, VPCS_FIELD, NAME_SERVERS_FIELD, QUERY_LOGGING_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final AwsRoute53HostedZoneObjectDetails hostedZone;
    private final List<AwsRoute53HostedZoneVpcDetails> vpcs;
    private final List<String> nameServers;
    private final AwsRoute53QueryLoggingConfigDetails queryLoggingConfig;

    private AwsRoute53HostedZoneDetails(BuilderImpl builder) {
        this.hostedZone = builder.hostedZone;
        this.vpcs = builder.vpcs;
        this.nameServers = builder.nameServers;
        this.queryLoggingConfig = builder.queryLoggingConfig;
    }

    public final AwsRoute53HostedZoneObjectDetails hostedZone() {
        return this.hostedZone;
    }

    public final boolean hasVpcs() {
        return this.vpcs != null && !(this.vpcs instanceof SdkAutoConstructList);
    }

    public final List<AwsRoute53HostedZoneVpcDetails> vpcs() {
        return this.vpcs;
    }

    public final boolean hasNameServers() {
        return this.nameServers != null && !(this.nameServers instanceof SdkAutoConstructList);
    }

    public final List<String> nameServers() {
        return this.nameServers;
    }

    public final AwsRoute53QueryLoggingConfigDetails queryLoggingConfig() {
        return this.queryLoggingConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcs() ? this.vpcs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNameServers() ? this.nameServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.queryLoggingConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRoute53HostedZoneDetails)) {
            return false;
        }
        AwsRoute53HostedZoneDetails other = (AwsRoute53HostedZoneDetails)obj;
        return Objects.equals(this.hostedZone(), other.hostedZone()) && this.hasVpcs() == other.hasVpcs() && Objects.equals(this.vpcs(), other.vpcs()) && this.hasNameServers() == other.hasNameServers() && Objects.equals(this.nameServers(), other.nameServers()) && Objects.equals(this.queryLoggingConfig(), other.queryLoggingConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AwsRoute53HostedZoneDetails").add("HostedZone", (Object)this.hostedZone()).add("Vpcs", this.hasVpcs() ? this.vpcs() : null).add("NameServers", this.hasNameServers() ? this.nameServers() : null).add("QueryLoggingConfig", (Object)this.queryLoggingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZone": {
                return Optional.ofNullable(clazz.cast(this.hostedZone()));
            }
            case "Vpcs": {
                return Optional.ofNullable(clazz.cast(this.vpcs()));
            }
            case "NameServers": {
                return Optional.ofNullable(clazz.cast(this.nameServers()));
            }
            case "QueryLoggingConfig": {
                return Optional.ofNullable(clazz.cast(this.queryLoggingConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRoute53HostedZoneDetails, T> g) {
        return obj -> g.apply((AwsRoute53HostedZoneDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsRoute53HostedZoneObjectDetails hostedZone;
        private List<AwsRoute53HostedZoneVpcDetails> vpcs = DefaultSdkAutoConstructList.getInstance();
        private List<String> nameServers = DefaultSdkAutoConstructList.getInstance();
        private AwsRoute53QueryLoggingConfigDetails queryLoggingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRoute53HostedZoneDetails model) {
            this.hostedZone(model.hostedZone);
            this.vpcs(model.vpcs);
            this.nameServers(model.nameServers);
            this.queryLoggingConfig(model.queryLoggingConfig);
        }

        public final AwsRoute53HostedZoneObjectDetails.Builder getHostedZone() {
            return this.hostedZone != null ? this.hostedZone.toBuilder() : null;
        }

        public final void setHostedZone(AwsRoute53HostedZoneObjectDetails.BuilderImpl hostedZone) {
            this.hostedZone = hostedZone != null ? hostedZone.build() : null;
        }

        @Override
        public final Builder hostedZone(AwsRoute53HostedZoneObjectDetails hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        public final List<AwsRoute53HostedZoneVpcDetails.Builder> getVpcs() {
            List<AwsRoute53HostedZoneVpcDetails.Builder> result = AwsRoute53HostedZoneVpcsListCopier.copyToBuilder(this.vpcs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcs(Collection<AwsRoute53HostedZoneVpcDetails.BuilderImpl> vpcs) {
            this.vpcs = AwsRoute53HostedZoneVpcsListCopier.copyFromBuilder(vpcs);
        }

        @Override
        public final Builder vpcs(Collection<AwsRoute53HostedZoneVpcDetails> vpcs) {
            this.vpcs = AwsRoute53HostedZoneVpcsListCopier.copy(vpcs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcs(AwsRoute53HostedZoneVpcDetails ... vpcs) {
            this.vpcs(Arrays.asList(vpcs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcs(Consumer<AwsRoute53HostedZoneVpcDetails.Builder> ... vpcs) {
            this.vpcs(Stream.of(vpcs).map(c -> (AwsRoute53HostedZoneVpcDetails)((AwsRoute53HostedZoneVpcDetails.Builder)AwsRoute53HostedZoneVpcDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getNameServers() {
            if (this.nameServers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nameServers;
        }

        public final void setNameServers(Collection<String> nameServers) {
            this.nameServers = AwsRoute53HostedZoneNameServersListCopier.copy(nameServers);
        }

        @Override
        public final Builder nameServers(Collection<String> nameServers) {
            this.nameServers = AwsRoute53HostedZoneNameServersListCopier.copy(nameServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameServers(String ... nameServers) {
            this.nameServers(Arrays.asList(nameServers));
            return this;
        }

        public final AwsRoute53QueryLoggingConfigDetails.Builder getQueryLoggingConfig() {
            return this.queryLoggingConfig != null ? this.queryLoggingConfig.toBuilder() : null;
        }

        public final void setQueryLoggingConfig(AwsRoute53QueryLoggingConfigDetails.BuilderImpl queryLoggingConfig) {
            this.queryLoggingConfig = queryLoggingConfig != null ? queryLoggingConfig.build() : null;
        }

        @Override
        public final Builder queryLoggingConfig(AwsRoute53QueryLoggingConfigDetails queryLoggingConfig) {
            this.queryLoggingConfig = queryLoggingConfig;
            return this;
        }

        public AwsRoute53HostedZoneDetails build() {
            return new AwsRoute53HostedZoneDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsRoute53HostedZoneDetails> {
        public Builder hostedZone(AwsRoute53HostedZoneObjectDetails var1);

        default public Builder hostedZone(Consumer<AwsRoute53HostedZoneObjectDetails.Builder> hostedZone) {
            return this.hostedZone((AwsRoute53HostedZoneObjectDetails)((AwsRoute53HostedZoneObjectDetails.Builder)AwsRoute53HostedZoneObjectDetails.builder().applyMutation(hostedZone)).build());
        }

        public Builder vpcs(Collection<AwsRoute53HostedZoneVpcDetails> var1);

        public Builder vpcs(AwsRoute53HostedZoneVpcDetails ... var1);

        public Builder vpcs(Consumer<AwsRoute53HostedZoneVpcDetails.Builder> ... var1);

        public Builder nameServers(Collection<String> var1);

        public Builder nameServers(String ... var1);

        public Builder queryLoggingConfig(AwsRoute53QueryLoggingConfigDetails var1);

        default public Builder queryLoggingConfig(Consumer<AwsRoute53QueryLoggingConfigDetails.Builder> queryLoggingConfig) {
            return this.queryLoggingConfig((AwsRoute53QueryLoggingConfigDetails)((AwsRoute53QueryLoggingConfigDetails.Builder)AwsRoute53QueryLoggingConfigDetails.builder().applyMutation(queryLoggingConfig)).build());
        }
    }
}

