/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.EnabledStandardIdentifierListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityControlsConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityHubPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityHubPolicy> {
    private static final SdkField<Boolean> SERVICE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ServiceEnabled").getter(SecurityHubPolicy.getter(SecurityHubPolicy::serviceEnabled)).setter(SecurityHubPolicy.setter(Builder::serviceEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceEnabled").build()}).build();
    private static final SdkField<List<String>> ENABLED_STANDARD_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnabledStandardIdentifiers").getter(SecurityHubPolicy.getter(SecurityHubPolicy::enabledStandardIdentifiers)).setter(SecurityHubPolicy.setter(Builder::enabledStandardIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledStandardIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SecurityControlsConfiguration> SECURITY_CONTROLS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityControlsConfiguration").getter(SecurityHubPolicy.getter(SecurityHubPolicy::securityControlsConfiguration)).setter(SecurityHubPolicy.setter(Builder::securityControlsConfiguration)).constructor(SecurityControlsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlsConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ENABLED_FIELD, ENABLED_STANDARD_IDENTIFIERS_FIELD, SECURITY_CONTROLS_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean serviceEnabled;
    private final List<String> enabledStandardIdentifiers;
    private final SecurityControlsConfiguration securityControlsConfiguration;

    private SecurityHubPolicy(BuilderImpl builder) {
        this.serviceEnabled = builder.serviceEnabled;
        this.enabledStandardIdentifiers = builder.enabledStandardIdentifiers;
        this.securityControlsConfiguration = builder.securityControlsConfiguration;
    }

    public final Boolean serviceEnabled() {
        return this.serviceEnabled;
    }

    public final boolean hasEnabledStandardIdentifiers() {
        return this.enabledStandardIdentifiers != null && !(this.enabledStandardIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> enabledStandardIdentifiers() {
        return this.enabledStandardIdentifiers;
    }

    public final SecurityControlsConfiguration securityControlsConfiguration() {
        return this.securityControlsConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledStandardIdentifiers() ? this.enabledStandardIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.securityControlsConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityHubPolicy)) {
            return false;
        }
        SecurityHubPolicy other = (SecurityHubPolicy)obj;
        return Objects.equals(this.serviceEnabled(), other.serviceEnabled()) && this.hasEnabledStandardIdentifiers() == other.hasEnabledStandardIdentifiers() && Objects.equals(this.enabledStandardIdentifiers(), other.enabledStandardIdentifiers()) && Objects.equals(this.securityControlsConfiguration(), other.securityControlsConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityHubPolicy").add("ServiceEnabled", (Object)this.serviceEnabled()).add("EnabledStandardIdentifiers", this.hasEnabledStandardIdentifiers() ? this.enabledStandardIdentifiers() : null).add("SecurityControlsConfiguration", (Object)this.securityControlsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceEnabled": {
                return Optional.ofNullable(clazz.cast(this.serviceEnabled()));
            }
            case "EnabledStandardIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.enabledStandardIdentifiers()));
            }
            case "SecurityControlsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityControlsConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityHubPolicy, T> g) {
        return obj -> g.apply((SecurityHubPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean serviceEnabled;
        private List<String> enabledStandardIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private SecurityControlsConfiguration securityControlsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityHubPolicy model) {
            this.serviceEnabled(model.serviceEnabled);
            this.enabledStandardIdentifiers(model.enabledStandardIdentifiers);
            this.securityControlsConfiguration(model.securityControlsConfiguration);
        }

        public final Boolean getServiceEnabled() {
            return this.serviceEnabled;
        }

        public final void setServiceEnabled(Boolean serviceEnabled) {
            this.serviceEnabled = serviceEnabled;
        }

        @Override
        public final Builder serviceEnabled(Boolean serviceEnabled) {
            this.serviceEnabled = serviceEnabled;
            return this;
        }

        public final Collection<String> getEnabledStandardIdentifiers() {
            if (this.enabledStandardIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledStandardIdentifiers;
        }

        public final void setEnabledStandardIdentifiers(Collection<String> enabledStandardIdentifiers) {
            this.enabledStandardIdentifiers = EnabledStandardIdentifierListCopier.copy(enabledStandardIdentifiers);
        }

        @Override
        public final Builder enabledStandardIdentifiers(Collection<String> enabledStandardIdentifiers) {
            this.enabledStandardIdentifiers = EnabledStandardIdentifierListCopier.copy(enabledStandardIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledStandardIdentifiers(String ... enabledStandardIdentifiers) {
            this.enabledStandardIdentifiers(Arrays.asList(enabledStandardIdentifiers));
            return this;
        }

        public final SecurityControlsConfiguration.Builder getSecurityControlsConfiguration() {
            return this.securityControlsConfiguration != null ? this.securityControlsConfiguration.toBuilder() : null;
        }

        public final void setSecurityControlsConfiguration(SecurityControlsConfiguration.BuilderImpl securityControlsConfiguration) {
            this.securityControlsConfiguration = securityControlsConfiguration != null ? securityControlsConfiguration.build() : null;
        }

        @Override
        public final Builder securityControlsConfiguration(SecurityControlsConfiguration securityControlsConfiguration) {
            this.securityControlsConfiguration = securityControlsConfiguration;
            return this;
        }

        public SecurityHubPolicy build() {
            return new SecurityHubPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityHubPolicy> {
        public Builder serviceEnabled(Boolean var1);

        public Builder enabledStandardIdentifiers(Collection<String> var1);

        public Builder enabledStandardIdentifiers(String ... var1);

        public Builder securityControlsConfiguration(SecurityControlsConfiguration var1);

        default public Builder securityControlsConfiguration(Consumer<SecurityControlsConfiguration.Builder> securityControlsConfiguration) {
            return this.securityControlsConfiguration((SecurityControlsConfiguration)((SecurityControlsConfiguration.Builder)SecurityControlsConfiguration.builder().applyMutation(securityControlsConfiguration)).build());
        }
    }
}

