/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectionDirection {
    INBOUND("INBOUND"),
    OUTBOUND("OUTBOUND"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectionDirection> VALUE_MAP;
    private final String value;

    private ConnectionDirection(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectionDirection fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectionDirection> knownValues() {
        EnumSet<ConnectionDirection> knownValues = EnumSet.allOf(ConnectionDirection.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectionDirection.class, ConnectionDirection::toString);
    }
}

