/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnumListConfigurationOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnumListConfigurationOptions> {
    private static final SdkField<List<String>> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DefaultValue").getter(EnumListConfigurationOptions.getter(EnumListConfigurationOptions::defaultValue)).setter(EnumListConfigurationOptions.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(EnumListConfigurationOptions.getter(EnumListConfigurationOptions::maxItems)).setter(EnumListConfigurationOptions.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedValues").getter(EnumListConfigurationOptions.getter(EnumListConfigurationOptions::allowedValues)).setter(EnumListConfigurationOptions.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD, MAX_ITEMS_FIELD, ALLOWED_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnumListConfigurationOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> defaultValue;
    private final Integer maxItems;
    private final List<String> allowedValues;

    private EnumListConfigurationOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.maxItems = builder.maxItems;
        this.allowedValues = builder.allowedValues;
    }

    public final boolean hasDefaultValue() {
        return this.defaultValue != null && !(this.defaultValue instanceof SdkAutoConstructList);
    }

    public final List<String> defaultValue() {
        return this.defaultValue;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final boolean hasAllowedValues() {
        return this.allowedValues != null && !(this.allowedValues instanceof SdkAutoConstructList);
    }

    public final List<String> allowedValues() {
        return this.allowedValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultValue() ? this.defaultValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedValues() ? this.allowedValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnumListConfigurationOptions)) {
            return false;
        }
        EnumListConfigurationOptions other = (EnumListConfigurationOptions)obj;
        return this.hasDefaultValue() == other.hasDefaultValue() && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.maxItems(), other.maxItems()) && this.hasAllowedValues() == other.hasAllowedValues() && Objects.equals(this.allowedValues(), other.allowedValues());
    }

    public final String toString() {
        return ToString.builder((String)"EnumListConfigurationOptions").add("DefaultValue", this.hasDefaultValue() ? this.defaultValue() : null).add("MaxItems", (Object)this.maxItems()).add("AllowedValues", this.hasAllowedValues() ? this.allowedValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "AllowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("AllowedValues", ALLOWED_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnumListConfigurationOptions, T> g) {
        return obj -> g.apply((EnumListConfigurationOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> defaultValue = DefaultSdkAutoConstructList.getInstance();
        private Integer maxItems;
        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnumListConfigurationOptions model) {
            this.defaultValue(model.defaultValue);
            this.maxItems(model.maxItems);
            this.allowedValues(model.allowedValues);
        }

        public final Collection<String> getDefaultValue() {
            if (this.defaultValue instanceof SdkAutoConstructList) {
                return null;
            }
            return this.defaultValue;
        }

        public final void setDefaultValue(Collection<String> defaultValue) {
            this.defaultValue = StringListCopier.copy(defaultValue);
        }

        @Override
        public final Builder defaultValue(Collection<String> defaultValue) {
            this.defaultValue = StringListCopier.copy(defaultValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultValue(String ... defaultValue) {
            this.defaultValue(Arrays.asList(defaultValue));
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final Collection<String> getAllowedValues() {
            if (this.allowedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedValues;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = StringListCopier.copy(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = StringListCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public EnumListConfigurationOptions build() {
            return new EnumListConfigurationOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnumListConfigurationOptions> {
        public Builder defaultValue(Collection<String> var1);

        public Builder defaultValue(String ... var1);

        public Builder maxItems(Integer var1);

        public Builder allowedValues(Collection<String> var1);

        public Builder allowedValues(String ... var1);
    }
}

