/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AllowedOperators;
import software.amazon.awssdk.services.securityhub.model.FindingsTrendsCompositeFilter;
import software.amazon.awssdk.services.securityhub.model.FindingsTrendsCompositeFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingsTrendsFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingsTrendsFilters> {
    private static final SdkField<List<FindingsTrendsCompositeFilter>> COMPOSITE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CompositeFilters").getter(FindingsTrendsFilters.getter(FindingsTrendsFilters::compositeFilters)).setter(FindingsTrendsFilters.setter(Builder::compositeFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositeFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingsTrendsCompositeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COMPOSITE_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompositeOperator").getter(FindingsTrendsFilters.getter(FindingsTrendsFilters::compositeOperatorAsString)).setter(FindingsTrendsFilters.setter(Builder::compositeOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositeOperator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPOSITE_FILTERS_FIELD, COMPOSITE_OPERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FindingsTrendsFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<FindingsTrendsCompositeFilter> compositeFilters;
    private final String compositeOperator;

    private FindingsTrendsFilters(BuilderImpl builder) {
        this.compositeFilters = builder.compositeFilters;
        this.compositeOperator = builder.compositeOperator;
    }

    public final boolean hasCompositeFilters() {
        return this.compositeFilters != null && !(this.compositeFilters instanceof SdkAutoConstructList);
    }

    public final List<FindingsTrendsCompositeFilter> compositeFilters() {
        return this.compositeFilters;
    }

    public final AllowedOperators compositeOperator() {
        return AllowedOperators.fromValue(this.compositeOperator);
    }

    public final String compositeOperatorAsString() {
        return this.compositeOperator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompositeFilters() ? this.compositeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.compositeOperatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingsTrendsFilters)) {
            return false;
        }
        FindingsTrendsFilters other = (FindingsTrendsFilters)obj;
        return this.hasCompositeFilters() == other.hasCompositeFilters() && Objects.equals(this.compositeFilters(), other.compositeFilters()) && Objects.equals(this.compositeOperatorAsString(), other.compositeOperatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FindingsTrendsFilters").add("CompositeFilters", this.hasCompositeFilters() ? this.compositeFilters() : null).add("CompositeOperator", (Object)this.compositeOperatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompositeFilters": {
                return Optional.ofNullable(clazz.cast(this.compositeFilters()));
            }
            case "CompositeOperator": {
                return Optional.ofNullable(clazz.cast(this.compositeOperatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CompositeFilters", COMPOSITE_FILTERS_FIELD);
        map.put("CompositeOperator", COMPOSITE_OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingsTrendsFilters, T> g) {
        return obj -> g.apply((FindingsTrendsFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FindingsTrendsCompositeFilter> compositeFilters = DefaultSdkAutoConstructList.getInstance();
        private String compositeOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingsTrendsFilters model) {
            this.compositeFilters(model.compositeFilters);
            this.compositeOperator(model.compositeOperator);
        }

        public final List<FindingsTrendsCompositeFilter.Builder> getCompositeFilters() {
            List<FindingsTrendsCompositeFilter.Builder> result = FindingsTrendsCompositeFilterListCopier.copyToBuilder(this.compositeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCompositeFilters(Collection<FindingsTrendsCompositeFilter.BuilderImpl> compositeFilters) {
            this.compositeFilters = FindingsTrendsCompositeFilterListCopier.copyFromBuilder(compositeFilters);
        }

        @Override
        public final Builder compositeFilters(Collection<FindingsTrendsCompositeFilter> compositeFilters) {
            this.compositeFilters = FindingsTrendsCompositeFilterListCopier.copy(compositeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compositeFilters(FindingsTrendsCompositeFilter ... compositeFilters) {
            this.compositeFilters(Arrays.asList(compositeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compositeFilters(Consumer<FindingsTrendsCompositeFilter.Builder> ... compositeFilters) {
            this.compositeFilters(Stream.of(compositeFilters).map(c -> (FindingsTrendsCompositeFilter)((FindingsTrendsCompositeFilter.Builder)FindingsTrendsCompositeFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCompositeOperator() {
            return this.compositeOperator;
        }

        public final void setCompositeOperator(String compositeOperator) {
            this.compositeOperator = compositeOperator;
        }

        @Override
        public final Builder compositeOperator(String compositeOperator) {
            this.compositeOperator = compositeOperator;
            return this;
        }

        @Override
        public final Builder compositeOperator(AllowedOperators compositeOperator) {
            this.compositeOperator(compositeOperator == null ? null : compositeOperator.toString());
            return this;
        }

        public FindingsTrendsFilters build() {
            return new FindingsTrendsFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingsTrendsFilters> {
        public Builder compositeFilters(Collection<FindingsTrendsCompositeFilter> var1);

        public Builder compositeFilters(FindingsTrendsCompositeFilter ... var1);

        public Builder compositeFilters(Consumer<FindingsTrendsCompositeFilter.Builder> ... var1);

        public Builder compositeOperator(String var1);

        public Builder compositeOperator(AllowedOperators var1);
    }
}

