/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GroupByField {
    ACTIVITY_NAME("activity_name"),
    CLOUD_ACCOUNT_UID("cloud.account.uid"),
    CLOUD_PROVIDER("cloud.provider"),
    CLOUD_REGION("cloud.region"),
    COMPLIANCE_ASSESSMENTS_NAME("compliance.assessments.name"),
    COMPLIANCE_STATUS("compliance.status"),
    COMPLIANCE_CONTROL("compliance.control"),
    FINDING_INFO_TITLE("finding_info.title"),
    FINDING_INFO_RELATED_EVENTS_TRAITS_CATEGORY("finding_info.related_events.traits.category"),
    FINDING_INFO_TYPES("finding_info.types"),
    METADATA_PRODUCT_NAME("metadata.product.name"),
    METADATA_PRODUCT_UID("metadata.product.uid"),
    RESOURCES_TYPE("resources.type"),
    RESOURCES_UID("resources.uid"),
    SEVERITY("severity"),
    STATUS("status"),
    VULNERABILITIES_FIX_COVERAGE("vulnerabilities.fix_coverage"),
    CLASS_NAME("class_name"),
    VULNERABILITIES_AFFECTED_PACKAGES_NAME("vulnerabilities.affected_packages.name"),
    FINDING_INFO_ANALYTIC_NAME("finding_info.analytic.name"),
    COMPLIANCE_STANDARDS("compliance.standards"),
    CLOUD_ACCOUNT_NAME("cloud.account.name"),
    VENDOR_ATTRIBUTES_SEVERITY("vendor_attributes.severity"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GroupByField> VALUE_MAP;
    private final String value;

    private GroupByField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GroupByField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GroupByField> knownValues() {
        EnumSet<GroupByField> knownValues = EnumSet.allOf(GroupByField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GroupByField.class, GroupByField::toString);
    }
}

