/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.ConnectorStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HealthCheck
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HealthCheck> {
    private static final SdkField<String> CONNECTOR_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorStatus").getter(HealthCheck.getter(HealthCheck::connectorStatusAsString)).setter(HealthCheck.setter(Builder::connectorStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorStatus").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(HealthCheck.getter(HealthCheck::message)).setter(HealthCheck.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> LAST_CHECKED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastCheckedAt").getter(HealthCheck.getter(HealthCheck::lastCheckedAt)).setter(HealthCheck.setter(Builder::lastCheckedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastCheckedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_STATUS_FIELD, MESSAGE_FIELD, LAST_CHECKED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HealthCheck.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectorStatus;
    private final String message;
    private final Instant lastCheckedAt;

    private HealthCheck(BuilderImpl builder) {
        this.connectorStatus = builder.connectorStatus;
        this.message = builder.message;
        this.lastCheckedAt = builder.lastCheckedAt;
    }

    public final ConnectorStatus connectorStatus() {
        return ConnectorStatus.fromValue(this.connectorStatus);
    }

    public final String connectorStatusAsString() {
        return this.connectorStatus;
    }

    public final String message() {
        return this.message;
    }

    public final Instant lastCheckedAt() {
        return this.lastCheckedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastCheckedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheck)) {
            return false;
        }
        HealthCheck other = (HealthCheck)obj;
        return Objects.equals(this.connectorStatusAsString(), other.connectorStatusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.lastCheckedAt(), other.lastCheckedAt());
    }

    public final String toString() {
        return ToString.builder((String)"HealthCheck").add("ConnectorStatus", (Object)this.connectorStatusAsString()).add("Message", (Object)this.message()).add("LastCheckedAt", (Object)this.lastCheckedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorStatus": {
                return Optional.ofNullable(clazz.cast(this.connectorStatusAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "LastCheckedAt": {
                return Optional.ofNullable(clazz.cast(this.lastCheckedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectorStatus", CONNECTOR_STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("LastCheckedAt", LAST_CHECKED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HealthCheck, T> g) {
        return obj -> g.apply((HealthCheck)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectorStatus;
        private String message;
        private Instant lastCheckedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheck model) {
            this.connectorStatus(model.connectorStatus);
            this.message(model.message);
            this.lastCheckedAt(model.lastCheckedAt);
        }

        public final String getConnectorStatus() {
            return this.connectorStatus;
        }

        public final void setConnectorStatus(String connectorStatus) {
            this.connectorStatus = connectorStatus;
        }

        @Override
        public final Builder connectorStatus(String connectorStatus) {
            this.connectorStatus = connectorStatus;
            return this;
        }

        @Override
        public final Builder connectorStatus(ConnectorStatus connectorStatus) {
            this.connectorStatus(connectorStatus == null ? null : connectorStatus.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getLastCheckedAt() {
            return this.lastCheckedAt;
        }

        public final void setLastCheckedAt(Instant lastCheckedAt) {
            this.lastCheckedAt = lastCheckedAt;
        }

        @Override
        public final Builder lastCheckedAt(Instant lastCheckedAt) {
            this.lastCheckedAt = lastCheckedAt;
            return this;
        }

        public HealthCheck build() {
            return new HealthCheck(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HealthCheck> {
        public Builder connectorStatus(String var1);

        public Builder connectorStatus(ConnectorStatus var1);

        public Builder message(String var1);

        public Builder lastCheckedAt(Instant var1);
    }
}

