/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntegerConfigurationOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntegerConfigurationOptions> {
    private static final SdkField<Integer> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultValue").getter(IntegerConfigurationOptions.getter(IntegerConfigurationOptions::defaultValue)).setter(IntegerConfigurationOptions.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<Integer> MIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Min").getter(IntegerConfigurationOptions.getter(IntegerConfigurationOptions::min)).setter(IntegerConfigurationOptions.setter(Builder::min)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Min").build()}).build();
    private static final SdkField<Integer> MAX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Max").getter(IntegerConfigurationOptions.getter(IntegerConfigurationOptions::max)).setter(IntegerConfigurationOptions.setter(Builder::max)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD, MIN_FIELD, MAX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IntegerConfigurationOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer defaultValue;
    private final Integer min;
    private final Integer max;

    private IntegerConfigurationOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.min = builder.min;
        this.max = builder.max;
    }

    public final Integer defaultValue() {
        return this.defaultValue;
    }

    public final Integer min() {
        return this.min;
    }

    public final Integer max() {
        return this.max;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.min());
        hashCode = 31 * hashCode + Objects.hashCode(this.max());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegerConfigurationOptions)) {
            return false;
        }
        IntegerConfigurationOptions other = (IntegerConfigurationOptions)obj;
        return Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.min(), other.min()) && Objects.equals(this.max(), other.max());
    }

    public final String toString() {
        return ToString.builder((String)"IntegerConfigurationOptions").add("DefaultValue", (Object)this.defaultValue()).add("Min", (Object)this.min()).add("Max", (Object)this.max()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "Min": {
                return Optional.ofNullable(clazz.cast(this.min()));
            }
            case "Max": {
                return Optional.ofNullable(clazz.cast(this.max()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("Min", MIN_FIELD);
        map.put("Max", MAX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntegerConfigurationOptions, T> g) {
        return obj -> g.apply((IntegerConfigurationOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer defaultValue;
        private Integer min;
        private Integer max;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegerConfigurationOptions model) {
            this.defaultValue(model.defaultValue);
            this.min(model.min);
            this.max(model.max);
        }

        public final Integer getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(Integer defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(Integer defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Integer getMin() {
            return this.min;
        }

        public final void setMin(Integer min) {
            this.min = min;
        }

        @Override
        public final Builder min(Integer min) {
            this.min = min;
            return this;
        }

        public final Integer getMax() {
            return this.max;
        }

        public final void setMax(Integer max) {
            this.max = max;
        }

        @Override
        public final Builder max(Integer max) {
            this.max = max;
            return this;
        }

        public IntegerConfigurationOptions build() {
            return new IntegerConfigurationOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntegerConfigurationOptions> {
        public Builder defaultValue(Integer var1);

        public Builder min(Integer var1);

        public Builder max(Integer var1);
    }
}

