/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AggregatorV2;
import software.amazon.awssdk.services.securityhub.model.AggregatorV2ListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAggregatorsV2Response
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, ListAggregatorsV2Response> {
    private static final SdkField<List<AggregatorV2>> AGGREGATORS_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AggregatorsV2").getter(ListAggregatorsV2Response.getter(ListAggregatorsV2Response::aggregatorsV2)).setter(ListAggregatorsV2Response.setter(Builder::aggregatorsV2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatorsV2").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregatorV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAggregatorsV2Response.getter(ListAggregatorsV2Response::nextToken)).setter(ListAggregatorsV2Response.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATORS_V2_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAggregatorsV2Response.memberNameToFieldInitializer();
    private final List<AggregatorV2> aggregatorsV2;
    private final String nextToken;

    private ListAggregatorsV2Response(BuilderImpl builder) {
        super(builder);
        this.aggregatorsV2 = builder.aggregatorsV2;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAggregatorsV2() {
        return this.aggregatorsV2 != null && !(this.aggregatorsV2 instanceof SdkAutoConstructList);
    }

    public final List<AggregatorV2> aggregatorsV2() {
        return this.aggregatorsV2;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregatorsV2() ? this.aggregatorsV2() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAggregatorsV2Response)) {
            return false;
        }
        ListAggregatorsV2Response other = (ListAggregatorsV2Response)((Object)obj);
        return this.hasAggregatorsV2() == other.hasAggregatorsV2() && Objects.equals(this.aggregatorsV2(), other.aggregatorsV2()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAggregatorsV2Response").add("AggregatorsV2", this.hasAggregatorsV2() ? this.aggregatorsV2() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AggregatorsV2": {
                return Optional.ofNullable(clazz.cast(this.aggregatorsV2()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AggregatorsV2", AGGREGATORS_V2_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAggregatorsV2Response, T> g) {
        return obj -> g.apply((ListAggregatorsV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<AggregatorV2> aggregatorsV2 = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAggregatorsV2Response model) {
            super(model);
            this.aggregatorsV2(model.aggregatorsV2);
            this.nextToken(model.nextToken);
        }

        public final List<AggregatorV2.Builder> getAggregatorsV2() {
            List<AggregatorV2.Builder> result = AggregatorV2ListCopier.copyToBuilder(this.aggregatorsV2);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregatorsV2(Collection<AggregatorV2.BuilderImpl> aggregatorsV2) {
            this.aggregatorsV2 = AggregatorV2ListCopier.copyFromBuilder(aggregatorsV2);
        }

        @Override
        public final Builder aggregatorsV2(Collection<AggregatorV2> aggregatorsV2) {
            this.aggregatorsV2 = AggregatorV2ListCopier.copy(aggregatorsV2);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatorsV2(AggregatorV2 ... aggregatorsV2) {
            this.aggregatorsV2(Arrays.asList(aggregatorsV2));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatorsV2(Consumer<AggregatorV2.Builder> ... aggregatorsV2) {
            this.aggregatorsV2(Stream.of(aggregatorsV2).map(c -> (AggregatorV2)((AggregatorV2.Builder)AggregatorV2.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAggregatorsV2Response build() {
            return new ListAggregatorsV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAggregatorsV2Response> {
        public Builder aggregatorsV2(Collection<AggregatorV2> var1);

        public Builder aggregatorsV2(AggregatorV2 ... var1);

        public Builder aggregatorsV2(Consumer<AggregatorV2.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

