/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OcsfIpField {
    EVIDENCES_DST_ENDPOINT_IP("evidences.dst_endpoint.ip"),
    EVIDENCES_SRC_ENDPOINT_IP("evidences.src_endpoint.ip"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OcsfIpField> VALUE_MAP;
    private final String value;

    private OcsfIpField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OcsfIpField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OcsfIpField> knownValues() {
        EnumSet<OcsfIpField> knownValues = EnumSet.allOf(OcsfIpField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OcsfIpField.class, OcsfIpField::toString);
    }
}

