/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.RuleGroupSourceListDetails;
import software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesDetails;
import software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatefulRulesListCopier;
import software.amazon.awssdk.services.securityhub.model.RuleGroupSourceStatelessRulesAndCustomActionsDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleGroupSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleGroupSource> {
    private static final SdkField<RuleGroupSourceListDetails> RULES_SOURCE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RulesSourceList").getter(RuleGroupSource.getter(RuleGroupSource::rulesSourceList)).setter(RuleGroupSource.setter(Builder::rulesSourceList)).constructor(RuleGroupSourceListDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesSourceList").build()}).build();
    private static final SdkField<String> RULES_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RulesString").getter(RuleGroupSource.getter(RuleGroupSource::rulesString)).setter(RuleGroupSource.setter(Builder::rulesString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesString").build()}).build();
    private static final SdkField<List<RuleGroupSourceStatefulRulesDetails>> STATEFUL_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatefulRules").getter(RuleGroupSource.getter(RuleGroupSource::statefulRules)).setter(RuleGroupSource.setter(Builder::statefulRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatefulRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleGroupSourceStatefulRulesDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RuleGroupSourceStatelessRulesAndCustomActionsDetails> STATELESS_RULES_AND_CUSTOM_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatelessRulesAndCustomActions").getter(RuleGroupSource.getter(RuleGroupSource::statelessRulesAndCustomActions)).setter(RuleGroupSource.setter(Builder::statelessRulesAndCustomActions)).constructor(RuleGroupSourceStatelessRulesAndCustomActionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatelessRulesAndCustomActions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_SOURCE_LIST_FIELD, RULES_STRING_FIELD, STATEFUL_RULES_FIELD, STATELESS_RULES_AND_CUSTOM_ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleGroupSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RuleGroupSourceListDetails rulesSourceList;
    private final String rulesString;
    private final List<RuleGroupSourceStatefulRulesDetails> statefulRules;
    private final RuleGroupSourceStatelessRulesAndCustomActionsDetails statelessRulesAndCustomActions;

    private RuleGroupSource(BuilderImpl builder) {
        this.rulesSourceList = builder.rulesSourceList;
        this.rulesString = builder.rulesString;
        this.statefulRules = builder.statefulRules;
        this.statelessRulesAndCustomActions = builder.statelessRulesAndCustomActions;
    }

    public final RuleGroupSourceListDetails rulesSourceList() {
        return this.rulesSourceList;
    }

    public final String rulesString() {
        return this.rulesString;
    }

    public final boolean hasStatefulRules() {
        return this.statefulRules != null && !(this.statefulRules instanceof SdkAutoConstructList);
    }

    public final List<RuleGroupSourceStatefulRulesDetails> statefulRules() {
        return this.statefulRules;
    }

    public final RuleGroupSourceStatelessRulesAndCustomActionsDetails statelessRulesAndCustomActions() {
        return this.statelessRulesAndCustomActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rulesSourceList());
        hashCode = 31 * hashCode + Objects.hashCode(this.rulesString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatefulRules() ? this.statefulRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statelessRulesAndCustomActions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSource)) {
            return false;
        }
        RuleGroupSource other = (RuleGroupSource)obj;
        return Objects.equals(this.rulesSourceList(), other.rulesSourceList()) && Objects.equals(this.rulesString(), other.rulesString()) && this.hasStatefulRules() == other.hasStatefulRules() && Objects.equals(this.statefulRules(), other.statefulRules()) && Objects.equals(this.statelessRulesAndCustomActions(), other.statelessRulesAndCustomActions());
    }

    public final String toString() {
        return ToString.builder((String)"RuleGroupSource").add("RulesSourceList", (Object)this.rulesSourceList()).add("RulesString", (Object)this.rulesString()).add("StatefulRules", this.hasStatefulRules() ? this.statefulRules() : null).add("StatelessRulesAndCustomActions", (Object)this.statelessRulesAndCustomActions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RulesSourceList": {
                return Optional.ofNullable(clazz.cast(this.rulesSourceList()));
            }
            case "RulesString": {
                return Optional.ofNullable(clazz.cast(this.rulesString()));
            }
            case "StatefulRules": {
                return Optional.ofNullable(clazz.cast(this.statefulRules()));
            }
            case "StatelessRulesAndCustomActions": {
                return Optional.ofNullable(clazz.cast(this.statelessRulesAndCustomActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RulesSourceList", RULES_SOURCE_LIST_FIELD);
        map.put("RulesString", RULES_STRING_FIELD);
        map.put("StatefulRules", STATEFUL_RULES_FIELD);
        map.put("StatelessRulesAndCustomActions", STATELESS_RULES_AND_CUSTOM_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSource, T> g) {
        return obj -> g.apply((RuleGroupSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RuleGroupSourceListDetails rulesSourceList;
        private String rulesString;
        private List<RuleGroupSourceStatefulRulesDetails> statefulRules = DefaultSdkAutoConstructList.getInstance();
        private RuleGroupSourceStatelessRulesAndCustomActionsDetails statelessRulesAndCustomActions;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSource model) {
            this.rulesSourceList(model.rulesSourceList);
            this.rulesString(model.rulesString);
            this.statefulRules(model.statefulRules);
            this.statelessRulesAndCustomActions(model.statelessRulesAndCustomActions);
        }

        public final RuleGroupSourceListDetails.Builder getRulesSourceList() {
            return this.rulesSourceList != null ? this.rulesSourceList.toBuilder() : null;
        }

        public final void setRulesSourceList(RuleGroupSourceListDetails.BuilderImpl rulesSourceList) {
            this.rulesSourceList = rulesSourceList != null ? rulesSourceList.build() : null;
        }

        @Override
        public final Builder rulesSourceList(RuleGroupSourceListDetails rulesSourceList) {
            this.rulesSourceList = rulesSourceList;
            return this;
        }

        public final String getRulesString() {
            return this.rulesString;
        }

        public final void setRulesString(String rulesString) {
            this.rulesString = rulesString;
        }

        @Override
        public final Builder rulesString(String rulesString) {
            this.rulesString = rulesString;
            return this;
        }

        public final List<RuleGroupSourceStatefulRulesDetails.Builder> getStatefulRules() {
            List<RuleGroupSourceStatefulRulesDetails.Builder> result = RuleGroupSourceStatefulRulesListCopier.copyToBuilder(this.statefulRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatefulRules(Collection<RuleGroupSourceStatefulRulesDetails.BuilderImpl> statefulRules) {
            this.statefulRules = RuleGroupSourceStatefulRulesListCopier.copyFromBuilder(statefulRules);
        }

        @Override
        public final Builder statefulRules(Collection<RuleGroupSourceStatefulRulesDetails> statefulRules) {
            this.statefulRules = RuleGroupSourceStatefulRulesListCopier.copy(statefulRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulRules(RuleGroupSourceStatefulRulesDetails ... statefulRules) {
            this.statefulRules(Arrays.asList(statefulRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statefulRules(Consumer<RuleGroupSourceStatefulRulesDetails.Builder> ... statefulRules) {
            this.statefulRules(Stream.of(statefulRules).map(c -> (RuleGroupSourceStatefulRulesDetails)((RuleGroupSourceStatefulRulesDetails.Builder)RuleGroupSourceStatefulRulesDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RuleGroupSourceStatelessRulesAndCustomActionsDetails.Builder getStatelessRulesAndCustomActions() {
            return this.statelessRulesAndCustomActions != null ? this.statelessRulesAndCustomActions.toBuilder() : null;
        }

        public final void setStatelessRulesAndCustomActions(RuleGroupSourceStatelessRulesAndCustomActionsDetails.BuilderImpl statelessRulesAndCustomActions) {
            this.statelessRulesAndCustomActions = statelessRulesAndCustomActions != null ? statelessRulesAndCustomActions.build() : null;
        }

        @Override
        public final Builder statelessRulesAndCustomActions(RuleGroupSourceStatelessRulesAndCustomActionsDetails statelessRulesAndCustomActions) {
            this.statelessRulesAndCustomActions = statelessRulesAndCustomActions;
            return this;
        }

        public RuleGroupSource build() {
            return new RuleGroupSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleGroupSource> {
        public Builder rulesSourceList(RuleGroupSourceListDetails var1);

        default public Builder rulesSourceList(Consumer<RuleGroupSourceListDetails.Builder> rulesSourceList) {
            return this.rulesSourceList((RuleGroupSourceListDetails)((RuleGroupSourceListDetails.Builder)RuleGroupSourceListDetails.builder().applyMutation(rulesSourceList)).build());
        }

        public Builder rulesString(String var1);

        public Builder statefulRules(Collection<RuleGroupSourceStatefulRulesDetails> var1);

        public Builder statefulRules(RuleGroupSourceStatefulRulesDetails ... var1);

        public Builder statefulRules(Consumer<RuleGroupSourceStatefulRulesDetails.Builder> ... var1);

        public Builder statelessRulesAndCustomActions(RuleGroupSourceStatelessRulesAndCustomActionsDetails var1);

        default public Builder statelessRulesAndCustomActions(Consumer<RuleGroupSourceStatelessRulesAndCustomActionsDetails.Builder> statelessRulesAndCustomActions) {
            return this.statelessRulesAndCustomActions((RuleGroupSourceStatelessRulesAndCustomActionsDetails)((RuleGroupSourceStatelessRulesAndCustomActionsDetails.Builder)RuleGroupSourceStatelessRulesAndCustomActionsDetails.builder().applyMutation(statelessRulesAndCustomActions)).build());
        }
    }
}

