/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.DisabledSecurityControlIdentifierListCopier;
import software.amazon.awssdk.services.securityhub.model.EnabledSecurityControlIdentifierListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityControlCustomParameter;
import software.amazon.awssdk.services.securityhub.model.SecurityControlCustomParametersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityControlsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityControlsConfiguration> {
    private static final SdkField<List<String>> ENABLED_SECURITY_CONTROL_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnabledSecurityControlIdentifiers").getter(SecurityControlsConfiguration.getter(SecurityControlsConfiguration::enabledSecurityControlIdentifiers)).setter(SecurityControlsConfiguration.setter(Builder::enabledSecurityControlIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledSecurityControlIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DISABLED_SECURITY_CONTROL_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DisabledSecurityControlIdentifiers").getter(SecurityControlsConfiguration.getter(SecurityControlsConfiguration::disabledSecurityControlIdentifiers)).setter(SecurityControlsConfiguration.setter(Builder::disabledSecurityControlIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledSecurityControlIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SecurityControlCustomParameter>> SECURITY_CONTROL_CUSTOM_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityControlCustomParameters").getter(SecurityControlsConfiguration.getter(SecurityControlsConfiguration::securityControlCustomParameters)).setter(SecurityControlsConfiguration.setter(Builder::securityControlCustomParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlCustomParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityControlCustomParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_SECURITY_CONTROL_IDENTIFIERS_FIELD, DISABLED_SECURITY_CONTROL_IDENTIFIERS_FIELD, SECURITY_CONTROL_CUSTOM_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SecurityControlsConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> enabledSecurityControlIdentifiers;
    private final List<String> disabledSecurityControlIdentifiers;
    private final List<SecurityControlCustomParameter> securityControlCustomParameters;

    private SecurityControlsConfiguration(BuilderImpl builder) {
        this.enabledSecurityControlIdentifiers = builder.enabledSecurityControlIdentifiers;
        this.disabledSecurityControlIdentifiers = builder.disabledSecurityControlIdentifiers;
        this.securityControlCustomParameters = builder.securityControlCustomParameters;
    }

    public final boolean hasEnabledSecurityControlIdentifiers() {
        return this.enabledSecurityControlIdentifiers != null && !(this.enabledSecurityControlIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> enabledSecurityControlIdentifiers() {
        return this.enabledSecurityControlIdentifiers;
    }

    public final boolean hasDisabledSecurityControlIdentifiers() {
        return this.disabledSecurityControlIdentifiers != null && !(this.disabledSecurityControlIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> disabledSecurityControlIdentifiers() {
        return this.disabledSecurityControlIdentifiers;
    }

    public final boolean hasSecurityControlCustomParameters() {
        return this.securityControlCustomParameters != null && !(this.securityControlCustomParameters instanceof SdkAutoConstructList);
    }

    public final List<SecurityControlCustomParameter> securityControlCustomParameters() {
        return this.securityControlCustomParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledSecurityControlIdentifiers() ? this.enabledSecurityControlIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisabledSecurityControlIdentifiers() ? this.disabledSecurityControlIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityControlCustomParameters() ? this.securityControlCustomParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityControlsConfiguration)) {
            return false;
        }
        SecurityControlsConfiguration other = (SecurityControlsConfiguration)obj;
        return this.hasEnabledSecurityControlIdentifiers() == other.hasEnabledSecurityControlIdentifiers() && Objects.equals(this.enabledSecurityControlIdentifiers(), other.enabledSecurityControlIdentifiers()) && this.hasDisabledSecurityControlIdentifiers() == other.hasDisabledSecurityControlIdentifiers() && Objects.equals(this.disabledSecurityControlIdentifiers(), other.disabledSecurityControlIdentifiers()) && this.hasSecurityControlCustomParameters() == other.hasSecurityControlCustomParameters() && Objects.equals(this.securityControlCustomParameters(), other.securityControlCustomParameters());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityControlsConfiguration").add("EnabledSecurityControlIdentifiers", this.hasEnabledSecurityControlIdentifiers() ? this.enabledSecurityControlIdentifiers() : null).add("DisabledSecurityControlIdentifiers", this.hasDisabledSecurityControlIdentifiers() ? this.disabledSecurityControlIdentifiers() : null).add("SecurityControlCustomParameters", this.hasSecurityControlCustomParameters() ? this.securityControlCustomParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnabledSecurityControlIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.enabledSecurityControlIdentifiers()));
            }
            case "DisabledSecurityControlIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.disabledSecurityControlIdentifiers()));
            }
            case "SecurityControlCustomParameters": {
                return Optional.ofNullable(clazz.cast(this.securityControlCustomParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EnabledSecurityControlIdentifiers", ENABLED_SECURITY_CONTROL_IDENTIFIERS_FIELD);
        map.put("DisabledSecurityControlIdentifiers", DISABLED_SECURITY_CONTROL_IDENTIFIERS_FIELD);
        map.put("SecurityControlCustomParameters", SECURITY_CONTROL_CUSTOM_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityControlsConfiguration, T> g) {
        return obj -> g.apply((SecurityControlsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> enabledSecurityControlIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<String> disabledSecurityControlIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<SecurityControlCustomParameter> securityControlCustomParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityControlsConfiguration model) {
            this.enabledSecurityControlIdentifiers(model.enabledSecurityControlIdentifiers);
            this.disabledSecurityControlIdentifiers(model.disabledSecurityControlIdentifiers);
            this.securityControlCustomParameters(model.securityControlCustomParameters);
        }

        public final Collection<String> getEnabledSecurityControlIdentifiers() {
            if (this.enabledSecurityControlIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledSecurityControlIdentifiers;
        }

        public final void setEnabledSecurityControlIdentifiers(Collection<String> enabledSecurityControlIdentifiers) {
            this.enabledSecurityControlIdentifiers = EnabledSecurityControlIdentifierListCopier.copy(enabledSecurityControlIdentifiers);
        }

        @Override
        public final Builder enabledSecurityControlIdentifiers(Collection<String> enabledSecurityControlIdentifiers) {
            this.enabledSecurityControlIdentifiers = EnabledSecurityControlIdentifierListCopier.copy(enabledSecurityControlIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledSecurityControlIdentifiers(String ... enabledSecurityControlIdentifiers) {
            this.enabledSecurityControlIdentifiers(Arrays.asList(enabledSecurityControlIdentifiers));
            return this;
        }

        public final Collection<String> getDisabledSecurityControlIdentifiers() {
            if (this.disabledSecurityControlIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.disabledSecurityControlIdentifiers;
        }

        public final void setDisabledSecurityControlIdentifiers(Collection<String> disabledSecurityControlIdentifiers) {
            this.disabledSecurityControlIdentifiers = DisabledSecurityControlIdentifierListCopier.copy(disabledSecurityControlIdentifiers);
        }

        @Override
        public final Builder disabledSecurityControlIdentifiers(Collection<String> disabledSecurityControlIdentifiers) {
            this.disabledSecurityControlIdentifiers = DisabledSecurityControlIdentifierListCopier.copy(disabledSecurityControlIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disabledSecurityControlIdentifiers(String ... disabledSecurityControlIdentifiers) {
            this.disabledSecurityControlIdentifiers(Arrays.asList(disabledSecurityControlIdentifiers));
            return this;
        }

        public final List<SecurityControlCustomParameter.Builder> getSecurityControlCustomParameters() {
            List<SecurityControlCustomParameter.Builder> result = SecurityControlCustomParametersListCopier.copyToBuilder(this.securityControlCustomParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityControlCustomParameters(Collection<SecurityControlCustomParameter.BuilderImpl> securityControlCustomParameters) {
            this.securityControlCustomParameters = SecurityControlCustomParametersListCopier.copyFromBuilder(securityControlCustomParameters);
        }

        @Override
        public final Builder securityControlCustomParameters(Collection<SecurityControlCustomParameter> securityControlCustomParameters) {
            this.securityControlCustomParameters = SecurityControlCustomParametersListCopier.copy(securityControlCustomParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityControlCustomParameters(SecurityControlCustomParameter ... securityControlCustomParameters) {
            this.securityControlCustomParameters(Arrays.asList(securityControlCustomParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityControlCustomParameters(Consumer<SecurityControlCustomParameter.Builder> ... securityControlCustomParameters) {
            this.securityControlCustomParameters(Stream.of(securityControlCustomParameters).map(c -> (SecurityControlCustomParameter)((SecurityControlCustomParameter.Builder)SecurityControlCustomParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SecurityControlsConfiguration build() {
            return new SecurityControlsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityControlsConfiguration> {
        public Builder enabledSecurityControlIdentifiers(Collection<String> var1);

        public Builder enabledSecurityControlIdentifiers(String ... var1);

        public Builder disabledSecurityControlIdentifiers(Collection<String> var1);

        public Builder disabledSecurityControlIdentifiers(String ... var1);

        public Builder securityControlCustomParameters(Collection<SecurityControlCustomParameter> var1);

        public Builder securityControlCustomParameters(SecurityControlCustomParameter ... var1);

        public Builder securityControlCustomParameters(Consumer<SecurityControlCustomParameter.Builder> ... var1);
    }
}

