/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AssociationStatus;
import software.amazon.awssdk.services.securityhub.model.RelatedRequirementsListCopier;
import software.amazon.awssdk.services.securityhub.model.StandardsControlArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StandardsControlAssociationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StandardsControlAssociationDetail> {
    private static final SdkField<String> STANDARDS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardsArn").getter(StandardsControlAssociationDetail.getter(StandardsControlAssociationDetail::standardsArn)).setter(StandardsControlAssociationDetail.setter(Builder::standardsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsArn").build()}).build();
    private static final SdkField<String> SECURITY_CONTROL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityControlId").getter(StandardsControlAssociationDetail.getter(StandardsControlAssociationDetail::securityControlId)).setter(StandardsControlAssociationDetail.setter(Builder::securityControlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlId").build()}).build();
    private static final SdkField<String> SECURITY_CONTROL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityControlArn").getter(StandardsControlAssociationDetail.getter(StandardsControlAssociationDetail::securityControlArn)).setter(StandardsControlAssociationDetail.setter(Builder::securityControlArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlArn").build()}).build();
    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationStatus").getter(StandardsControlAssociationDetail.getter(StandardsControlAssociationDetail::associationStatusAsString)).setter(StandardsControlAssociationDetail.setter(Builder::associationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatus").build()}).build();
    private static final SdkField<List<String>> RELATED_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedRequirements").getter(StandardsControlAssociationDetail.getter(StandardsControlAssociationDetail::relatedRequirements)).setter(StandardsControlAssociationDetail.setter(Builder::relatedRequirements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedRequirements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(StandardsControlAssociationDetail.getter(StandardsControlAssociationDetail::updatedAt)).setter(StandardsControlAssociationDetail.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdatedReason").getter(StandardsControlAssociationDetail.getter(StandardsControlAssociationDetail::updatedReason)).setter(StandardsControlAssociationDetail.setter(Builder::updatedReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedReason").build()}).build();
    private static final SdkField<String> STANDARDS_CONTROL_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardsControlTitle").getter(StandardsControlAssociationDetail.getter(StandardsControlAssociationDetail::standardsControlTitle)).setter(StandardsControlAssociationDetail.setter(Builder::standardsControlTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsControlTitle").build()}).build();
    private static final SdkField<String> STANDARDS_CONTROL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardsControlDescription").getter(StandardsControlAssociationDetail.getter(StandardsControlAssociationDetail::standardsControlDescription)).setter(StandardsControlAssociationDetail.setter(Builder::standardsControlDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsControlDescription").build()}).build();
    private static final SdkField<List<String>> STANDARDS_CONTROL_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StandardsControlArns").getter(StandardsControlAssociationDetail.getter(StandardsControlAssociationDetail::standardsControlArns)).setter(StandardsControlAssociationDetail.setter(Builder::standardsControlArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsControlArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_ARN_FIELD, SECURITY_CONTROL_ID_FIELD, SECURITY_CONTROL_ARN_FIELD, ASSOCIATION_STATUS_FIELD, RELATED_REQUIREMENTS_FIELD, UPDATED_AT_FIELD, UPDATED_REASON_FIELD, STANDARDS_CONTROL_TITLE_FIELD, STANDARDS_CONTROL_DESCRIPTION_FIELD, STANDARDS_CONTROL_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StandardsControlAssociationDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String standardsArn;
    private final String securityControlId;
    private final String securityControlArn;
    private final String associationStatus;
    private final List<String> relatedRequirements;
    private final Instant updatedAt;
    private final String updatedReason;
    private final String standardsControlTitle;
    private final String standardsControlDescription;
    private final List<String> standardsControlArns;

    private StandardsControlAssociationDetail(BuilderImpl builder) {
        this.standardsArn = builder.standardsArn;
        this.securityControlId = builder.securityControlId;
        this.securityControlArn = builder.securityControlArn;
        this.associationStatus = builder.associationStatus;
        this.relatedRequirements = builder.relatedRequirements;
        this.updatedAt = builder.updatedAt;
        this.updatedReason = builder.updatedReason;
        this.standardsControlTitle = builder.standardsControlTitle;
        this.standardsControlDescription = builder.standardsControlDescription;
        this.standardsControlArns = builder.standardsControlArns;
    }

    public final String standardsArn() {
        return this.standardsArn;
    }

    public final String securityControlId() {
        return this.securityControlId;
    }

    public final String securityControlArn() {
        return this.securityControlArn;
    }

    public final AssociationStatus associationStatus() {
        return AssociationStatus.fromValue(this.associationStatus);
    }

    public final String associationStatusAsString() {
        return this.associationStatus;
    }

    public final boolean hasRelatedRequirements() {
        return this.relatedRequirements != null && !(this.relatedRequirements instanceof SdkAutoConstructList);
    }

    public final List<String> relatedRequirements() {
        return this.relatedRequirements;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedReason() {
        return this.updatedReason;
    }

    public final String standardsControlTitle() {
        return this.standardsControlTitle;
    }

    public final String standardsControlDescription() {
        return this.standardsControlDescription;
    }

    public final boolean hasStandardsControlArns() {
        return this.standardsControlArns != null && !(this.standardsControlArns instanceof SdkAutoConstructList);
    }

    public final List<String> standardsControlArns() {
        return this.standardsControlArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.standardsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityControlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityControlArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedRequirements() ? this.relatedRequirements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardsControlTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardsControlDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStandardsControlArns() ? this.standardsControlArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardsControlAssociationDetail)) {
            return false;
        }
        StandardsControlAssociationDetail other = (StandardsControlAssociationDetail)obj;
        return Objects.equals(this.standardsArn(), other.standardsArn()) && Objects.equals(this.securityControlId(), other.securityControlId()) && Objects.equals(this.securityControlArn(), other.securityControlArn()) && Objects.equals(this.associationStatusAsString(), other.associationStatusAsString()) && this.hasRelatedRequirements() == other.hasRelatedRequirements() && Objects.equals(this.relatedRequirements(), other.relatedRequirements()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedReason(), other.updatedReason()) && Objects.equals(this.standardsControlTitle(), other.standardsControlTitle()) && Objects.equals(this.standardsControlDescription(), other.standardsControlDescription()) && this.hasStandardsControlArns() == other.hasStandardsControlArns() && Objects.equals(this.standardsControlArns(), other.standardsControlArns());
    }

    public final String toString() {
        return ToString.builder((String)"StandardsControlAssociationDetail").add("StandardsArn", (Object)this.standardsArn()).add("SecurityControlId", (Object)this.securityControlId()).add("SecurityControlArn", (Object)this.securityControlArn()).add("AssociationStatus", (Object)this.associationStatusAsString()).add("RelatedRequirements", this.hasRelatedRequirements() ? this.relatedRequirements() : null).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedReason", (Object)this.updatedReason()).add("StandardsControlTitle", (Object)this.standardsControlTitle()).add("StandardsControlDescription", (Object)this.standardsControlDescription()).add("StandardsControlArns", this.hasStandardsControlArns() ? this.standardsControlArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardsArn": {
                return Optional.ofNullable(clazz.cast(this.standardsArn()));
            }
            case "SecurityControlId": {
                return Optional.ofNullable(clazz.cast(this.securityControlId()));
            }
            case "SecurityControlArn": {
                return Optional.ofNullable(clazz.cast(this.securityControlArn()));
            }
            case "AssociationStatus": {
                return Optional.ofNullable(clazz.cast(this.associationStatusAsString()));
            }
            case "RelatedRequirements": {
                return Optional.ofNullable(clazz.cast(this.relatedRequirements()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "UpdatedReason": {
                return Optional.ofNullable(clazz.cast(this.updatedReason()));
            }
            case "StandardsControlTitle": {
                return Optional.ofNullable(clazz.cast(this.standardsControlTitle()));
            }
            case "StandardsControlDescription": {
                return Optional.ofNullable(clazz.cast(this.standardsControlDescription()));
            }
            case "StandardsControlArns": {
                return Optional.ofNullable(clazz.cast(this.standardsControlArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StandardsArn", STANDARDS_ARN_FIELD);
        map.put("SecurityControlId", SECURITY_CONTROL_ID_FIELD);
        map.put("SecurityControlArn", SECURITY_CONTROL_ARN_FIELD);
        map.put("AssociationStatus", ASSOCIATION_STATUS_FIELD);
        map.put("RelatedRequirements", RELATED_REQUIREMENTS_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("UpdatedReason", UPDATED_REASON_FIELD);
        map.put("StandardsControlTitle", STANDARDS_CONTROL_TITLE_FIELD);
        map.put("StandardsControlDescription", STANDARDS_CONTROL_DESCRIPTION_FIELD);
        map.put("StandardsControlArns", STANDARDS_CONTROL_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StandardsControlAssociationDetail, T> g) {
        return obj -> g.apply((StandardsControlAssociationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String standardsArn;
        private String securityControlId;
        private String securityControlArn;
        private String associationStatus;
        private List<String> relatedRequirements = DefaultSdkAutoConstructList.getInstance();
        private Instant updatedAt;
        private String updatedReason;
        private String standardsControlTitle;
        private String standardsControlDescription;
        private List<String> standardsControlArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StandardsControlAssociationDetail model) {
            this.standardsArn(model.standardsArn);
            this.securityControlId(model.securityControlId);
            this.securityControlArn(model.securityControlArn);
            this.associationStatus(model.associationStatus);
            this.relatedRequirements(model.relatedRequirements);
            this.updatedAt(model.updatedAt);
            this.updatedReason(model.updatedReason);
            this.standardsControlTitle(model.standardsControlTitle);
            this.standardsControlDescription(model.standardsControlDescription);
            this.standardsControlArns(model.standardsControlArns);
        }

        public final String getStandardsArn() {
            return this.standardsArn;
        }

        public final void setStandardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
        }

        @Override
        public final Builder standardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
            return this;
        }

        public final String getSecurityControlId() {
            return this.securityControlId;
        }

        public final void setSecurityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
        }

        @Override
        public final Builder securityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
            return this;
        }

        public final String getSecurityControlArn() {
            return this.securityControlArn;
        }

        public final void setSecurityControlArn(String securityControlArn) {
            this.securityControlArn = securityControlArn;
        }

        @Override
        public final Builder securityControlArn(String securityControlArn) {
            this.securityControlArn = securityControlArn;
            return this;
        }

        public final String getAssociationStatus() {
            return this.associationStatus;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        @Override
        public final Builder associationStatus(AssociationStatus associationStatus) {
            this.associationStatus(associationStatus == null ? null : associationStatus.toString());
            return this;
        }

        public final Collection<String> getRelatedRequirements() {
            if (this.relatedRequirements instanceof SdkAutoConstructList) {
                return null;
            }
            return this.relatedRequirements;
        }

        public final void setRelatedRequirements(Collection<String> relatedRequirements) {
            this.relatedRequirements = RelatedRequirementsListCopier.copy(relatedRequirements);
        }

        @Override
        public final Builder relatedRequirements(Collection<String> relatedRequirements) {
            this.relatedRequirements = RelatedRequirementsListCopier.copy(relatedRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedRequirements(String ... relatedRequirements) {
            this.relatedRequirements(Arrays.asList(relatedRequirements));
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedReason() {
            return this.updatedReason;
        }

        public final void setUpdatedReason(String updatedReason) {
            this.updatedReason = updatedReason;
        }

        @Override
        public final Builder updatedReason(String updatedReason) {
            this.updatedReason = updatedReason;
            return this;
        }

        public final String getStandardsControlTitle() {
            return this.standardsControlTitle;
        }

        public final void setStandardsControlTitle(String standardsControlTitle) {
            this.standardsControlTitle = standardsControlTitle;
        }

        @Override
        public final Builder standardsControlTitle(String standardsControlTitle) {
            this.standardsControlTitle = standardsControlTitle;
            return this;
        }

        public final String getStandardsControlDescription() {
            return this.standardsControlDescription;
        }

        public final void setStandardsControlDescription(String standardsControlDescription) {
            this.standardsControlDescription = standardsControlDescription;
        }

        @Override
        public final Builder standardsControlDescription(String standardsControlDescription) {
            this.standardsControlDescription = standardsControlDescription;
            return this;
        }

        public final Collection<String> getStandardsControlArns() {
            if (this.standardsControlArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.standardsControlArns;
        }

        public final void setStandardsControlArns(Collection<String> standardsControlArns) {
            this.standardsControlArns = StandardsControlArnListCopier.copy(standardsControlArns);
        }

        @Override
        public final Builder standardsControlArns(Collection<String> standardsControlArns) {
            this.standardsControlArns = StandardsControlArnListCopier.copy(standardsControlArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsControlArns(String ... standardsControlArns) {
            this.standardsControlArns(Arrays.asList(standardsControlArns));
            return this;
        }

        public StandardsControlAssociationDetail build() {
            return new StandardsControlAssociationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StandardsControlAssociationDetail> {
        public Builder standardsArn(String var1);

        public Builder securityControlId(String var1);

        public Builder securityControlArn(String var1);

        public Builder associationStatus(String var1);

        public Builder associationStatus(AssociationStatus var1);

        public Builder relatedRequirements(Collection<String> var1);

        public Builder relatedRequirements(String ... var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedReason(String var1);

        public Builder standardsControlTitle(String var1);

        public Builder standardsControlDescription(String var1);

        public Builder standardsControlArns(Collection<String> var1);

        public Builder standardsControlArns(String ... var1);
    }
}

