/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AssociationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StandardsControlAssociationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StandardsControlAssociationUpdate> {
    private static final SdkField<String> STANDARDS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardsArn").getter(StandardsControlAssociationUpdate.getter(StandardsControlAssociationUpdate::standardsArn)).setter(StandardsControlAssociationUpdate.setter(Builder::standardsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsArn").build()}).build();
    private static final SdkField<String> SECURITY_CONTROL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityControlId").getter(StandardsControlAssociationUpdate.getter(StandardsControlAssociationUpdate::securityControlId)).setter(StandardsControlAssociationUpdate.setter(Builder::securityControlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlId").build()}).build();
    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationStatus").getter(StandardsControlAssociationUpdate.getter(StandardsControlAssociationUpdate::associationStatusAsString)).setter(StandardsControlAssociationUpdate.setter(Builder::associationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatus").build()}).build();
    private static final SdkField<String> UPDATED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdatedReason").getter(StandardsControlAssociationUpdate.getter(StandardsControlAssociationUpdate::updatedReason)).setter(StandardsControlAssociationUpdate.setter(Builder::updatedReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_ARN_FIELD, SECURITY_CONTROL_ID_FIELD, ASSOCIATION_STATUS_FIELD, UPDATED_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StandardsControlAssociationUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String standardsArn;
    private final String securityControlId;
    private final String associationStatus;
    private final String updatedReason;

    private StandardsControlAssociationUpdate(BuilderImpl builder) {
        this.standardsArn = builder.standardsArn;
        this.securityControlId = builder.securityControlId;
        this.associationStatus = builder.associationStatus;
        this.updatedReason = builder.updatedReason;
    }

    public final String standardsArn() {
        return this.standardsArn;
    }

    public final String securityControlId() {
        return this.securityControlId;
    }

    public final AssociationStatus associationStatus() {
        return AssociationStatus.fromValue(this.associationStatus);
    }

    public final String associationStatusAsString() {
        return this.associationStatus;
    }

    public final String updatedReason() {
        return this.updatedReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.standardsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityControlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardsControlAssociationUpdate)) {
            return false;
        }
        StandardsControlAssociationUpdate other = (StandardsControlAssociationUpdate)obj;
        return Objects.equals(this.standardsArn(), other.standardsArn()) && Objects.equals(this.securityControlId(), other.securityControlId()) && Objects.equals(this.associationStatusAsString(), other.associationStatusAsString()) && Objects.equals(this.updatedReason(), other.updatedReason());
    }

    public final String toString() {
        return ToString.builder((String)"StandardsControlAssociationUpdate").add("StandardsArn", (Object)this.standardsArn()).add("SecurityControlId", (Object)this.securityControlId()).add("AssociationStatus", (Object)this.associationStatusAsString()).add("UpdatedReason", (Object)this.updatedReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardsArn": {
                return Optional.ofNullable(clazz.cast(this.standardsArn()));
            }
            case "SecurityControlId": {
                return Optional.ofNullable(clazz.cast(this.securityControlId()));
            }
            case "AssociationStatus": {
                return Optional.ofNullable(clazz.cast(this.associationStatusAsString()));
            }
            case "UpdatedReason": {
                return Optional.ofNullable(clazz.cast(this.updatedReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("StandardsArn", STANDARDS_ARN_FIELD);
        map.put("SecurityControlId", SECURITY_CONTROL_ID_FIELD);
        map.put("AssociationStatus", ASSOCIATION_STATUS_FIELD);
        map.put("UpdatedReason", UPDATED_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StandardsControlAssociationUpdate, T> g) {
        return obj -> g.apply((StandardsControlAssociationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String standardsArn;
        private String securityControlId;
        private String associationStatus;
        private String updatedReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StandardsControlAssociationUpdate model) {
            this.standardsArn(model.standardsArn);
            this.securityControlId(model.securityControlId);
            this.associationStatus(model.associationStatus);
            this.updatedReason(model.updatedReason);
        }

        public final String getStandardsArn() {
            return this.standardsArn;
        }

        public final void setStandardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
        }

        @Override
        public final Builder standardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
            return this;
        }

        public final String getSecurityControlId() {
            return this.securityControlId;
        }

        public final void setSecurityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
        }

        @Override
        public final Builder securityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
            return this;
        }

        public final String getAssociationStatus() {
            return this.associationStatus;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        @Override
        public final Builder associationStatus(AssociationStatus associationStatus) {
            this.associationStatus(associationStatus == null ? null : associationStatus.toString());
            return this;
        }

        public final String getUpdatedReason() {
            return this.updatedReason;
        }

        public final void setUpdatedReason(String updatedReason) {
            this.updatedReason = updatedReason;
        }

        @Override
        public final Builder updatedReason(String updatedReason) {
            this.updatedReason = updatedReason;
            return this;
        }

        public StandardsControlAssociationUpdate build() {
            return new StandardsControlAssociationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StandardsControlAssociationUpdate> {
        public Builder standardsArn(String var1);

        public Builder securityControlId(String var1);

        public Builder associationStatus(String var1);

        public Builder associationStatus(AssociationStatus var1);

        public Builder updatedReason(String var1);
    }
}

